/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.netbeans.html.boot.fx.FXConsole;
import org.netbeans.html.boot.fx.FXPresenter;

public class FXBrwsr
extends Application {
    private static final Logger LOG = Logger.getLogger(FXBrwsr.class.getName());
    private static FXBrwsr INSTANCE;
    private static final CountDownLatch FINISHED;
    private BorderPane root;
    private Stage stage;

    public static synchronized WebView findWebView(final URL url, final FXPresenter onLoad) {
        if (INSTANCE == null) {
            Executors.newFixedThreadPool(1).submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        FXBrwsr.launch(FXBrwsr.class, (String[])new String[0]);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        FINISHED.countDown();
                    }
                }
            });
        }
        while (INSTANCE == null) {
            try {
                FXBrwsr.class.wait();
            }
            catch (InterruptedException ex) {}
        }
        if (!Platform.isFxApplicationThread()) {
            final WebView[] arr = new WebView[]{null};
            final CountDownLatch waitForResult = new CountDownLatch(1);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    arr[0] = INSTANCE.newView(url, onLoad);
                    waitForResult.countDown();
                }
            });
            while (true) {
                try {
                    waitForResult.await();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.INFO, null, ex);
                    continue;
                }
                break;
            }
            return arr[0];
        }
        return INSTANCE.newView(url, onLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Stage primaryStage) throws Exception {
        Class<FXBrwsr> clazz = FXBrwsr.class;
        synchronized (FXBrwsr.class) {
            INSTANCE = this;
            FXBrwsr.class.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            BorderPane r = new BorderPane();
            Scene scene = new Scene((Parent)r, 800.0, 600.0);
            primaryStage.setScene(scene);
            primaryStage.show();
            this.root = r;
            this.stage = primaryStage;
            return;
        }
    }

    private WebView newView(final URL url, final FXPresenter onLoad) {
        final WebView view = new WebView();
        view.setContextMenuEnabled(false);
        view.getEngine().setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> t) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)FXBrwsr.this.stage);
                ResourceBundle r = ResourceBundle.getBundle("org/netbeans/html/boot/fx/Bundle");
                dialogStage.setTitle(r.getString("AlertTitle"));
                Button button = new Button(r.getString("AlertCloseButton"));
                Text text = new Text((String)t.getData());
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(new Insets(10.0));
                box.getChildren().addAll((Object[])new Node[]{text, button});
                dialogStage.setScene(new Scene((Parent)box));
                button.setCancelButton(true);
                button.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
            }
        });
        view.getEngine().setConfirmHandler((Callback)new Callback<String, Boolean>(){

            public Boolean call(String question) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)FXBrwsr.this.stage);
                ResourceBundle r = ResourceBundle.getBundle("org/netbeans/html/boot/fx/Bundle");
                dialogStage.setTitle(r.getString("ConfirmTitle"));
                Button ok = new Button(r.getString("ConfirmOKButton"));
                Button cancel = new Button(r.getString("ConfirmCancelButton"));
                Text text = new Text(question);
                Insets ins = new Insets(10.0);
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(ins);
                HBox buttons = new HBox(10.0);
                buttons.getChildren().addAll((Object[])new Node[]{ok, cancel});
                buttons.setAlignment(Pos.CENTER);
                buttons.setPadding(ins);
                box.getChildren().addAll((Object[])new Node[]{text, buttons});
                dialogStage.setScene(new Scene((Parent)box));
                ok.setCancelButton(false);
                boolean[] res = new boolean[1];
                ok.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, res));
                cancel.setCancelButton(true);
                cancel.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
                return res[0];
            }
        });
        view.getEngine().setPromptHandler((Callback)new Callback<PromptData, String>(){

            public String call(PromptData prompt) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)FXBrwsr.this.stage);
                ResourceBundle r = ResourceBundle.getBundle("org/netbeans/html/boot/fx/Bundle");
                dialogStage.setTitle(r.getString("PromptTitle"));
                Button ok = new Button(r.getString("PromptOKButton"));
                Button cancel = new Button(r.getString("PromptCancelButton"));
                Text text = new Text(prompt.getMessage());
                TextField line = new TextField();
                if (prompt.getDefaultValue() != null) {
                    line.setText(prompt.getDefaultValue());
                }
                Insets ins = new Insets(10.0);
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(ins);
                HBox buttons = new HBox(10.0);
                buttons.getChildren().addAll((Object[])new Node[]{ok, cancel});
                buttons.setAlignment(Pos.CENTER);
                buttons.setPadding(ins);
                box.getChildren().addAll((Object[])new Node[]{text, line, buttons});
                dialogStage.setScene(new Scene((Parent)box));
                ok.setCancelButton(false);
                boolean[] res = new boolean[1];
                ok.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, res));
                cancel.setCancelButton(true);
                cancel.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
                return res[0] ? line.getText() : null;
            }
        });
        this.root.setCenter((Node)view);
        final Worker w = view.getEngine().getLoadWorker();
        w.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){
            private String previous;

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State newState) {
                if (newState.equals((Object)Worker.State.SUCCEEDED) && this.checkValid()) {
                    FXConsole.register(view.getEngine());
                    onLoad.onPageLoad();
                }
                if (newState.equals((Object)Worker.State.FAILED)) {
                    throw new IllegalStateException("Failed to load " + url);
                }
            }

            private boolean checkValid() {
                String crnt = view.getEngine().getLocation();
                if (this.previous != null && !this.previous.equals(crnt)) {
                    w.stateProperty().removeListener((ChangeListener)this);
                    return false;
                }
                this.previous = crnt;
                return true;
            }
        });
        return view;
    }

    static void waitFinished() {
        while (true) {
            try {
                FINISHED.await();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.INFO, null, ex);
                continue;
            }
            break;
        }
    }

    static {
        FINISHED = new CountDownLatch(1);
    }

    private static final class CloseDialogHandler
    implements EventHandler<ActionEvent> {
        private final Stage dialogStage;
        private final boolean[] res;

        public CloseDialogHandler(Stage dialogStage, boolean[] res) {
            this.dialogStage = dialogStage;
            this.res = res;
        }

        public void handle(ActionEvent t) {
            this.dialogStage.close();
            if (this.res != null) {
                this.res[0] = true;
            }
        }
    }
}

