/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.netbeans.html.boot.fx.FXInspect;
import org.netbeans.html.boot.fx.FXPresenter;
import org.netbeans.html.boot.fx.FXToolbar;
import org.netbeans.html.boot.spi.Fn;

public abstract class AbstractFXPresenter
implements Fn.Presenter,
Fn.KeepAlive,
Fn.ToJavaScript,
Fn.FromJavaScript,
Executor,
Cloneable {
    static final Logger LOG = Logger.getLogger(FXPresenter.class.getName());
    protected static int cnt;
    protected Runnable onLoad;
    protected WebEngine engine;
    private JSObject arraySize;
    private JSObject wrapArrImpl;

    protected AbstractFXPresenter clone() {
        try {
            AbstractFXPresenter p = (AbstractFXPresenter)super.clone();
            p.arraySize = null;
            p.wrapArrImpl = null;
            return p;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Fn defineFn(String code, String ... names) {
        return this.defineJSFn(code, names, null);
    }

    public Fn defineFn(String code, String[] names, boolean[] keepAlive) {
        return this.defineJSFn(code, names, keepAlive);
    }

    final JSFn defineJSFn(String code, String[] names, boolean[] keepAlive) {
        StringBuilder sb = new StringBuilder();
        sb.append("(function() {");
        sb.append("  return function(");
        String sep = "";
        if (names != null) {
            for (String n : names) {
                sb.append(sep).append(n);
                sep = ",";
            }
        }
        sb.append(") {\n");
        sb.append(code);
        sb.append("};");
        sb.append("})()");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "defining function #{0}:\n{1}\n", new Object[]{++cnt, code});
        }
        JSObject x = (JSObject)this.engine.executeScript(sb.toString());
        return new JSFn(this, x, cnt, keepAlive);
    }

    public void loadScript(Reader code) throws Exception {
        String l;
        BufferedReader r = new BufferedReader(code);
        StringBuilder sb = new StringBuilder();
        while ((l = r.readLine()) != null) {
            sb.append(l).append('\n');
        }
        String script = sb.toString();
        this.engine.executeScript(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onPageLoad() {
        Closeable c = Fn.activate((Fn.Presenter)this.clone());
        try {
            this.onLoad.run();
        }
        finally {
            try {
                c.close();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public void displayPage(final URL resource, Runnable onLoad) {
        this.onLoad = onLoad;
        final WebView view = this.findView(resource);
        this.engine = view.getEngine();
        boolean inspectOn = false;
        try {
            if (FXInspect.initialize(this.engine)) {
                inspectOn = true;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        final boolean isInspectOn = inspectOn;
        class Run
        implements Runnable {
            Run() {
            }

            @Override
            public void run() {
                if (isInspectOn) {
                    BorderPane bp;
                    view.setContextMenuEnabled(true);
                    Parent p = view.getParent();
                    if (p instanceof BorderPane && (bp = (BorderPane)p).getTop() == null) {
                        bp.setTop((Node)new FXToolbar(view, bp));
                    }
                }
                AbstractFXPresenter.this.engine.load(resource.toExternalForm());
            }
        }
        Run run = new Run();
        if (Platform.isFxApplicationThread()) {
            run.run();
        } else {
            Platform.runLater((Runnable)run);
        }
        this.waitFinished();
    }

    protected abstract void waitFinished();

    protected abstract WebView findView(URL var1);

    final JSObject convertArrays(Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] instanceof Object[])) continue;
            arr[i] = this.convertArrays((Object[])arr[i]);
        }
        JSObject wrapArr = (JSObject)this.wrapArrFn().call("array", arr);
        return wrapArr;
    }

    private final JSObject wrapArrFn() {
        if (this.wrapArrImpl == null) {
            try {
                this.wrapArrImpl = (JSObject)this.defineJSFn("  var k = {};  k.array= function() {    return Array.prototype.slice.call(arguments);  };  return k;", null, null).invokeImpl(null, false, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.wrapArrImpl;
    }

    final Object checkArray(Object val) {
        if (!(val instanceof JSObject)) {
            return val;
        }
        int length = ((Number)this.arraySizeFn().call("array", val, null)).intValue();
        if (length == -1) {
            return val;
        }
        Object[] arr = new Object[length];
        this.arraySizeFn().call("array", val, arr);
        return arr;
    }

    private final JSObject arraySizeFn() {
        if (this.arraySize == null) {
            try {
                this.arraySize = (JSObject)this.defineJSFn("  var k = {};  k.array = function(arr, to) {    if (to === null) {      if (Object.prototype.toString.call(arr) === '[object Array]') return arr.length;      else return -1;    } else {      var l = arr.length;      for (var i = 0; i < l; i++) to[i] = arr[i];      return l;    }  };  return k;", null, null).invokeImpl(null, false, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.arraySize;
    }

    public Object toJava(Object jsArray) {
        if (jsArray instanceof Weak) {
            jsArray = ((Weak)jsArray).get();
        }
        return this.checkArray(jsArray);
    }

    public Object toJavaScript(Object toReturn) {
        if (toReturn instanceof Object[]) {
            return this.convertArrays((Object[])toReturn);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final Runnable r) {
        if (Platform.isFxApplicationThread()) {
            Closeable c = Fn.activate((Fn.Presenter)this);
            try {
                r.run();
            }
            finally {
                try {
                    c.close();
                }
                catch (IOException iOException) {}
            }
        }
        class Wrap
        implements Runnable {
            Wrap() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Closeable c = Fn.activate((Fn.Presenter)AbstractFXPresenter.this);
                try {
                    r.run();
                }
                finally {
                    try {
                        c.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Platform.runLater((Runnable)new Wrap());
    }

    private static boolean isJSReady(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Number) {
            return true;
        }
        if (obj instanceof JSObject) {
            return true;
        }
        return obj instanceof Character;
    }

    private static final class Weak
    extends WeakReference<Object> {
        public Weak(Object referent) {
            super(referent);
            assert (!(referent instanceof Weak));
        }
    }

    private static final class JSFn
    extends Fn {
        private final JSObject fn;
        private static int call;
        private final int id;
        private final boolean[] keepAlive;

        public JSFn(AbstractFXPresenter p, JSObject fn, int id, boolean[] keepAlive) {
            super((Fn.Presenter)p);
            this.fn = fn;
            this.id = id;
            this.keepAlive = keepAlive;
        }

        public Object invoke(Object thiz, Object ... args) throws Exception {
            return this.invokeImpl(thiz, true, args);
        }

        final Object invokeImpl(Object thiz, boolean arrayChecks, Object ... args) throws Exception {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "calling {0} function #{1}", new Object[]{++call, this.id});
                    LOG.log(Level.FINER, "  thiz  : {0}", thiz);
                    LOG.log(Level.FINER, "  params: {0}", Arrays.asList(args));
                }
                ArrayList<Object> all = new ArrayList<Object>(args.length + 1);
                all.add(thiz == null ? this.fn : thiz);
                for (int i = 0; i < args.length; ++i) {
                    Object conv = args[i];
                    if (arrayChecks) {
                        if (args[i] instanceof Object[]) {
                            Object[] arr = (Object[])args[i];
                            conv = ((AbstractFXPresenter)this.presenter()).convertArrays(arr);
                        }
                        if (!(conv == null || this.keepAlive == null || this.keepAlive[i] || AbstractFXPresenter.isJSReady(conv) || conv.getClass().getSimpleName().equals("$JsCallbacks$"))) {
                            conv = new Weak(conv);
                        }
                    }
                    all.add(conv);
                }
                Object ret = this.fn.call("call", all.toArray());
                if (ret instanceof Weak) {
                    ret = ((Weak)ret).get();
                }
                if (ret == this.fn) {
                    return null;
                }
                if (!arrayChecks) {
                    return ret;
                }
                return ((AbstractFXPresenter)this.presenter()).checkArray(ret);
            }
            catch (Error t) {
                t.printStackTrace();
                throw t;
            }
            catch (Exception t) {
                t.printStackTrace();
                throw t;
            }
        }
    }
}

