/**
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2013-2014 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Oracle. Portions Copyright 2013-2016 Oracle. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.html.boot.fx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;

/**
 *
 * @author Jaroslav Tulach
 */
final class WatchDir implements Runnable {
    private final Path dir;
    private final WatchKey key;
    private final WatchService ws; 
    private final Thread watcher;
    private final WebEngine engine;
    
    WatchDir(WebEngine eng) throws URISyntaxException, IOException {
        URI loc = new URI(eng.getLocation());
        if (loc.getFragment() != null) {
            loc = new URI(loc.getScheme(), loc.getHost(), loc.getPath(), null);
        }
        dir = Paths.get(loc).getParent();
        engine = eng;
        ws = dir.getFileSystem().newWatchService();
        key = dir.register(ws, 
            StandardWatchEventKinds.ENTRY_CREATE,
            StandardWatchEventKinds.ENTRY_DELETE,
            StandardWatchEventKinds.ENTRY_MODIFY
        );
        watcher = new Thread(this, "Watching files in " + dir);
        watcher.setDaemon(true);
        watcher.setPriority(Thread.MIN_PRIORITY);
        watcher.start();
    }

    public void close() throws IOException {
        key.cancel();
        ws.close();
        watcher.interrupt();
    }

    @Override
    public void run() {
        if (Platform.isFxApplicationThread()) {
            engine.reload();
            return;
        }
        try {
            while (key.isValid()) {
                WatchKey changed;
                try {
                    changed = ws.take();
                    if (changed != key || changed.pollEvents().isEmpty()) {
                        continue;
                    }
                } catch (ClosedWatchServiceException ex) {
                    continue;
                }
                Platform.runLater(this);
                if (!key.reset()) {
                    break;
                }
            }
        } catch (InterruptedException ex) {
            FXInspect.LOG.log(Level.SEVERE, null, ex);
        }
    }
}
