/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.netbeans.html.boot.fx.FXInspect;
import org.netbeans.html.boot.fx.FXPresenter;
import org.netbeans.html.boot.fx.FXToolbar;
import org.netbeans.html.boot.spi.Fn;

public abstract class AbstractFXPresenter
implements Fn.Presenter,
Fn.KeepAlive,
Fn.ToJavaScript,
Fn.FromJavaScript,
Executor,
Cloneable {
    static final Logger LOG = Logger.getLogger(FXPresenter.class.getName());
    protected static int cnt;
    protected Runnable onLoad;
    protected WebEngine engine;
    private JSObject arraySize;
    private JSObject wrapArrImpl;
    private JSObject newPOJOImpl;
    private Object undefined;
    private JavaValues values;

    protected AbstractFXPresenter clone() {
        try {
            AbstractFXPresenter p = (AbstractFXPresenter)super.clone();
            p.arraySize = null;
            p.wrapArrImpl = null;
            p.undefined = null;
            p.newPOJOImpl = null;
            p.values = null;
            return p;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Fn defineFn(String code, String ... names) {
        return this.defineJSFn(code, names, null);
    }

    public Fn defineFn(String code, String[] names, boolean[] keepAlive) {
        return this.defineJSFn(code, names, keepAlive);
    }

    final JSFn defineJSFn(String code, String[] names, boolean[] keepAlive) {
        StringBuilder sb = new StringBuilder();
        sb.append("(function() {\n");
        sb.append("  return function(\n    ");
        String sep = "";
        if (names != null) {
            for (String n : names) {
                sb.append(sep).append(n);
                sep = ",";
            }
        }
        sb.append("  \n) {\n");
        sb.append(code);
        sb.append("};\n");
        sb.append("})();\n");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "defining function #{0}:\n{1}\n", new Object[]{++cnt, code});
        }
        JSObject x = (JSObject)this.engine.executeScript(sb.toString());
        return new JSFn(this, x, cnt, keepAlive);
    }

    public void loadScript(Reader code) throws Exception {
        String l;
        BufferedReader r = new BufferedReader(code);
        StringBuilder sb = new StringBuilder();
        while ((l = r.readLine()) != null) {
            sb.append(l).append('\n');
        }
        String script = sb.toString();
        this.engine.executeScript(script);
    }

    protected final void onPageLoad() {
        Closeable c = Fn.activate((Fn.Presenter)this.clone());
        try {
            this.onLoad.run();
        }
        finally {
            try {
                c.close();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }

    public void displayPage(final URL resource, Runnable onLoad) {
        this.onLoad = onLoad;
        final WebView view = this.findView(resource);
        this.engine = view.getEngine();
        boolean inspectOn = false;
        try {
            if (FXInspect.initialize(this.engine)) {
                inspectOn = true;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        final boolean isFirebugOn = Boolean.getBoolean("firebug.lite");
        final boolean isInspectOn = inspectOn;
        class Run
        implements Runnable {
            Run() {
            }

            @Override
            public void run() {
                if (isInspectOn || isFirebugOn) {
                    BorderPane bp;
                    view.setContextMenuEnabled(true);
                    Parent p = view.getParent();
                    if (p instanceof BorderPane && (bp = (BorderPane)p).getTop() == null) {
                        bp.setTop((Node)new FXToolbar(view, bp, isFirebugOn));
                    }
                }
                AbstractFXPresenter.this.engine.load(resource.toExternalForm());
            }
        }
        Run run = new Run();
        if (Platform.isFxApplicationThread()) {
            run.run();
        } else {
            Platform.runLater((Runnable)run);
        }
        this.waitFinished();
    }

    protected abstract void waitFinished();

    protected abstract WebView findView(URL var1);

    final JSObject convertArrays(Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] instanceof Object[])) continue;
            arr[i] = this.convertArrays((Object[])arr[i]);
        }
        JSObject wrapArr = (JSObject)this.wrapArrFn().call("array", arr);
        return wrapArr;
    }

    private final JavaValues values() {
        if (this.values == null) {
            this.values = new JavaValues();
        }
        return this.values;
    }

    private final JSObject wrapArrFn() {
        if (this.wrapArrImpl == null) {
            try {
                this.wrapArrImpl = (JSObject)this.defineJSFn("  var k = {};  k.array= function() {    return Array.prototype.slice.call(arguments);  };  return k;", null, null).invokeImpl(null, false, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.wrapArrImpl;
    }

    JSObject createPOJOWrapper(int hash, int id) {
        if (this.newPOJOImpl == null) {
            try {
                this.newPOJOImpl = (JSObject)this.defineJSFn("var k = {};\nk.fxBrwsrId = function(hash, id) {\n  return {\n    'fxBrwsrId' : function(callback) { callback.hashAndId(hash, id); }\n  }\n};\nreturn k;\n", new String[]{"callback"}, null).invokeImpl(null, false, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return (JSObject)this.newPOJOImpl.call("fxBrwsrId", hash, id);
    }

    final Object undefined() {
        if (this.undefined == null) {
            this.undefined = this.engine.executeScript("undefined");
        }
        return this.undefined;
    }

    private int getArrayLength(Object val) throws JSException {
        int length = ((Number)this.arraySizeFn().call("array", val, null)).intValue();
        return length;
    }

    private Object[] toArray(int length, Object val) throws JSException {
        Object[] arr = new Object[length];
        this.arraySizeFn().call("array", val, arr);
        this.checkArray(arr);
        return arr;
    }

    private void checkArray(Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.toJava(arr[i]);
        }
    }

    private final JSObject arraySizeFn() {
        if (this.arraySize == null) {
            try {
                this.arraySize = (JSObject)this.defineJSFn("  var k = {};  k.array = function(arr, to) {    if (to === null) {      if (Object.prototype.toString.call(arr) === '[object Array]') return arr.length;      else return -1;    } else {      var l = arr.length;      for (var i = 0; i < l; i++) to[i] = arr[i];      return l;    }  };  return k;", null, null).invokeImpl(null, false, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.arraySize;
    }

    public Object toJava(Object toJS) {
        if (toJS == this.undefined()) {
            return null;
        }
        if (!(toJS instanceof JSObject)) {
            return toJS;
        }
        JSObject js = (JSObject)toJS;
        int length = this.getArrayLength(toJS);
        if (length != -1) {
            Object[] arr = this.toArray(length, toJS);
            return arr;
        }
        return this.values().realValue(js);
    }

    public Object toJavaScript(Object value) {
        return this.toJavaScript(value, true);
    }

    final Object toJavaScript(Object value, boolean keep) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof JSObject) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Character) {
            return (int)((Character)value).charValue();
        }
        if (value instanceof Enum) {
            return value;
        }
        int len = this.isArray(value);
        if (len >= 0) {
            Object[] copy = new Object[len];
            for (int i = 0; i < len; ++i) {
                copy[i] = this.toJavaScript(Array.get(value, i));
            }
            JSObject wrapArr = (JSObject)this.wrapArrFn().call("array", copy);
            return wrapArr;
        }
        if (value.getClass().getName().endsWith("$JsCallbacks$")) {
            return value;
        }
        return this.values().wrap(value, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final Runnable r) {
        if (Platform.isFxApplicationThread()) {
            Closeable c = Fn.activate((Fn.Presenter)this);
            try {
                r.run();
            }
            finally {
                try {
                    c.close();
                }
                catch (IOException iOException) {}
            }
        }
        class Wrap
        implements Runnable {
            Wrap() {
            }

            @Override
            public void run() {
                Closeable c = Fn.activate((Fn.Presenter)AbstractFXPresenter.this);
                try {
                    r.run();
                }
                finally {
                    try {
                        c.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Platform.runLater((Runnable)new Wrap());
    }

    protected int isArray(Object value) {
        try {
            return Array.getLength(value);
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    public final class JavaValues {
        private final Map<Integer, NavigableSet<Ref>> values = new HashMap<Integer, NavigableSet<Ref>>();
        private int hash;
        private int id;

        JavaValues() {
        }

        final synchronized JSObject wrap(Object pojo, boolean keep) {
            int hash = System.identityHashCode(pojo);
            NavigableSet<Ref> refs = this.values.get(hash);
            if (refs != null) {
                for (Ref ref : refs) {
                    if (ref.value() != pojo) continue;
                    return ref.jsObj();
                }
            } else {
                refs = new TreeSet<Ref>();
                this.values.put(hash, refs);
            }
            int id = this.findId(refs);
            JSObject js = AbstractFXPresenter.this.createPOJOWrapper(hash, id);
            Ref newRef = keep ? new StrongRef(pojo, id, js) : new WeakRef(pojo, id, js);
            refs.add(newRef);
            return newRef.jsObj();
        }

        private int findId(NavigableSet<Ref> refs) {
            if (refs.isEmpty()) {
                return 0;
            }
            Ref first = (Ref)refs.first();
            int previous = first.id();
            if (previous > 0) {
                return 0;
            }
            for (Ref ref : refs.tailSet(first, false)) {
                int next = ref.id();
                if (previous + 1 < next) {
                    return previous + 1;
                }
                previous = next;
            }
            return previous + 1;
        }

        public void hashAndId(int hash, int id) {
            assert (this.hash == -1);
            assert (this.id == -1);
            this.hash = hash;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object realValue(JSObject obj) {
            Object java = obj.getMember("fxBrwsrId");
            if (java instanceof JSObject) {
                while (true) {
                    int resultId;
                    int resultHash;
                    JavaValues javaValues = this;
                    synchronized (javaValues) {
                        this.hash = -1;
                        this.id = -1;
                        obj.call("fxBrwsrId", this);
                        assert (this.hash != -1);
                        assert (this.id != -1);
                        resultHash = this.hash;
                        resultId = this.id;
                    }
                    NavigableSet<Ref> refs = this.values.get(resultHash);
                    Iterator<Ref> it = refs.iterator();
                    while (it.hasNext()) {
                        Ref next = it.next();
                        Object pojo = next.value();
                        if (next.id() == resultId) {
                            return pojo;
                        }
                        if (pojo != null) continue;
                        it.remove();
                    }
                    if (!refs.isEmpty()) continue;
                    this.values.remove(resultHash);
                }
            }
            return obj;
        }
    }

    private final class StrongRef
    implements Ref {
        private final Object value;
        private final int id;
        private final JSObject js;

        StrongRef(Object value, int id, JSObject js) {
            this.value = value;
            this.id = id;
            this.js = js;
        }

        @Override
        public Object value() {
            return this.value;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public JSObject jsObj() {
            return this.js;
        }

        @Override
        public int compareTo(Ref o) {
            return this.id() - o.id();
        }
    }

    private final class WeakRef
    extends WeakReference<Object>
    implements Ref {
        private final int id;
        private final JSObject js;

        WeakRef(Object value, int id, JSObject js) {
            super(value);
            this.id = id;
            this.js = js;
        }

        @Override
        public Object value() {
            return this.get();
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public JSObject jsObj() {
            return this.js;
        }

        @Override
        public int compareTo(Ref o) {
            return this.id() - o.id();
        }
    }

    private static interface Ref
    extends Comparable<Ref> {
        public Object value();

        public int id();

        public JSObject jsObj();
    }

    private static final class JSFn
    extends Fn {
        private final JSObject fn;
        private static int call;
        private final int id;
        private final boolean[] keepAlive;

        public JSFn(AbstractFXPresenter p, JSObject fn, int id, boolean[] keepAlive) {
            super((Fn.Presenter)p);
            this.fn = fn;
            this.id = id;
            this.keepAlive = keepAlive;
        }

        public Object invoke(Object thiz, Object ... args) throws Exception {
            return this.invokeImpl(thiz, true, args);
        }

        final Object invokeImpl(Object thiz, boolean arrayChecks, Object ... args) throws Exception {
            try {
                AbstractFXPresenter presenter = (AbstractFXPresenter)this.presenter();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "calling {0} function #{1}", new Object[]{++call, this.id});
                    LOG.log(Level.FINER, "  thiz  : {0}", thiz);
                    LOG.log(Level.FINER, "  params: {0}", Arrays.asList(args));
                }
                ArrayList<Object> all = new ArrayList<Object>(args.length + 1);
                all.add(thiz == null ? presenter.undefined() : presenter.toJavaScript(thiz, true));
                for (int i = 0; i < args.length; ++i) {
                    Object conv = args[i];
                    if (arrayChecks) {
                        boolean alive = this.keepAlive == null || this.keepAlive[i];
                        conv = presenter.toJavaScript(conv, alive);
                    }
                    all.add(conv);
                }
                Object ret = this.fn.call("call", all.toArray());
                if (ret == presenter.undefined()) {
                    return null;
                }
                if (!arrayChecks) {
                    return ret;
                }
                return presenter.toJava(ret);
            }
            catch (Error t) {
                t.printStackTrace();
                throw t;
            }
            catch (Exception t) {
                t.printStackTrace();
                throw t;
            }
        }
    }
}

