/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.netbeans.html.boot.fx.FXConsole;
import org.netbeans.html.boot.fx.FXPresenter;

public class FXBrwsr
extends Application {
    private static final Logger LOG = Logger.getLogger(FXBrwsr.class.getName());
    private static FXBrwsr INSTANCE;
    private static final CountDownLatch FINISHED;
    private BorderPane root;
    private Stage stage;

    public static synchronized WebView findWebView(final URL url, final FXPresenter onLoad) {
        if (INSTANCE == null) {
            final String callee = FXBrwsr.findCalleeClassName();
            Executors.newFixedThreadPool(1).submit(new Runnable(){

                @Override
                public void run() {
                    if (!Platform.isFxApplicationThread()) {
                        try {
                            Platform.runLater((Runnable)this);
                        }
                        catch (IllegalStateException ex) {
                            try {
                                FXBrwsr.launch(FXBrwsr.class, (String[])new String[]{callee});
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            finally {
                                FINISHED.countDown();
                            }
                        }
                    } else {
                        FXBrwsr brwsr = new FXBrwsr();
                        brwsr.start(new Stage(), callee);
                        INSTANCE = brwsr;
                        FINISHED.countDown();
                    }
                }
            });
        }
        while (INSTANCE == null) {
            try {
                FXBrwsr.class.wait();
            }
            catch (InterruptedException callee) {}
        }
        if (!Platform.isFxApplicationThread()) {
            final WebView[] arr = new WebView[]{null};
            final CountDownLatch waitForResult = new CountDownLatch(1);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    arr[0] = INSTANCE.newView(url, onLoad);
                    waitForResult.countDown();
                }
            });
            while (true) {
                try {
                    waitForResult.await();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.INFO, null, ex);
                    continue;
                }
                break;
            }
            return arr[0];
        }
        return INSTANCE.newView(url, onLoad);
    }

    static synchronized Stage findStage() throws InterruptedException {
        while (INSTANCE == null) {
            FXBrwsr.class.wait();
        }
        return FXBrwsr.INSTANCE.stage;
    }

    public void start(Stage primaryStage) throws Exception {
        this.start(primaryStage, (String)this.getParameters().getRaw().get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start(Stage primaryStage, String callee) {
        BorderPane r = new BorderPane();
        Object[] arr = FXBrwsr.findInitialSize(callee);
        Scene scene = new Scene((Parent)r, ((Double)arr[2]).doubleValue(), ((Double)arr[3]).doubleValue());
        primaryStage.setScene(scene);
        this.root = r;
        this.stage = primaryStage;
        Class<FXBrwsr> clazz = FXBrwsr.class;
        synchronized (FXBrwsr.class) {
            INSTANCE = this;
            FXBrwsr.class.notifyAll();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            primaryStage.setX(((Double)arr[0]).doubleValue());
            primaryStage.setY(((Double)arr[1]).doubleValue());
            if (arr[4] != null) {
                scene.getWindow().setOnCloseRequest((EventHandler)arr[4]);
            }
            if (Boolean.getBoolean("fxpresenter.headless")) {
                return;
            }
            primaryStage.show();
            return;
        }
    }

    static String findCalleeClassName() {
        StackTraceElement[] frames;
        for (StackTraceElement e : frames = new Exception().getStackTrace()) {
            String cn = e.getClassName();
            if (cn.startsWith("org.netbeans.html.") || cn.startsWith("net.java.html.") || cn.startsWith("java.") || cn.startsWith("javafx.") || cn.startsWith("com.sun.")) continue;
            return cn;
        }
        return "org.netbeans.html";
    }

    private static Object[] findInitialSize(String callee) {
        final Preferences prefs = Preferences.userRoot().node(callee.replace('.', '/'));
        Rectangle2D screen = Screen.getPrimary().getBounds();
        double x = prefs.getDouble("x", screen.getWidth() * 0.05);
        double y = prefs.getDouble("y", screen.getHeight() * 0.05);
        double width = prefs.getDouble("width", screen.getWidth() * 0.9);
        double height = prefs.getDouble("height", screen.getHeight() * 0.9);
        Object[] arr = new Object[]{x, y, width, height, null};
        if (!callee.equals("org.netbeans.html")) {
            arr[4] = new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Window window = (Window)event.getSource();
                    prefs.putDouble("x", window.getX());
                    prefs.putDouble("y", window.getY());
                    prefs.putDouble("width", window.getWidth());
                    prefs.putDouble("height", window.getHeight());
                }
            };
        }
        return arr;
    }

    private WebView newView(final URL url, final FXPresenter onLoad) {
        BorderPane bp;
        Stage newStage;
        final WebView view = new WebView();
        view.setContextMenuEnabled(false);
        if (this.root == null) {
            newStage = new Stage();
            newStage.initOwner((Window)this.stage);
            bp = new BorderPane();
            newStage.setScene(new Scene((Parent)bp));
            newStage.show();
        } else {
            bp = this.root;
            newStage = this.stage;
            this.root = null;
        }
        FXBrwsr.attachHandlers(view, newStage);
        bp.setCenter((Node)view);
        final Worker w = view.getEngine().getLoadWorker();
        w.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){
            private String previous;

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State newState) {
                if (newState.equals((Object)Worker.State.SUCCEEDED) && this.checkValid()) {
                    FXConsole.register(view.getEngine());
                    onLoad.onPageLoad();
                }
                if (newState.equals((Object)Worker.State.FAILED)) {
                    throw new IllegalStateException("Failed to load " + url);
                }
            }

            private boolean checkValid() {
                String crnt = view.getEngine().getLocation();
                if (this.previous != null && !this.previous.equals(crnt)) {
                    w.stateProperty().removeListener((ChangeListener)this);
                    return false;
                }
                this.previous = crnt;
                return true;
            }
        });
        Title.observeView(view, this.stage);
        return view;
    }

    private static void attachHandlers(WebView view, final Stage owner) {
        view.getEngine().setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> t) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)owner);
                ResourceBundle r = ResourceBundle.getBundle("org/netbeans/html/boot/fx/Bundle");
                dialogStage.setTitle(r.getString("AlertTitle"));
                Button button = new Button(r.getString("AlertCloseButton"));
                Text text = new Text((String)t.getData());
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(new Insets(10.0));
                box.getChildren().addAll((Object[])new Node[]{text, button});
                dialogStage.setScene(new Scene((Parent)box));
                button.setCancelButton(true);
                button.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
            }
        });
        view.getEngine().setConfirmHandler((Callback)new Callback<String, Boolean>(){

            public Boolean call(String question) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)owner);
                ResourceBundle r = ResourceBundle.getBundle("org/netbeans/html/boot/fx/Bundle");
                dialogStage.setTitle(r.getString("ConfirmTitle"));
                Button ok = new Button(r.getString("ConfirmOKButton"));
                Button cancel = new Button(r.getString("ConfirmCancelButton"));
                Text text = new Text(question);
                Insets ins = new Insets(10.0);
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(ins);
                HBox buttons = new HBox(10.0);
                buttons.getChildren().addAll((Object[])new Node[]{ok, cancel});
                buttons.setAlignment(Pos.CENTER);
                buttons.setPadding(ins);
                box.getChildren().addAll((Object[])new Node[]{text, buttons});
                dialogStage.setScene(new Scene((Parent)box));
                ok.setCancelButton(false);
                boolean[] res = new boolean[1];
                ok.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, res));
                cancel.setCancelButton(true);
                cancel.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
                return res[0];
            }
        });
        view.getEngine().setPromptHandler((Callback)new Callback<PromptData, String>(){

            public String call(PromptData prompt) {
                Stage dialogStage = new Stage();
                dialogStage.initModality(Modality.WINDOW_MODAL);
                dialogStage.initOwner((Window)owner);
                ResourceBundle r = ResourceBundle.getBundle("org/netbeans/html/boot/fx/Bundle");
                dialogStage.setTitle(r.getString("PromptTitle"));
                Button ok = new Button(r.getString("PromptOKButton"));
                Button cancel = new Button(r.getString("PromptCancelButton"));
                Text text = new Text(prompt.getMessage());
                TextField line = new TextField();
                if (prompt.getDefaultValue() != null) {
                    line.setText(prompt.getDefaultValue());
                }
                Insets ins = new Insets(10.0);
                VBox box = new VBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(10.0);
                box.setPadding(ins);
                HBox buttons = new HBox(10.0);
                buttons.getChildren().addAll((Object[])new Node[]{ok, cancel});
                buttons.setAlignment(Pos.CENTER);
                buttons.setPadding(ins);
                box.getChildren().addAll((Object[])new Node[]{text, line, buttons});
                dialogStage.setScene(new Scene((Parent)box));
                ok.setCancelButton(false);
                boolean[] res = new boolean[1];
                ok.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, res));
                cancel.setCancelButton(true);
                cancel.setOnAction((EventHandler)new CloseDialogHandler(dialogStage, null));
                dialogStage.centerOnScreen();
                dialogStage.showAndWait();
                return res[0] ? line.getText() : null;
            }
        });
        view.getEngine().setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

            public WebEngine call(PopupFeatures param) {
                Stage stage = new Stage(StageStyle.UTILITY);
                stage.initOwner((Window)owner);
                WebView popUpView = new WebView();
                stage.setScene(new Scene((Parent)popUpView));
                Title.observeView(popUpView, stage);
                stage.show();
                return popUpView.getEngine();
            }
        });
    }

    static void waitFinished() {
        while (true) {
            try {
                FINISHED.await();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.INFO, null, ex);
                continue;
            }
            break;
        }
    }

    static {
        FINISHED = new CountDownLatch(1);
    }

    private static class Title
    implements ChangeListener<String> {
        private String title;
        private final WebView view;
        private final Stage stage;

        private Title(WebView view, Stage stage) {
            this.view = view;
            this.stage = stage;
        }

        public static void observeView(WebView view, Stage stage) {
            Title t = new Title(view, stage);
            view.getEngine().titleProperty().addListener((ChangeListener)t);
            t.changed(null, null, null);
        }

        public void changed(ObservableValue<? extends String> ov, String t, String t1) {
            this.title = this.view.getEngine().getTitle();
            if (this.title != null) {
                this.stage.setTitle(this.title);
            }
        }
    }

    private static final class CloseDialogHandler
    implements EventHandler<ActionEvent> {
        private final Stage dialogStage;
        private final boolean[] res;

        public CloseDialogHandler(Stage dialogStage, boolean[] res) {
            this.dialogStage = dialogStage;
            this.res = res;
        }

        public void handle(ActionEvent t) {
            this.dialogStage.close();
            if (this.res != null) {
                this.res[0] = true;
            }
        }
    }
}

