/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.boot.script;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.html.boot.spi.Fn;

final class ScriptPresenter
implements Fn.KeepAlive,
Fn.Presenter,
Fn.FromJavaScript,
Fn.ToJavaScript,
Executor {
    private static final Logger LOG;
    private static final boolean JDK7;
    private final ScriptEngine eng;
    private final Executor exc;
    private final Object undefined;
    private FnImpl wrapArrImpl;
    private FnImpl arraySize;

    ScriptPresenter(Executor exc) {
        this(new ScriptEngineManager().getEngineByName("javascript"), exc);
    }

    ScriptPresenter(ScriptEngine eng, Executor exc) {
        this.eng = eng;
        this.exc = exc;
        try {
            eng.eval("function alert(msg) { Packages.java.lang.System.out.println(msg); };");
            eng.eval("function confirm(msg) { Packages.java.lang.System.out.println(msg); return true; };");
            eng.eval("function prompt(msg, txt) { Packages.java.lang.System.out.println(msg + ':' + txt); return txt; };");
            Object undef = JDK7 ? new JDK7Callback().undefined(eng) : ((Object[])eng.eval("Java.to([undefined])"))[0];
            this.undefined = undef;
        }
        catch (ScriptException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Fn defineFn(String code, String ... names) {
        return this.defineImpl(code, names, null);
    }

    public Fn defineFn(String code, String[] names, boolean[] keepAlive) {
        return this.defineImpl(code, names, keepAlive);
    }

    private FnImpl defineImpl(String code, String[] names, boolean[] keepAlive) {
        Object fn;
        StringBuilder sb = new StringBuilder();
        sb.append("(function() {\n");
        sb.append("  return function(");
        String sep = "";
        if (names != null) {
            for (String n : names) {
                sb.append(sep).append(n);
                sep = ",";
            }
        }
        sb.append(") {\n");
        sb.append(code);
        sb.append("\n  };\n");
        sb.append("})()\n");
        try {
            fn = this.eng.eval(sb.toString());
        }
        catch (ScriptException ex) {
            throw new IllegalStateException(ex);
        }
        return new FnImpl(this, fn, keepAlive);
    }

    public void displayPage(URL page, Runnable onPageLoad) {
        try {
            this.eng.eval("if (typeof window !== 'undefined') window.location = '" + page + "'");
        }
        catch (ScriptException ex) {
            LOG.log(Level.SEVERE, "Cannot load " + page, ex);
        }
        if (onPageLoad != null) {
            onPageLoad.run();
        }
    }

    public void loadScript(Reader code) throws Exception {
        this.eng.eval(code);
    }

    final Object convertArrays(Object[] arr) throws Exception {
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] instanceof Object[])) continue;
            arr[i] = this.convertArrays((Object[])arr[i]);
        }
        Object wrapArr = this.wrapArrFn().invokeImpl(null, false, arr);
        return wrapArr;
    }

    private FnImpl wrapArrFn() {
        if (this.wrapArrImpl == null) {
            try {
                this.wrapArrImpl = this.defineImpl("return Array.prototype.slice.call(arguments);", null, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.wrapArrImpl;
    }

    final Object checkArray(Object val) throws Exception {
        if (val instanceof Boolean || val instanceof Number || val instanceof String) {
            return val;
        }
        FnImpl fn = this.arraySizeFn();
        Object fnRes = fn.invokeImpl(null, false, val, null);
        int length = ((Number)fnRes).intValue();
        if (length == -1) {
            return val;
        }
        Object[] arr = new Object[length];
        fn.invokeImpl(null, false, val, arr);
        return arr;
    }

    private FnImpl arraySizeFn() {
        if (this.arraySize == null) {
            try {
                this.arraySize = this.defineImpl("\nif (to == null) {\n  if (Object.prototype.toString.call(arr) === '[object Array]') return arr.length;\n  else return -1;\n} else {\n  var l = arr.length;\n  for (var i = 0; i < l; i++) {\n    to[i] = arr[i] === undefined ? null : arr[i];\n  }\n  return l;\n}", new String[]{"arr", "to"}, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.arraySize;
    }

    public Object toJava(Object toJS) {
        if (toJS instanceof Weak) {
            toJS = ((Weak)toJS).get();
        }
        if (toJS == this.undefined) {
            return null;
        }
        try {
            return this.checkArray(toJS);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Object toJavaScript(Object toReturn) {
        if (toReturn instanceof Object[]) {
            try {
                return this.convertArrays((Object[])toReturn);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (JDK7 && toReturn instanceof Boolean) {
            return (Boolean)toReturn != false ? Boolean.valueOf(true) : null;
        }
        return toReturn;
    }

    @Override
    public void execute(final Runnable command) {
        if (Fn.activePresenter() == this) {
            command.run();
            return;
        }
        class Wrap
        implements Runnable {
            Wrap() {
            }

            @Override
            public void run() {
                try (Closeable c = Fn.activate((Fn.Presenter)ScriptPresenter.this);){
                    command.run();
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        Wrap wrap = new Wrap();
        if (this.exc == null) {
            wrap.run();
        } else {
            this.exc.execute(wrap);
        }
    }

    private static boolean isJSReady(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Number) {
            return true;
        }
        String cn = obj.getClass().getName();
        if (cn.startsWith("com.oracle.truffle") || cn.startsWith("jdk.nashorn") || cn.contains(".mozilla.") && cn.contains(".Native")) {
            return true;
        }
        return obj instanceof Character;
    }

    static {
        boolean jdk7;
        LOG = Logger.getLogger(ScriptPresenter.class.getName());
        try {
            Class.forName("java.lang.FunctionalInterface");
            jdk7 = false;
        }
        catch (ClassNotFoundException ex) {
            jdk7 = true;
        }
        JDK7 = jdk7;
    }

    private static final class JDK7Callback
    implements ObjectOutput {
        private Object undefined;

        private JDK7Callback() {
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            this.undefined = obj;
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
        }

        @Override
        public void writeByte(int v) throws IOException {
        }

        @Override
        public void writeShort(int v) throws IOException {
        }

        @Override
        public void writeChar(int v) throws IOException {
        }

        @Override
        public void writeInt(int v) throws IOException {
        }

        @Override
        public void writeLong(long v) throws IOException {
        }

        @Override
        public void writeFloat(float v) throws IOException {
        }

        @Override
        public void writeDouble(double v) throws IOException {
        }

        @Override
        public void writeBytes(String s) throws IOException {
        }

        @Override
        public void writeChars(String s) throws IOException {
        }

        @Override
        public void writeUTF(String s) throws IOException {
        }

        public Object undefined(ScriptEngine eng) {
            try {
                eng.eval("function isJDK7Undefined(js) { js.writeObject(undefined); }");
                Invocable inv = (Invocable)((Object)eng);
                inv.invokeFunction("isJDK7Undefined", this);
            }
            catch (NoSuchMethodException | ScriptException ex) {
                throw new IllegalStateException(ex);
            }
            return this.undefined;
        }
    }

    private static final class Weak
    extends WeakReference<Object> {
        public Weak(Object referent) {
            super(referent);
        }
    }

    private class FnImpl
    extends Fn {
        private final Object fn;
        private final boolean[] keepAlive;

        public FnImpl(Fn.Presenter presenter, Object fn, boolean[] keepAlive) {
            super(presenter);
            this.fn = fn;
            this.keepAlive = keepAlive;
        }

        public Object invoke(Object thiz, Object ... args) throws Exception {
            return this.invokeImpl(thiz, true, args);
        }

        final Object invokeImpl(Object thiz, boolean arrayChecks, Object ... args) throws Exception {
            ArrayList<Object> all = new ArrayList<Object>(args.length + 1);
            all.add(thiz == null ? this.fn : thiz);
            for (int i = 0; i < args.length; ++i) {
                Object conv = args[i];
                if (arrayChecks) {
                    if (args[i] instanceof Object[]) {
                        Object[] arr = (Object[])args[i];
                        conv = ((ScriptPresenter)this.presenter()).convertArrays(arr);
                    }
                    if (!(conv == null || this.keepAlive == null || this.keepAlive[i] || ScriptPresenter.isJSReady(conv) || conv.getClass().getSimpleName().equals("$JsCallbacks$"))) {
                        conv = new Weak(conv);
                    }
                    if (conv instanceof Character) {
                        conv = (int)((Character)conv).charValue();
                    }
                }
                all.add(conv);
            }
            Object ret = ((Invocable)((Object)ScriptPresenter.this.eng)).invokeMethod(this.fn, "call", all.toArray());
            if (ret instanceof Weak) {
                ret = ((Weak)ret).get();
            }
            if (ret == this.fn) {
                return null;
            }
            if (!arrayChecks) {
                return ret;
            }
            return ((ScriptPresenter)this.presenter()).checkArray(ret);
        }
    }
}

