/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;
import org.apidesign.html.boot.spi.Fn;

public final class FnContext
implements Closeable {
    private static final Logger LOG = Logger.getLogger(FnContext.class.getName());
    private Object prev;
    private static final ThreadLocal<Fn.Presenter> CURRENT = new ThreadLocal();

    private FnContext(Fn.Presenter p) {
        this.prev = p;
    }

    @Override
    public void close() throws IOException {
        if (this.prev != this) {
            FnContext.currentPresenter((Fn.Presenter)this.prev);
            this.prev = this;
        }
    }

    public static Closeable activate(Fn.Presenter newP) {
        return new FnContext(FnContext.currentPresenter(newP));
    }

    public static Fn.Presenter currentPresenter(Fn.Presenter p) {
        Fn.Presenter prev = CURRENT.get();
        CURRENT.set(p);
        return prev;
    }

    public static Fn.Presenter currentPresenter(boolean fail) {
        Fn.Presenter p = CURRENT.get();
        if (p == null && fail) {
            throw new IllegalStateException("No current WebView context around!");
        }
        return p;
    }
}

