/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.boot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.html.BrwsrCtx;
import org.apidesign.html.boot.spi.Fn;
import org.apidesign.html.context.spi.Contexts;
import org.netbeans.html.boot.impl.FindResources;
import org.netbeans.html.boot.impl.FnContext;
import org.netbeans.html.boot.impl.FnUtils;

public final class BrowserBuilder {
    private static final Logger LOG = Logger.getLogger(BrowserBuilder.class.getName());
    private String resource;
    private Class<?> clazz;
    private Class[] browserClass;
    private Runnable onLoad;
    private String methodName;
    private String[] methodArgs;
    private final Object[] context;

    private BrowserBuilder(Object[] context) {
        this.context = context;
    }

    public static BrowserBuilder newBrowser(Object ... context) {
        return new BrowserBuilder(context);
    }

    public BrowserBuilder loadClass(Class<?> mainClass) {
        this.clazz = mainClass;
        return this;
    }

    public BrowserBuilder loadFinished(Runnable r) {
        this.onLoad = r;
        return this;
    }

    public BrowserBuilder loadPage(String page) {
        this.resource = page;
        return this;
    }

    public BrowserBuilder invoke(String methodName, String ... args) {
        this.methodName = methodName;
        this.methodArgs = args;
        return this;
    }

    public void showAndWait() {
        ClassLoader loader;
        Iterator<Fn.Presenter> i$;
        Class<?> myCls;
        IOException mal;
        URL url;
        block25: {
            ProtectionDomain pd;
            if (this.resource == null) {
                throw new NullPointerException("Need to specify resource via loadPage method");
            }
            url = null;
            mal = null;
            try {
                String baseURL = System.getProperty("browser.rootdir");
                url = baseURL != null ? new File(baseURL, this.resource).toURI().toURL() : new URL(this.resource);
            }
            catch (MalformedURLException ex) {
                mal = ex;
            }
            if (this.clazz != null) {
                myCls = this.clazz;
            } else if (this.onLoad != null) {
                myCls = this.onLoad.getClass();
            } else {
                throw new NullPointerException("loadClass, neither loadFinished was called!");
            }
            if (url == null) {
                url = myCls.getResource(this.resource);
            }
            if (url == null && (pd = myCls.getProtectionDomain()) != null && pd.getCodeSource() != null) {
                URL jar = pd.getCodeSource().getLocation();
                try {
                    url = new URL(jar, this.resource);
                }
                catch (MalformedURLException ex) {
                    ex.initCause(mal);
                    mal = ex;
                }
            }
            if (url == null) {
                URL res = BrowserBuilder.class.getResource("html4j.txt");
                LOG.log(Level.FINE, "Found html4j {0}", res);
                if (res != null) {
                    try {
                        URLConnection c = res.openConnection();
                        LOG.log(Level.FINE, "testing : {0}", c);
                        if (!(c instanceof JarURLConnection)) break block25;
                        JarURLConnection jc = (JarURLConnection)c;
                        URL base = jc.getJarFileURL();
                        for (int i = 0; i < 50; ++i) {
                            URL u = new URL(base, this.resource);
                            try {
                                InputStream is = u.openStream();
                                is.close();
                                url = u;
                                LOG.log(Level.FINE, "found real url: {0}", url);
                                break;
                            }
                            catch (FileNotFoundException ignore) {
                                LOG.log(Level.FINE, "Cannot open " + u, ignore);
                                base = new URL(base, "..");
                                continue;
                            }
                        }
                    }
                    catch (IOException ex) {
                        mal = ex;
                    }
                }
            }
        }
        if (url == null) {
            IllegalStateException ise = new IllegalStateException("Can't find resouce: " + this.resource + " relative to " + myCls);
            if (mal != null) {
                ise.initCause(mal);
            }
            throw ise;
        }
        Fn.Presenter dfnr = null;
        for (Object o : this.context) {
            if (!(o instanceof Fn.Presenter)) continue;
            dfnr = (Fn.Presenter)o;
            break;
        }
        if (dfnr == null && (i$ = ServiceLoader.load(Fn.Presenter.class).iterator()).hasNext()) {
            Fn.Presenter o;
            dfnr = o = i$.next();
        }
        if (dfnr == null) {
            throw new IllegalStateException("Can't find any Fn.Presenter");
        }
        if (FnUtils.isJavaScriptCapable(myCls.getClassLoader())) {
            loader = myCls.getClassLoader();
        } else {
            FImpl impl = new FImpl(myCls.getClassLoader());
            loader = FnUtils.newLoader(impl, dfnr, myCls.getClassLoader().getParent());
        }
        final Fn.Presenter currentP = dfnr;
        class OnPageLoad
        implements Runnable {
            Class<?> newClazz;

            OnPageLoad() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Throwable firstError;
                    block26: {
                        if (this.newClazz == null) {
                            Contexts.Builder cb;
                            Thread.currentThread().setContextClassLoader(loader);
                            this.newClazz = Class.forName(myCls.getName(), true, loader);
                            if (BrowserBuilder.this.browserClass != null) {
                                ((BrowserBuilder)BrowserBuilder.this).browserClass[0] = this.newClazz;
                            }
                            if (!Contexts.fillInByProviders(this.newClazz, (Contexts.Builder)(cb = Contexts.newBuilder()))) {
                                LOG.log(Level.WARNING, "Using empty technology for {0}", this.newClazz);
                            }
                            if (currentP instanceof Executor) {
                                cb.register(Executor.class, (Object)((Executor)((Object)currentP)), 1000);
                            }
                            cb.register(Fn.Presenter.class, (Object)currentP, 1000);
                            BrwsrCtx c = cb.build();
                            c.execute((Runnable)this);
                            return;
                        }
                        firstError = null;
                        if (BrowserBuilder.this.onLoad != null) {
                            try {
                                FnContext.currentPresenter(currentP);
                                BrowserBuilder.this.onLoad.run();
                            }
                            catch (Throwable ex) {
                                firstError = ex;
                            }
                            finally {
                                FnContext.currentPresenter(null);
                            }
                        }
                        if (BrowserBuilder.this.methodName != null) {
                            if (BrowserBuilder.this.methodArgs.length == 0) {
                                try {
                                    Method m = this.newClazz.getMethod(BrowserBuilder.this.methodName, new Class[0]);
                                    FnContext.currentPresenter(currentP);
                                    m.invoke(null, new Object[0]);
                                    firstError = null;
                                    break block26;
                                }
                                catch (Throwable ex) {
                                    firstError = ex;
                                }
                                finally {
                                    FnContext.currentPresenter(null);
                                }
                            }
                            try {
                                Method m = this.newClazz.getMethod(BrowserBuilder.this.methodName, String[].class);
                                FnContext.currentPresenter(currentP);
                                m.invoke((Object)m, new Object[]{BrowserBuilder.this.methodArgs});
                                firstError = null;
                            }
                            catch (Throwable ex) {
                                LOG.log(Level.SEVERE, "Can't call " + BrowserBuilder.this.methodName + " with args " + Arrays.toString(BrowserBuilder.this.methodArgs), ex);
                            }
                            finally {
                                FnContext.currentPresenter(null);
                            }
                        }
                    }
                    if (firstError != null) {
                        LOG.log(Level.SEVERE, "Can't initialize the view", firstError);
                    }
                }
                catch (ClassNotFoundException ex) {
                    LOG.log(Level.SEVERE, "Can't load " + myCls.getName(), ex);
                }
            }
        }
        dfnr.displayPage(url, new OnPageLoad());
    }

    private static final class FImpl
    implements FindResources {
        final ClassLoader l;

        public FImpl(ClassLoader l) {
            this.l = l;
        }

        @Override
        public void findResources(String path, Collection<? super URL> results, boolean oneIsEnough) {
            if (oneIsEnough) {
                URL u = this.l.getResource(path);
                if (u != null) {
                    results.add(u);
                }
            } else {
                try {
                    Enumeration<URL> en = this.l.getResources(path);
                    while (en.hasMoreElements()) {
                        results.add(en.nextElement());
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
    }
}

