/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.logging.Logger;
import org.apidesign.html.boot.spi.Fn;

public final class FnContext
implements Closeable {
    private static final Logger LOG = Logger.getLogger(FnContext.class.getName());
    private static final FnContext DUMMY = new FnContext(null, null);
    private Object prev;
    private final Fn.Presenter current;
    private static final ThreadLocal<Fn.Presenter> CURRENT;

    private FnContext(Fn.Presenter prevP, Fn.Presenter newP) {
        this.current = newP;
        this.prev = prevP;
    }

    @Override
    public void close() throws IOException {
        if (this.prev != this) {
            FnContext.currentPresenter((Fn.Presenter)this.prev);
            this.prev = this;
            if (this.current instanceof Flushable) {
                ((Flushable)((Object)this.current)).flush();
            }
        }
    }

    public static Closeable activate(Fn.Presenter newP) {
        Fn.Presenter oldP = FnContext.currentPresenter(newP);
        if (oldP == newP) {
            return DUMMY;
        }
        return new FnContext(oldP, newP);
    }

    public static Fn.Presenter currentPresenter(Fn.Presenter p) {
        Fn.Presenter prev = CURRENT.get();
        CURRENT.set(p);
        return prev;
    }

    public static Fn.Presenter currentPresenter(boolean fail) {
        Fn.Presenter p = CURRENT.get();
        if (p == null && fail) {
            throw new IllegalStateException("No current WebView context around!");
        }
        return p;
    }

    static {
        FnContext.DUMMY.prev = DUMMY;
        CURRENT = new ThreadLocal();
    }
}

