/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.boot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.html.BrwsrCtx;
import org.netbeans.html.boot.impl.FindResources;
import org.netbeans.html.boot.impl.FnContext;
import org.netbeans.html.boot.impl.FnUtils;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.context.spi.Contexts;

public final class BrowserBuilder {
    private static final Logger LOG = Logger.getLogger(BrowserBuilder.class.getName());
    private String resource;
    private Class<?> clazz;
    private Class[] browserClass;
    private Runnable onLoad;
    private String methodName;
    private String[] methodArgs;
    private final Object[] context;
    private ClassLoader loader;
    private Locale locale;

    private BrowserBuilder(Object[] context) {
        this.context = context;
    }

    public static BrowserBuilder newBrowser(Object ... context) {
        return new BrowserBuilder(context);
    }

    public BrowserBuilder loadClass(Class<?> mainClass) {
        this.clazz = mainClass;
        return this;
    }

    public BrowserBuilder loadFinished(Runnable r) {
        this.onLoad = r;
        return this;
    }

    public BrowserBuilder loadPage(String page) {
        this.resource = page;
        return this;
    }

    public BrowserBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public BrowserBuilder invoke(String methodName, String ... args) {
        this.methodName = methodName;
        this.methodArgs = args;
        return this;
    }

    public BrowserBuilder classloader(ClassLoader l) {
        this.loader = l;
        return this;
    }

    public void showAndWait() {
        ClassLoader activeLoader;
        URL res;
        Iterator<Fn.Presenter> i$;
        Class<?> myCls;
        if (this.resource == null) {
            throw new NullPointerException("Need to specify resource via loadPage method");
        }
        if (this.clazz != null) {
            myCls = this.clazz;
        } else if (this.onLoad != null) {
            myCls = this.onLoad.getClass();
        } else {
            throw new NullPointerException("loadClass, neither loadFinished was called!");
        }
        IOException[] mal = new IOException[]{null};
        URL url = BrowserBuilder.findLocalizedResourceURL(this.resource, this.locale, mal, myCls);
        Fn.Presenter dfnr = null;
        for (Object o : this.context) {
            if (!(o instanceof Fn.Presenter)) continue;
            dfnr = (Fn.Presenter)o;
            break;
        }
        if (dfnr == null && this.loader != null && (i$ = ServiceLoader.load(Fn.Presenter.class, this.loader).iterator()).hasNext()) {
            Fn.Presenter o;
            dfnr = o = i$.next();
        }
        if (dfnr == null && (i$ = ServiceLoader.load(Fn.Presenter.class).iterator()).hasNext()) {
            Fn.Presenter o;
            dfnr = o = i$.next();
        }
        if (dfnr == null) {
            throw new IllegalStateException("Can't find any Fn.Presenter");
        }
        if (this.loader != null) {
            res = FnContext.isJavaScriptCapable(this.loader);
            if (res != null) {
                throw new IllegalStateException("Loader " + this.loader + " cannot resolve @JavaScriptBody, because of " + res);
            }
            activeLoader = this.loader;
        } else {
            res = FnContext.isJavaScriptCapable(myCls.getClassLoader());
            if (res == null) {
                activeLoader = myCls.getClassLoader();
            } else {
                if (!FnContext.isAsmPresent(res)) {
                    throw new IllegalStateException("Cannot find asm-5.0.jar classes!");
                }
                FImpl impl = new FImpl(myCls.getClassLoader());
                activeLoader = FnUtils.newLoader(impl, dfnr, myCls.getClassLoader().getParent());
            }
        }
        final Fn.Presenter dP = dfnr;
        class OnPageLoad
        implements Runnable {
            OnPageLoad() {
            }

            @Override
            public void run() {
                try {
                    Contexts.Builder cb;
                    Fn.Presenter aP = Fn.activePresenter();
                    final Fn.Presenter currentP = aP != null ? aP : dP;
                    Thread.currentThread().setContextClassLoader(activeLoader);
                    final Class<?> newClazz = Class.forName(myCls.getName(), true, activeLoader);
                    if (BrowserBuilder.this.browserClass != null) {
                        ((BrowserBuilder)BrowserBuilder.this).browserClass[0] = newClazz;
                    }
                    if (!Contexts.fillInByProviders(newClazz, (Contexts.Builder)(cb = Contexts.newBuilder((Object[])BrowserBuilder.this.context)))) {
                        LOG.log(Level.WARNING, "Using empty technology for {0}", newClazz);
                    }
                    if (currentP instanceof Executor) {
                        cb.register(Executor.class, (Object)((Executor)((Object)currentP)), 1000);
                    }
                    cb.register(Fn.Presenter.class, (Object)currentP, 1000);
                    BrwsrCtx c = cb.build();
                    class CallInitMethod
                    implements Runnable {
                        CallInitMethod() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Throwable firstError;
                            block20: {
                                firstError = null;
                                if (BrowserBuilder.this.onLoad != null) {
                                    try {
                                        FnContext.currentPresenter(currentP);
                                        BrowserBuilder.this.onLoad.run();
                                    }
                                    catch (Throwable ex) {
                                        firstError = ex;
                                    }
                                    finally {
                                        FnContext.currentPresenter(null);
                                    }
                                }
                                if (BrowserBuilder.this.methodName != null) {
                                    if (BrowserBuilder.this.methodArgs.length == 0) {
                                        try {
                                            Method m = newClazz.getMethod(BrowserBuilder.this.methodName, new Class[0]);
                                            FnContext.currentPresenter(currentP);
                                            m.invoke(null, new Object[0]);
                                            firstError = null;
                                            break block20;
                                        }
                                        catch (Throwable ex) {
                                            firstError = ex;
                                        }
                                        finally {
                                            FnContext.currentPresenter(null);
                                        }
                                    }
                                    try {
                                        Method m = newClazz.getMethod(BrowserBuilder.this.methodName, String[].class);
                                        FnContext.currentPresenter(currentP);
                                        m.invoke((Object)m, new Object[]{BrowserBuilder.this.methodArgs});
                                        firstError = null;
                                    }
                                    catch (Throwable ex) {
                                        LOG.log(Level.SEVERE, "Can't call " + BrowserBuilder.this.methodName + " with args " + Arrays.toString(BrowserBuilder.this.methodArgs), ex);
                                    }
                                    finally {
                                        FnContext.currentPresenter(null);
                                    }
                                }
                            }
                            if (firstError != null) {
                                LOG.log(Level.SEVERE, "Can't initialize the view", firstError);
                            }
                        }
                    }
                    c.execute((Runnable)new CallInitMethod());
                }
                catch (ClassNotFoundException ex) {
                    LOG.log(Level.SEVERE, "Can't load " + myCls.getName(), ex);
                }
            }
        }
        dfnr.displayPage(url, new OnPageLoad());
    }

    private static URL findResourceURL(String resource, String suffix, IOException[] mal, Class<?> relativeTo) {
        if (suffix != null) {
            int lastDot = resource.lastIndexOf(46);
            resource = lastDot != -1 ? resource.substring(0, lastDot) + suffix + resource.substring(lastDot) : resource + suffix;
        }
        URL url = null;
        try {
            URL u;
            String baseURL = System.getProperty("browser.rootdir");
            if (baseURL != null && BrowserBuilder.isReal(u = new File(baseURL, resource).toURI().toURL())) {
                url = u;
            }
            u = new URL(resource);
            if (suffix == null || BrowserBuilder.isReal(u)) {
                url = u;
            }
            return url;
        }
        catch (MalformedURLException ex) {
            block16: {
                ProtectionDomain pd;
                mal[0] = ex;
                if (url == null) {
                    url = relativeTo.getResource(resource);
                }
                if (url == null && (pd = relativeTo.getProtectionDomain()) != null && pd.getCodeSource() != null) {
                    URL jar = pd.getCodeSource().getLocation();
                    try {
                        URL u = new URL(jar, resource);
                        if (BrowserBuilder.isReal(u)) {
                            url = u;
                        }
                    }
                    catch (MalformedURLException ex2) {
                        ex2.initCause(mal[0]);
                        mal[0] = ex2;
                    }
                }
                if (url == null) {
                    URL res = BrowserBuilder.class.getResource("html4j.txt");
                    LOG.log(Level.FINE, "Found html4j {0}", res);
                    if (res != null) {
                        try {
                            URLConnection c = res.openConnection();
                            LOG.log(Level.FINE, "testing : {0}", c);
                            if (!(c instanceof JarURLConnection)) break block16;
                            JarURLConnection jc = (JarURLConnection)c;
                            URL base = jc.getJarFileURL();
                            for (int i = 0; i < 50; ++i) {
                                URL u = new URL(base, resource);
                                if (BrowserBuilder.isReal(u)) {
                                    url = u;
                                    break;
                                }
                                base = new URL(base, "..");
                            }
                        }
                        catch (IOException ex3) {
                            mal[0] = ex3;
                        }
                    }
                }
            }
            return url;
        }
    }

    static URL findLocalizedResourceURL(String resource, Locale l, IOException[] mal, Class<?> relativeTo) {
        URL url = null;
        if (l != null) {
            url = BrowserBuilder.findResourceURL(resource, "_" + l.getLanguage() + "_" + l.getCountry(), mal, relativeTo);
            if (url != null) {
                return url;
            }
            url = BrowserBuilder.findResourceURL(resource, "_" + l.getLanguage(), mal, relativeTo);
        }
        if (url != null) {
            return url;
        }
        return BrowserBuilder.findResourceURL(resource, null, mal, relativeTo);
    }

    private static boolean isReal(URL u) {
        try {
            URLConnection conn = u.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hc = (HttpURLConnection)conn;
                hc.setReadTimeout(5000);
                if (hc.getResponseCode() >= 300) {
                    throw new IOException("Wrong code: " + hc.getResponseCode());
                }
            }
            InputStream is = conn.getInputStream();
            is.close();
            LOG.log(Level.FINE, "found real url: {0}", u);
            return true;
        }
        catch (IOException ignore) {
            LOG.log(Level.FINE, "Cannot open " + u, ignore);
            return false;
        }
    }

    private static final class FImpl
    implements FindResources {
        final ClassLoader l;

        public FImpl(ClassLoader l) {
            this.l = l;
        }

        @Override
        public void findResources(String path, Collection<? super URL> results, boolean oneIsEnough) {
            if (oneIsEnough) {
                URL u = this.l.getResource(path);
                if (u != null) {
                    results.add(u);
                }
            } else {
                try {
                    Enumeration<URL> en = this.l.getResources(path);
                    while (en.hasMoreElements()) {
                        results.add(en.nextElement());
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
    }
}

