/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.html.boot.impl.JsClassLoader;
import org.netbeans.html.boot.spi.Fn;

public final class FnContext
implements Closeable {
    private static final Logger LOG = Logger.getLogger(FnContext.class.getName());
    private static final FnContext DUMMY = new FnContext(null, null);
    private Object prev;
    private final Fn.Presenter current;
    private static final ThreadLocal<Fn.Presenter> CURRENT;

    public static URL isJavaScriptCapable(ClassLoader l) {
        if (l instanceof JsClassLoader) {
            return null;
        }
        return l.getResource("META-INF/net.java.html.js.classes");
    }

    public static boolean isAsmPresent(URL res) {
        Throwable t;
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        try {
            Class.forName("org.objectweb.asm.Opcodes");
            return true;
        }
        catch (LinkageError ex) {
            t = ex;
        }
        catch (ClassNotFoundException ex) {
            t = ex;
        }
        pw.println("When using @JavaScriptBody methods, one needs to either:");
        pw.println(" - include asm-5.0.jar on runtime classpath");
        pw.println(" - post process classes, see http://bits.netbeans.org/html+java/dev/net/java/html/js/package-summary.html#post-process");
        pw.append("However following classes has not been processed from ").println(res);
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(res.openStream()));
            while ((line = r.readLine()) != null) {
                pw.append("  ").println(line);
            }
            r.close();
        }
        catch (IOException io) {
            pw.append("Cannot read ").println(res);
            io.printStackTrace(pw);
        }
        pw.println("Cannot initialize asm-5.0.jar!");
        pw.flush();
        LOG.log(Level.SEVERE, w.toString(), t);
        return false;
    }

    private FnContext(Fn.Presenter prevP, Fn.Presenter newP) {
        this.current = newP;
        this.prev = prevP;
    }

    @Override
    public void close() throws IOException {
        if (this.prev != this) {
            FnContext.currentPresenter((Fn.Presenter)this.prev);
            this.prev = this;
            if (this.current instanceof Flushable) {
                ((Flushable)((Object)this.current)).flush();
            }
        }
    }

    public static Closeable activate(Fn.Presenter newP) {
        Fn.Presenter oldP = FnContext.currentPresenter(newP);
        if (oldP == newP) {
            return DUMMY;
        }
        return new FnContext(oldP, newP);
    }

    public static Fn.Presenter currentPresenter(Fn.Presenter p) {
        Fn.Presenter prev = CURRENT.get();
        CURRENT.set(p);
        return prev;
    }

    public static Fn.Presenter currentPresenter(boolean fail) {
        Fn.Presenter p = CURRENT.get();
        if (p == null && fail) {
            throw new IllegalStateException("No current WebView context around!");
        }
        return p;
    }

    static {
        FnContext.DUMMY.prev = DUMMY;
        CURRENT = new ThreadLocal();
    }
}

