/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.geo.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.java.html.geo.OnLocation;
import net.java.html.geo.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"net.java.html.geo.OnLocation"})
public final class GeoProcessor
extends AbstractProcessor {
    private static final Logger LOG = Logger.getLogger(GeoProcessor.class.getName());

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ok = true;
        for (Element element : roundEnv.getElementsAnnotatedWith(OnLocation.class)) {
            if (this.processLocation(element)) continue;
            ok = false;
        }
        return ok;
    }

    private void error(String msg, Element e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    private boolean processLocation(Element e) {
        if (e.getKind() != ElementKind.METHOD) {
            return false;
        }
        ExecutableElement me = (ExecutableElement)e;
        OnLocation ol = e.getAnnotation(OnLocation.class);
        if (ol == null) {
            return true;
        }
        if (me.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error("Method annotated by @OnLocation cannot be private", e);
            return false;
        }
        TypeMirror positionClass = this.processingEnv.getElementUtils().getTypeElement(Position.class.getName()).asType();
        List<? extends VariableElement> params = me.getParameters();
        if (params.size() < 1 || !params.get(0).asType().equals(positionClass)) {
            this.error("Method annotated by @OnLocation first argument must be net.java.html.geo.Position!", e);
            return false;
        }
        String className = ol.className();
        if (className.isEmpty()) {
            String n = e.getSimpleName().toString();
            if (n.isEmpty()) {
                this.error("Empty method name", e);
                return false;
            }
            String firstLetter = n.substring(0, 1).toUpperCase(Locale.ENGLISH);
            className = firstLetter + n.substring(1) + "Handle";
        }
        TypeElement te = (TypeElement)e.getEnclosingElement();
        PackageElement pe = (PackageElement)te.getEnclosingElement();
        String pkg = pe.getQualifiedName().toString();
        String fqn = pkg + "." + className;
        boolean isStatic = me.getModifiers().contains((Object)Modifier.STATIC);
        try {
            VariableElement p;
            int i;
            String sep;
            String inst;
            VariableElement p2;
            int i2;
            JavaFileObject fo = this.processingEnv.getFiler().createSourceFile(fqn, e);
            Writer w = fo.openWriter();
            w.append("package ").append(pkg).append(";\n");
            w.append("class ").append(className).append(" extends net.java.html.geo.Position.Handle {\n");
            if (!isStatic) {
                w.append("  private final ").append(te.getSimpleName()).append(" $i;\n");
            }
            for (i2 = 1; i2 < params.size(); ++i2) {
                p2 = params.get(i2);
                w.append("  private final ").append(p2.asType().toString()).append(" ").append(p2.getSimpleName()).append(";\n");
            }
            w.append("  private ").append(className).append("(boolean oneTime");
            w.append(", ").append(te.getSimpleName()).append(" i");
            for (i2 = 1; i2 < params.size(); ++i2) {
                p2 = params.get(i2);
                w.append(", ").append(p2.asType().toString()).append(" ").append(p2.getSimpleName());
            }
            w.append(") {\n    super(oneTime);\n");
            if (!isStatic) {
                w.append("    this.$i = i;\n");
            }
            for (i2 = 1; i2 < params.size(); ++i2) {
                p2 = params.get(i2);
                w.append("  this.").append(p2.getSimpleName()).append(" = ").append(p2.getSimpleName()).append(";\n");
            }
            w.append("}\n");
            w.append("  static net.java.html.geo.Position.Handle createQuery(");
            if (!isStatic) {
                w.append(te.getSimpleName()).append(" instance");
                inst = "instance";
                sep = ", ";
            } else {
                inst = "null";
                sep = "";
            }
            for (i = 1; i < params.size(); ++i) {
                p = params.get(i);
                w.append(sep).append(p.asType().toString()).append(" ").append(p.getSimpleName());
                sep = ", ";
            }
            w.append(") { return new ").append(className).append("(true, ").append(inst);
            for (i = 1; i < params.size(); ++i) {
                p = params.get(i);
                w.append(", ").append(p.getSimpleName());
            }
            w.append("); }\n");
            w.append("  static net.java.html.geo.Position.Handle createWatch(");
            if (!isStatic) {
                w.append(te.getSimpleName()).append(" instance");
                sep = ", ";
            } else {
                sep = "";
            }
            for (i = 1; i < params.size(); ++i) {
                p = params.get(i);
                w.append(sep).append(p.asType().toString()).append(" ").append(p.getSimpleName());
            }
            w.append(") { return new ").append(className).append("(false, ").append(inst);
            for (i = 1; i < params.size(); ++i) {
                p = params.get(i);
                w.append(", ").append(p.getSimpleName());
            }
            w.append("); }\n");
            w.append("  @Override protected void onError(Exception t) throws Throwable {\n");
            if (ol.onError().isEmpty()) {
                w.append("    t.printStackTrace();");
            } else {
                if (!this.findOnError(me, te, ol.onError(), isStatic)) {
                    return false;
                }
                if (isStatic) {
                    w.append("    ").append(te.getSimpleName()).append(".");
                } else {
                    w.append("    $i.");
                }
                w.append(ol.onError()).append("(t");
                for (i = 1; i < params.size(); ++i) {
                    p = params.get(i);
                    w.append(", ").append(p.getSimpleName());
                }
                w.append(");\n");
            }
            w.append("  }\n");
            w.append("  @Override protected void onLocation(net.java.html.geo.Position p) throws Throwable {\n");
            if (isStatic) {
                w.append("    ").append(te.getSimpleName()).append(".");
            } else {
                w.append("    $i.");
            }
            w.append(me.getSimpleName()).append("(p");
            for (i = 1; i < params.size(); ++i) {
                p = params.get(i);
                w.append(", ").append(p.getSimpleName());
            }
            w.append(");\n");
            w.append("  }\n");
            w.append("}\n");
            w.close();
        }
        catch (IOException ex) {
            Logger.getLogger(GeoProcessor.class.getName()).log(Level.SEVERE, null, ex);
            this.error("Can't write handler class: " + ex.getMessage(), e);
            return false;
        }
        return true;
    }

    private boolean findOnError(ExecutableElement errElem, TypeElement te, String name, boolean onlyStatic) {
        String err = null;
        block0: for (Element element : te.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(name)) continue;
            if (onlyStatic && !element.getModifiers().contains((Object)Modifier.STATIC)) {
                errElem = (ExecutableElement)element;
                err = "Would have to be static";
                continue;
            }
            ExecutableElement ee = (ExecutableElement)element;
            TypeMirror excType = this.processingEnv.getElementUtils().getTypeElement(Exception.class.getName()).asType();
            List<? extends VariableElement> params = ee.getParameters();
            if (params.size() < 1 || !this.processingEnv.getTypeUtils().isAssignable(excType, ee.getParameters().get(0).asType())) {
                errElem = (ExecutableElement)element;
                err = "Error method first argument needs to be Exception";
                continue;
            }
            List<? extends VariableElement> origParams = errElem.getParameters();
            if (params.size() != origParams.size()) {
                errElem = (ExecutableElement)element;
                err = "Error method must have the same parameters as @OnLocation one";
                continue;
            }
            for (int i = 1; i < origParams.size(); ++i) {
                TypeMirror t1 = params.get(i).asType();
                TypeMirror t2 = ((Element)origParams.get(i)).asType();
                if (this.processingEnv.getTypeUtils().isSameType(t1, t2)) continue;
                errElem = (ExecutableElement)element;
                err = "Error method must have the same parameters as @OnLocation one";
                continue block0;
            }
            return true;
        }
        if (err == null) {
            err = "Cannot find " + name + "(Exception) method in this class";
        }
        this.error(err, errElem);
        return false;
    }
}

