/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.List;
import net.java.html.BrwsrCtx;
import net.java.html.json.tests.KnockoutTest;
import net.java.html.json.tests.Person;
import org.apidesign.html.json.spi.Proto;

public final class KnockoutModel
implements Cloneable {
    private static final Html4JavaType TYPE = new Html4JavaType();
    private final Proto proto;
    private String prop_name;
    private final List<String> prop_results;
    private int prop_callbackCount;
    private final List<Person> prop_people;
    private boolean prop_enabled;
    private double prop_latitude;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Person getFirstPerson() {
        List<Person> arg1 = this.getPeople();
        try {
            this.proto.acquireLock();
            Person person = KnockoutTest.firstPerson(arg1);
            return person;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHelloMessage() {
        String arg1 = this.getName();
        try {
            this.proto.acquireLock();
            String string = KnockoutTest.helloMessage(arg1);
            return string;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCmpResults() {
        List<String> arg1 = this.getResults();
        try {
            this.proto.acquireLock();
            List<String> list = KnockoutTest.cmpResults(arg1);
            return list;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    public String getName() {
        this.proto.verifyUnlocked();
        return this.prop_name;
    }

    public void setName(String v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_name, v)) {
            return;
        }
        String o = this.prop_name;
        this.prop_name = v;
        this.proto.valueHasMutated("name", (Object)o, (Object)v);
        this.proto.valueHasMutated("helloMessage", null, (Object)this.getHelloMessage());
    }

    public List<String> getResults() {
        this.proto.verifyUnlocked();
        return this.prop_results;
    }

    public int getCallbackCount() {
        this.proto.verifyUnlocked();
        return this.prop_callbackCount;
    }

    public void setCallbackCount(int v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_callbackCount, v)) {
            return;
        }
        Integer o = this.prop_callbackCount;
        this.prop_callbackCount = v;
        this.proto.valueHasMutated("callbackCount", (Object)o, (Object)v);
    }

    public List<Person> getPeople() {
        this.proto.verifyUnlocked();
        return this.prop_people;
    }

    public boolean isEnabled() {
        this.proto.verifyUnlocked();
        return this.prop_enabled;
    }

    public void setEnabled(boolean v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_enabled, v)) {
            return;
        }
        Boolean o = this.prop_enabled;
        this.prop_enabled = v;
        this.proto.valueHasMutated("enabled", (Object)o, (Object)v);
    }

    public double getLatitude() {
        this.proto.verifyUnlocked();
        return this.prop_latitude;
    }

    public void setLatitude(double v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_latitude, v)) {
            return;
        }
        Double o = this.prop_latitude;
        this.prop_latitude = v;
        this.proto.valueHasMutated("latitude", (Object)o, (Object)v);
    }

    private static Class<KnockoutTest> modelFor() {
        return null;
    }

    private KnockoutModel(BrwsrCtx context) {
        this.proto = TYPE.createProto(this, context);
        this.prop_results = this.proto.createList("results", -1, new String[]{"cmpResults"});
        this.prop_people = this.proto.createList("people", -1, new String[]{"firstPerson"});
    }

    public KnockoutModel() {
        this(BrwsrCtx.findDefault(KnockoutModel.class));
    }

    public KnockoutModel(String name, int callbackCount, boolean enabled, double latitude, String ... results) {
        this(BrwsrCtx.findDefault(KnockoutModel.class));
        this.prop_name = name;
        this.prop_callbackCount = callbackCount;
        this.prop_enabled = enabled;
        this.prop_latitude = latitude;
        this.proto.initTo(this.prop_results, (Object)results);
    }

    private KnockoutModel(BrwsrCtx c, Object json) {
        this(c);
        Object[] ret = new Object[6];
        this.proto.extract(json, new String[]{"name", "results", "callbackCount", "people", "enabled", "latitude"}, ret);
        this.prop_name = (String)ret[0];
        if (ret[1] instanceof Object[]) {
            for (Object e : (Object[])ret[1]) {
                this.prop_results.add((String)e);
            }
        }
        int n = this.prop_callbackCount = ret[2] == null ? 0 : TYPE.numberValue(ret[2]).intValue();
        if (ret[3] instanceof Object[]) {
            for (Object e : (Object[])ret[3]) {
                this.prop_people.add((Person)this.proto.read(Person.class, e));
            }
        }
        this.prop_enabled = ret[4] == null ? false : TYPE.boolValue(ret[4]);
        this.prop_latitude = ret[5] == null ? 0.0 : TYPE.numberValue(ret[5]).doubleValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append('\"').append("name").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_name));
        sb.append(',');
        sb.append('\"').append("results").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_results));
        sb.append(',');
        sb.append('\"').append("callbackCount").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_callbackCount));
        sb.append(',');
        sb.append('\"').append("people").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_people));
        sb.append(',');
        sb.append('\"').append("enabled").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_enabled));
        sb.append(',');
        sb.append('\"').append("latitude").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_latitude));
        sb.append('}');
        return sb.toString();
    }

    public KnockoutModel clone() {
        return this.clone(this.proto.getContext());
    }

    private KnockoutModel clone(BrwsrCtx ctx) {
        KnockoutModel ret = new KnockoutModel(ctx);
        ret.prop_name = this.prop_name;
        this.proto.cloneList(ret.prop_results, ctx, this.prop_results);
        ret.prop_callbackCount = this.prop_callbackCount;
        this.proto.cloneList(ret.prop_people, ctx, this.prop_people);
        ret.prop_enabled = this.prop_enabled;
        ret.prop_latitude = this.prop_latitude;
        return ret;
    }

    public KnockoutModel applyBindings() {
        this.proto.applyBindings();
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnockoutModel)) {
            return false;
        }
        KnockoutModel p = (KnockoutModel)o;
        if (!TYPE.isSame(this.prop_name, p.prop_name)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_results, p.prop_results)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_callbackCount, p.prop_callbackCount)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_people, p.prop_people)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_enabled, p.prop_enabled)) {
            return false;
        }
        return TYPE.isSame(this.prop_latitude, p.prop_latitude);
    }

    public int hashCode() {
        int h = KnockoutModel.class.getName().hashCode();
        h = TYPE.hashPlus(this.prop_name, h);
        h = TYPE.hashPlus(this.prop_results, h);
        h = TYPE.hashPlus(this.prop_callbackCount, h);
        h = TYPE.hashPlus(this.prop_people, h);
        h = TYPE.hashPlus(this.prop_enabled, h);
        h = TYPE.hashPlus(this.prop_latitude, h);
        return h;
    }

    private static class Html4JavaType
    extends Proto.Type<KnockoutModel> {
        private Html4JavaType() {
            super(KnockoutModel.class, KnockoutTest.class, 9, 2);
            this.registerProperty("firstPerson", 0, true);
            this.registerProperty("helloMessage", 1, true);
            this.registerProperty("cmpResults", 2, true);
            this.registerProperty("name", 3, false);
            this.registerProperty("results", 4, true);
            this.registerProperty("callbackCount", 5, false);
            this.registerProperty("people", 6, true);
            this.registerProperty("enabled", 7, false);
            this.registerProperty("latitude", 8, false);
            this.registerFunction("call", 0);
            this.registerFunction("removePerson", 1);
        }

        public void setValue(KnockoutModel data, int type, Object value) {
            switch (type) {
                case 3: {
                    data.setName((String)TYPE.extractValue(String.class, value));
                    return;
                }
                case 5: {
                    data.setCallbackCount((Integer)TYPE.extractValue(Integer.class, value));
                    return;
                }
                case 7: {
                    data.setEnabled((Boolean)TYPE.extractValue(Boolean.class, value));
                    return;
                }
                case 8: {
                    data.setLatitude((Double)TYPE.extractValue(Double.class, value));
                    return;
                }
            }
        }

        public Object getValue(KnockoutModel data, int type) {
            switch (type) {
                case 0: {
                    return data.getFirstPerson();
                }
                case 1: {
                    return data.getHelloMessage();
                }
                case 2: {
                    return data.getCmpResults();
                }
                case 3: {
                    return data.getName();
                }
                case 4: {
                    return data.getResults();
                }
                case 5: {
                    return data.getCallbackCount();
                }
                case 6: {
                    return data.getPeople();
                }
                case 7: {
                    return data.isEnabled();
                }
                case 8: {
                    return data.getLatitude();
                }
            }
            throw new UnsupportedOperationException();
        }

        public void call(KnockoutModel model, int type, Object data, Object ev) throws Exception {
            switch (type) {
                case 0: {
                    KnockoutTest.call(model, model.proto.toString(data, null));
                    return;
                }
                case 1: {
                    KnockoutTest.removePerson(model, (Person)model.proto.toModel(Person.class, data));
                    return;
                }
            }
            throw new UnsupportedOperationException();
        }

        public Proto protoFor(Object obj) {
            return ((KnockoutModel)obj).proto;
        }

        public void onChange(KnockoutModel model, int type) {
            throw new UnsupportedOperationException();
        }

        public void onMessage(KnockoutModel model, int index, int type, Object data) {
            throw new UnsupportedOperationException("index: " + index + " type: " + type);
        }

        public KnockoutModel read(BrwsrCtx c, Object json) {
            return new KnockoutModel(c, json);
        }

        public KnockoutModel cloneTo(KnockoutModel o, BrwsrCtx c) {
            return o.clone(c);
        }
    }
}

