/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import net.java.html.BrwsrCtx;
import net.java.html.json.tests.JSONTest;
import org.apidesign.html.json.spi.Proto;

public final class NameAndValue
implements Cloneable {
    private static final Html4JavaType TYPE = new Html4JavaType();
    private final Proto proto;
    private String prop_name;
    private long prop_value;
    private byte prop_small;

    public String getName() {
        this.proto.verifyUnlocked();
        return this.prop_name;
    }

    public void setName(String v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_name, v)) {
            return;
        }
        String o = this.prop_name;
        this.prop_name = v;
        this.proto.valueHasMutated("name", (Object)o, (Object)v);
    }

    public long getValue() {
        this.proto.verifyUnlocked();
        return this.prop_value;
    }

    public void setValue(long v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_value, v)) {
            return;
        }
        Long o = this.prop_value;
        this.prop_value = v;
        this.proto.valueHasMutated("value", (Object)o, (Object)v);
    }

    public byte getSmall() {
        this.proto.verifyUnlocked();
        return this.prop_small;
    }

    public void setSmall(byte v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_small, v)) {
            return;
        }
        Byte o = this.prop_small;
        this.prop_small = v;
        this.proto.valueHasMutated("small", (Object)o, (Object)v);
    }

    private static Class<JSONTest.NandV> modelFor() {
        return null;
    }

    private NameAndValue(BrwsrCtx context) {
        this.proto = TYPE.createProto(this, context);
    }

    public NameAndValue() {
        this(BrwsrCtx.findDefault(NameAndValue.class));
    }

    public NameAndValue(String name, long value, byte small) {
        this(BrwsrCtx.findDefault(NameAndValue.class));
        this.prop_name = name;
        this.prop_value = value;
        this.prop_small = small;
    }

    private NameAndValue(BrwsrCtx c, Object json) {
        this(c);
        Object[] ret = new Object[3];
        this.proto.extract(json, new String[]{"name", "value", "small"}, ret);
        this.prop_name = (String)ret[0];
        this.prop_value = ret[1] == null ? 0L : TYPE.numberValue(ret[1]).longValue();
        this.prop_small = ret[2] == null ? (byte)0 : TYPE.numberValue(ret[2]).byteValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append('\"').append("name").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_name));
        sb.append(',');
        sb.append('\"').append("value").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_value));
        sb.append(',');
        sb.append('\"').append("small").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_small));
        sb.append('}');
        return sb.toString();
    }

    public NameAndValue clone() {
        return this.clone(this.proto.getContext());
    }

    private NameAndValue clone(BrwsrCtx ctx) {
        NameAndValue ret = new NameAndValue(ctx);
        ret.prop_name = this.prop_name;
        ret.prop_value = this.prop_value;
        ret.prop_small = this.prop_small;
        return ret;
    }

    public NameAndValue applyBindings() {
        this.proto.applyBindings();
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NameAndValue)) {
            return false;
        }
        NameAndValue p = (NameAndValue)o;
        if (!TYPE.isSame(this.prop_name, p.prop_name)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_value, p.prop_value)) {
            return false;
        }
        return TYPE.isSame(this.prop_small, p.prop_small);
    }

    public int hashCode() {
        int h = NameAndValue.class.getName().hashCode();
        h = TYPE.hashPlus(this.prop_name, h);
        h = TYPE.hashPlus(this.prop_value, h);
        h = TYPE.hashPlus(this.prop_small, h);
        return h;
    }

    private static class Html4JavaType
    extends Proto.Type<NameAndValue> {
        private Html4JavaType() {
            super(NameAndValue.class, JSONTest.NandV.class, 3, 0);
            this.registerProperty("name", 0, false);
            this.registerProperty("value", 1, false);
            this.registerProperty("small", 2, false);
        }

        public void setValue(NameAndValue data, int type, Object value) {
            switch (type) {
                case 0: {
                    data.setName((String)TYPE.extractValue(String.class, value));
                    return;
                }
                case 1: {
                    data.setValue((Long)TYPE.extractValue(Long.class, value));
                    return;
                }
                case 2: {
                    data.setSmall((Byte)TYPE.extractValue(Byte.class, value));
                    return;
                }
            }
        }

        public Object getValue(NameAndValue data, int type) {
            switch (type) {
                case 0: {
                    return data.getName();
                }
                case 1: {
                    return data.getValue();
                }
                case 2: {
                    return data.getSmall();
                }
            }
            throw new UnsupportedOperationException();
        }

        public void call(NameAndValue model, int type, Object data, Object ev) throws Exception {
            throw new UnsupportedOperationException();
        }

        public Proto protoFor(Object obj) {
            return ((NameAndValue)obj).proto;
        }

        public void onChange(NameAndValue model, int type) {
            throw new UnsupportedOperationException();
        }

        public void onMessage(NameAndValue model, int index, int type, Object data, Object[] params) {
            throw new UnsupportedOperationException("index: " + index + " type: " + type);
        }

        public NameAndValue read(BrwsrCtx c, Object json) {
            return new NameAndValue(c, json);
        }

        public NameAndValue cloneTo(NameAndValue o, BrwsrCtx c) {
            return o.clone(c);
        }
    }
}

