/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import org.apidesign.html.json.tck.KOTest;

public final class ConvertTypesTest {
    private static InputStream createIS(boolean includeSex, boolean includeAddress) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"firstName\" : \"son\",\n");
        sb.append("  \"lastName\" : \"dj\" \n");
        if (includeSex) {
            sb.append(",  \"sex\" : \"MALE\" \n");
        }
        if (includeAddress) {
            sb.append(",  \"address\" : { \"street\" : \"Schnirchova\" } \n");
        }
        sb.append("}\n");
        return new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
    }

    private static Object createJSON(boolean includeSex) throws UnsupportedEncodingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("firstName", "son");
        map.put("lastName", "dj");
        if (includeSex) {
            map.put("sex", "MALE");
        }
        return Utils.createObject(map, ConvertTypesTest.class);
    }

    @KOTest
    public void testConvertToPeople() throws Exception {
        Object o = ConvertTypesTest.createJSON(true);
        Person p = (Person)Models.fromRaw((BrwsrCtx)ConvertTypesTest.newContext(), Person.class, (Object)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseConvertToPeople() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(true, false);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseConvertToPeopleWithAddress() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(true, true);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (Sex.MALE.equals((Object)p.getSex())) : "Sex: " + (Object)((Object)p.getSex());
        assert (p.getAddress() != null) : "Some address provided";
        assert (p.getAddress().getStreet().equals("Schnirchova")) : "Is Schnirchova: " + p.getAddress();
    }

    @KOTest
    public void testConvertToPeopleWithoutSex() throws Exception {
        Object o = ConvertTypesTest.createJSON(false);
        Person p = (Person)Models.fromRaw((BrwsrCtx)ConvertTypesTest.newContext(), Person.class, (Object)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (p.getSex() == null) : "No sex: " + (Object)((Object)p.getSex());
    }

    @KOTest
    public void parseConvertToPeopleWithoutSex() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(false, false);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        assert ("son".equals(p.getFirstName())) : "First name: " + p.getFirstName();
        assert ("dj".equals(p.getLastName())) : "Last name: " + p.getLastName();
        assert (p.getSex() == null) : "No sex: " + (Object)((Object)p.getSex());
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(ConvertTypesTest.class);
    }
}

