/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.List;
import net.java.html.BrwsrCtx;
import net.java.html.json.tests.ArchetypeData;
import net.java.html.json.tests.KnockoutTest;
import net.java.html.json.tests.Person;
import org.netbeans.html.json.spi.Proto;

public final class KnockoutModel
implements Cloneable {
    private static final Html4JavaType TYPE = new Html4JavaType();
    private final Proto proto;
    private String prop_name;
    private final List<String> prop_results;
    private final List<Integer> prop_numbers;
    private int prop_callbackCount;
    private final List<Person> prop_people;
    private boolean prop_enabled;
    private double prop_latitude;
    private KnockoutTest.Choice prop_choice;
    private Object prop_archetype;
    private final List<ArchetypeData> prop_archetypes;

    private static Class<KnockoutTest> modelFor() {
        return KnockoutTest.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getResultLengths() {
        List<String> arg1 = this.getResults();
        try {
            this.proto.acquireLock();
            List<Integer> list = KnockoutTest.resultLengths(arg1);
            return list;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Person getFirstPerson() {
        List<Person> arg1 = this.getPeople();
        try {
            this.proto.acquireLock("firstPerson");
            Person person = KnockoutTest.firstPerson(arg1);
            return person;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHelloMessage() {
        String arg1 = this.getName();
        try {
            this.proto.acquireLock();
            String string = KnockoutTest.helloMessage(arg1);
            return string;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCmpResults() {
        List<String> arg1 = this.getResults();
        try {
            this.proto.acquireLock();
            List<String> list = KnockoutTest.cmpResults(arg1);
            return list;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    public String getName() {
        this.proto.accessProperty("name");
        return this.prop_name;
    }

    public void setName(String v) {
        this.proto.verifyUnlocked();
        String o = this.prop_name;
        if (TYPE.isSame(o, v)) {
            return;
        }
        this.prop_name = v;
        this.proto.valueHasMutated("name", (Object)o, (Object)v);
        this.proto.valueHasMutated("helloMessage", null, (Object)this.getHelloMessage());
    }

    public List<String> getResults() {
        this.proto.accessProperty("results");
        return this.prop_results;
    }

    public List<Integer> getNumbers() {
        this.proto.accessProperty("numbers");
        return this.prop_numbers;
    }

    public int getCallbackCount() {
        this.proto.accessProperty("callbackCount");
        return this.prop_callbackCount;
    }

    public void setCallbackCount(int v) {
        this.proto.verifyUnlocked();
        Integer o = this.prop_callbackCount;
        if (TYPE.isSame(o, v)) {
            return;
        }
        this.prop_callbackCount = v;
        this.proto.valueHasMutated("callbackCount", (Object)o, (Object)v);
    }

    public List<Person> getPeople() {
        this.proto.accessProperty("people");
        return this.prop_people;
    }

    public boolean isEnabled() {
        this.proto.accessProperty("enabled");
        return this.prop_enabled;
    }

    public void setEnabled(boolean v) {
        this.proto.verifyUnlocked();
        Boolean o = this.prop_enabled;
        if (TYPE.isSame(o, v)) {
            return;
        }
        this.prop_enabled = v;
        this.proto.valueHasMutated("enabled", (Object)o, (Object)v);
    }

    public double getLatitude() {
        this.proto.accessProperty("latitude");
        return this.prop_latitude;
    }

    public void setLatitude(double v) {
        this.proto.verifyUnlocked();
        Double o = this.prop_latitude;
        if (TYPE.isSame(o, v)) {
            return;
        }
        this.prop_latitude = v;
        this.proto.valueHasMutated("latitude", (Object)o, (Object)v);
    }

    public KnockoutTest.Choice getChoice() {
        this.proto.accessProperty("choice");
        return this.prop_choice;
    }

    public void setChoice(KnockoutTest.Choice v) {
        this.proto.verifyUnlocked();
        KnockoutTest.Choice o = this.prop_choice;
        if (TYPE.isSame((Object)o, (Object)v)) {
            return;
        }
        this.prop_choice = v;
        this.proto.valueHasMutated("choice", (Object)o, (Object)v);
    }

    public ArchetypeData getArchetype() {
        this.proto.accessProperty("archetype");
        if (this.prop_archetype == this) {
            this.prop_archetype = new ArchetypeData();
        }
        return (ArchetypeData)this.prop_archetype;
    }

    public void setArchetype(ArchetypeData v) {
        this.proto.verifyUnlocked();
        Object o = this.prop_archetype;
        if (o == v) {
            return;
        }
        this.prop_archetype = v;
        this.proto.valueHasMutated("archetype", o, (Object)v);
    }

    public List<ArchetypeData> getArchetypes() {
        this.proto.accessProperty("archetypes");
        return this.prop_archetypes;
    }

    private KnockoutModel(BrwsrCtx context) {
        this.proto = TYPE.createProto(this, context);
        this.prop_results = this.proto.createList("results", -1, new String[]{"resultLengths", "cmpResults"});
        this.prop_numbers = this.proto.createList("numbers", -1, new String[0]);
        this.prop_people = this.proto.createList("people", -1, new String[]{"firstPerson"});
        this.prop_archetypes = this.proto.createList("archetypes", -1, new String[0]);
    }

    public KnockoutModel() {
        this(BrwsrCtx.findDefault(KnockoutModel.class));
        this.prop_archetype = this;
    }

    public KnockoutModel(String aName, int aCallbackCount, boolean aEnabled, double aLatitude, KnockoutTest.Choice aChoice, ArchetypeData aArchetype, String ... aResults) {
        this(BrwsrCtx.findDefault(KnockoutModel.class));
        this.prop_name = aName;
        this.prop_callbackCount = aCallbackCount;
        this.prop_enabled = aEnabled;
        this.prop_latitude = aLatitude;
        this.prop_choice = aChoice;
        this.prop_archetype = aArchetype;
        this.proto.initTo(this.prop_results, (Object)aResults);
    }

    private KnockoutModel(BrwsrCtx c, Object json) {
        this(c);
        Object[] ret = new Object[10];
        this.proto.extract(json, new String[]{"name", "results", "numbers", "callbackCount", "people", "enabled", "latitude", "choice", "archetype", "archetypes"}, ret);
        this.prop_name = (String)ret[0];
        for (Object e : KnockoutModel.useAsArray(ret[1])) {
            this.prop_results.add((String)e);
        }
        for (Object e : KnockoutModel.useAsArray(ret[2])) {
            this.prop_numbers.add(TYPE.numberValue(e).intValue());
        }
        this.prop_callbackCount = ret[3] == null ? 0 : TYPE.numberValue(ret[3]).intValue();
        for (Object e : KnockoutModel.useAsArray(ret[4])) {
            this.prop_people.add((Person)this.proto.read(Person.class, e));
        }
        this.prop_enabled = ret[5] == null ? false : TYPE.boolValue(ret[5]);
        this.prop_latitude = ret[6] == null ? 0.0 : TYPE.numberValue(ret[6]).doubleValue();
        try {
            this.prop_choice = ret[7] == null ? null : KnockoutTest.Choice.valueOf(TYPE.stringValue(ret[7]));
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        this.prop_archetype = this.proto.read(ArchetypeData.class, ret[8]);
        for (Object e : KnockoutModel.useAsArray(ret[9])) {
            this.prop_archetypes.add((ArchetypeData)this.proto.read(ArchetypeData.class, e));
        }
    }

    private static Object[] useAsArray(Object o) {
        Object[] objectArray;
        if (o instanceof Object[]) {
            objectArray = (Object[])o;
        } else if (o == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = o;
        }
        return objectArray;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append('\"').append("name").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_name));
        sb.append(',');
        sb.append('\"').append("results").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_results));
        sb.append(',');
        sb.append('\"').append("numbers").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_numbers));
        sb.append(',');
        sb.append('\"').append("callbackCount").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_callbackCount));
        sb.append(',');
        sb.append('\"').append("people").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_people));
        sb.append(',');
        sb.append('\"').append("enabled").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_enabled));
        sb.append(',');
        sb.append('\"').append("latitude").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_latitude));
        sb.append(',');
        sb.append('\"').append("choice").append('\"').append(":");
        sb.append(TYPE.toJSON((Object)this.prop_choice));
        sb.append(',');
        sb.append('\"').append("archetype").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_archetype));
        sb.append(',');
        sb.append('\"').append("archetypes").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_archetypes));
        sb.append('}');
        return sb.toString();
    }

    public KnockoutModel clone() {
        return this.clone(this.proto.getContext());
    }

    private KnockoutModel clone(BrwsrCtx ctx) {
        KnockoutModel ret = new KnockoutModel(ctx);
        ret.prop_name = this.getName();
        this.proto.cloneList(ret.getResults(), ctx, this.prop_results);
        this.proto.cloneList(ret.getNumbers(), ctx, this.prop_numbers);
        ret.prop_callbackCount = this.getCallbackCount();
        this.proto.cloneList(ret.getPeople(), ctx, this.prop_people);
        ret.prop_enabled = this.isEnabled();
        ret.prop_latitude = this.getLatitude();
        ret.prop_choice = this.getChoice();
        ret.prop_archetype = this.getArchetype() == null ? null : this.getArchetype().clone();
        this.proto.cloneList(ret.getArchetypes(), ctx, this.prop_archetypes);
        return ret;
    }

    public KnockoutModel applyBindings() {
        this.proto.applyBindings();
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnockoutModel)) {
            return false;
        }
        KnockoutModel p = (KnockoutModel)o;
        if (!TYPE.isSame(this.prop_name, p.prop_name)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_results, p.prop_results)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_numbers, p.prop_numbers)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_callbackCount, p.prop_callbackCount)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_people, p.prop_people)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_enabled, p.prop_enabled)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_latitude, p.prop_latitude)) {
            return false;
        }
        if (!TYPE.isSame((Object)this.prop_choice, (Object)p.prop_choice)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_archetype, p.prop_archetype)) {
            return false;
        }
        return TYPE.isSame(this.prop_archetypes, p.prop_archetypes);
    }

    public int hashCode() {
        int h = KnockoutModel.class.getName().hashCode();
        h = TYPE.hashPlus(this.prop_name, h);
        h = TYPE.hashPlus(this.prop_results, h);
        h = TYPE.hashPlus(this.prop_numbers, h);
        h = TYPE.hashPlus(this.prop_callbackCount, h);
        h = TYPE.hashPlus(this.prop_people, h);
        h = TYPE.hashPlus(this.prop_enabled, h);
        h = TYPE.hashPlus(this.prop_latitude, h);
        h = TYPE.hashPlus((Object)this.prop_choice, h);
        h = TYPE.hashPlus(this.prop_archetype, h);
        h = TYPE.hashPlus(this.prop_archetypes, h);
        return h;
    }

    private static class Html4JavaType
    extends Proto.Type<KnockoutModel> {
        private Html4JavaType() {
            super(KnockoutModel.class, KnockoutTest.class, 14, 2);
            this.registerProperty("resultLengths", 0, true, false);
            this.registerProperty("firstPerson", 1, true, false);
            this.registerProperty("helloMessage", 2, true, false);
            this.registerProperty("cmpResults", 3, true, false);
            this.registerProperty("name", 4, false, false);
            this.registerProperty("results", 5, false, false);
            this.registerProperty("numbers", 6, false, false);
            this.registerProperty("callbackCount", 7, false, false);
            this.registerProperty("people", 8, false, false);
            this.registerProperty("enabled", 9, false, false);
            this.registerProperty("latitude", 10, false, false);
            this.registerProperty("choice", 11, false, false);
            this.registerProperty("archetype", 12, false, false);
            this.registerProperty("archetypes", 13, false, false);
            this.registerFunction("call", 0);
            this.registerFunction("removePerson", 1);
        }

        public void setValue(KnockoutModel data, int type, Object value) {
            switch (type) {
                case 4: {
                    data.setName((String)TYPE.extractValue(String.class, value));
                    return;
                }
                case 5: {
                    TYPE.replaceValue(data.getResults(), String.class, value);
                    return;
                }
                case 6: {
                    TYPE.replaceValue(data.getNumbers(), Integer.class, value);
                    return;
                }
                case 7: {
                    data.setCallbackCount((Integer)TYPE.extractValue(Integer.class, value));
                    return;
                }
                case 8: {
                    TYPE.replaceValue(data.getPeople(), Person.class, value);
                    return;
                }
                case 9: {
                    data.setEnabled((Boolean)TYPE.extractValue(Boolean.class, value));
                    return;
                }
                case 10: {
                    data.setLatitude((Double)TYPE.extractValue(Double.class, value));
                    return;
                }
                case 11: {
                    data.setChoice((KnockoutTest.Choice)((Object)TYPE.extractValue(KnockoutTest.Choice.class, value)));
                    return;
                }
                case 12: {
                    data.setArchetype((ArchetypeData)TYPE.extractValue(ArchetypeData.class, value));
                    return;
                }
                case 13: {
                    TYPE.replaceValue(data.getArchetypes(), ArchetypeData.class, value);
                    return;
                }
            }
            throw new UnsupportedOperationException();
        }

        public Object getValue(KnockoutModel data, int type) {
            switch (type) {
                case 0: {
                    return data.getResultLengths();
                }
                case 1: {
                    return data.getFirstPerson();
                }
                case 2: {
                    return data.getHelloMessage();
                }
                case 3: {
                    return data.getCmpResults();
                }
                case 4: {
                    return data.getName();
                }
                case 5: {
                    return data.getResults();
                }
                case 6: {
                    return data.getNumbers();
                }
                case 7: {
                    return data.getCallbackCount();
                }
                case 8: {
                    return data.getPeople();
                }
                case 9: {
                    return data.isEnabled();
                }
                case 10: {
                    return data.getLatitude();
                }
                case 11: {
                    return data.getChoice();
                }
                case 12: {
                    return data.getArchetype();
                }
                case 13: {
                    return data.getArchetypes();
                }
            }
            throw new UnsupportedOperationException();
        }

        public void call(KnockoutModel model, int type, Object data, Object ev) throws Exception {
            switch (type) {
                case 0: {
                    KnockoutTest.call(model, model.proto.toString(data, null));
                    return;
                }
                case 1: {
                    KnockoutTest.removePerson(model, (Person)model.proto.toModel(Person.class, data));
                    return;
                }
            }
            throw new UnsupportedOperationException();
        }

        public Proto protoFor(Object obj) {
            return ((KnockoutModel)obj).proto;
        }

        public void onChange(KnockoutModel model, int type) {
            throw new UnsupportedOperationException();
        }

        public void onMessage(KnockoutModel model, int index, int type, Object data, Object[] params) {
            throw new UnsupportedOperationException("index: " + index + " type: " + type);
        }

        public KnockoutModel read(BrwsrCtx c, Object json) {
            return new KnockoutModel(c, json);
        }

        public KnockoutModel cloneTo(KnockoutModel o, BrwsrCtx c) {
            return o.clone(c);
        }
    }
}

