/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.html.json.Models;

final class SimpleMap<K, V>
implements Map<K, V> {
    private final List<E<K, V>> entries = Models.asList((Object[])new E[0]);

    private SimpleMap() {
    }

    public static <K, V> Map<K, V> empty() {
        return new SimpleMap<K, V>();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    private int indexOf(Object obj, int index) {
        for (int i = 0; i < this.entries.size(); ++i) {
            E<K, V> arr = this.entries.get(i);
            if (!SimpleMap.equals(index == 0 ? arr.key : arr.value, obj)) continue;
            return i;
        }
        return -1;
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf(key, 0) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.indexOf(value, 1) != -1;
    }

    @Override
    public V get(Object key) {
        int at = this.indexOf(key, 0);
        return at == -1 ? null : (V)this.entries.get((int)at).value;
    }

    @Override
    public V put(K key, V value) {
        int at = this.indexOf(key, 0);
        if (at == -1) {
            this.entries.add(new E<K, V>(key, value));
            return null;
        }
        E<K, V> arr = this.entries.get(at);
        return arr.setValue(value);
    }

    @Override
    public V remove(Object key) {
        int at = this.indexOf(key, 0);
        if (at == -1) {
            return null;
        }
        return this.entries.remove((int)at).value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<K> keySet() {
        List keys = Models.asList((Object[])new Object[0]);
        for (E<K, V> entry : this.entries) {
            keys.add(entry.key);
        }
        return new ROSet(keys);
    }

    @Override
    public Collection<V> values() {
        List values = Models.asList((Object[])new Object[0]);
        for (E<K, V> entry : this.entries) {
            values.add(entry.value);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ROSet<Map.Entry<K, V>>(this.entries);
    }

    private static final class ROSet<T>
    implements Set<T> {
        private final Collection<? extends T> delegate;

        ROSet(Collection<? extends T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator<? extends T> it = this.delegate.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public T next() {
                    return it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static final class E<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;

        E(K key, V v) {
            this.key = key;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V prev = this.value;
            this.value = value;
            return prev;
        }
    }
}

