/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.js.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ServiceLoader;
import net.java.html.json.Models;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.json.tck.JavaScriptTCK;

public class JsUtils {
    private static JavaScriptTCK instantiatedJsTCK;

    private JsUtils() {
    }

    public static void registerTCK(JavaScriptTCK tck) {
        instantiatedJsTCK = tck;
    }

    private static Iterable<JavaScriptTCK> tcks(Class<?> clazz) {
        if (instantiatedJsTCK != null) {
            return Models.asList((Object[])new JavaScriptTCK[]{instantiatedJsTCK});
        }
        return ServiceLoader.load(JavaScriptTCK.class, JsUtils.cl(clazz));
    }

    private static ClassLoader cl(Class<?> c) {
        try {
            return c.getClassLoader();
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    static void execute(Class<?> clazz, String script) throws Exception {
        Fn.Presenter p = Fn.activePresenter();
        p.loadScript((Reader)new StringReader(script));
    }

    static boolean executeNow(Class<?> clazz, String script) {
        try {
            Iterable<JavaScriptTCK> tcks = JsUtils.tcks(clazz);
            if (tcks.iterator().hasNext()) {
                for (JavaScriptTCK j : tcks) {
                    if (!j.executeNow(script)) continue;
                    return true;
                }
                return false;
            }
            JsUtils.execute(clazz, script);
            return true;
        }
        catch (Exception ex) {
            throw JsUtils.raise(RuntimeException.class, ex);
        }
    }

    private static <E extends Throwable> E raise(Class<E> e, Throwable t) throws E {
        throw t;
    }
}

