/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.js.tests;

import java.util.concurrent.Callable;
import net.java.html.js.tests.Bodies;
import net.java.html.js.tests.Factorial;
import net.java.html.js.tests.Global2String;
import net.java.html.js.tests.GlobalString;
import net.java.html.js.tests.JsUtils;
import net.java.html.js.tests.Later;
import net.java.html.js.tests.LaterJavaScriptAction;
import net.java.html.js.tests.ResourceOrder;
import net.java.html.js.tests.Sum;
import net.java.html.json.Models;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.json.tck.KOTest;

public class JavaScriptBodyTest {
    private R asyncRun;
    Later l;

    @KOTest
    public void sumTwoNumbers() {
        int res = Bodies.sum(5, 3);
        JavaScriptBodyTest.assertEquals(res, 8, "Expecting 8: " + res);
    }

    @KOTest
    public void sumFromCallback() {
        int res = Bodies.sumJS(5, 3);
        JavaScriptBodyTest.assertEquals(res, 8, "Expecting 8: " + res);
    }

    @KOTest
    public void accessJsObject() {
        Object o = Bodies.instance(10);
        int ten = Bodies.readIntX(o);
        JavaScriptBodyTest.assertEquals(ten, 10, "Expecting ten: " + ten);
    }

    @KOTest
    public void callWithNoReturnType() {
        Object o = Bodies.instance(10);
        Bodies.incrementX(o);
        int ten = Bodies.readIntX(o);
        JavaScriptBodyTest.assertEquals(ten, 11, "Expecting eleven: " + ten);
    }

    @KOTest
    public void callbackToRunnable() {
        R run = new R();
        Bodies.callback(run);
        JavaScriptBodyTest.assertEquals(run.cnt, 1, "Can call even private implementation classes: " + run.cnt);
    }

    @KOTest
    public void asyncCallbackToRunnable() throws InterruptedException {
        if (this.asyncRun == null) {
            this.asyncRun = new R();
            Bodies.asyncCallback(this.asyncRun);
        }
        if (this.asyncRun.cnt == 0) {
            throw new InterruptedException();
        }
        JavaScriptBodyTest.assertEquals(this.asyncRun.cnt, 1, "Even async callback must arrive once: " + this.asyncRun.cnt);
    }

    @KOTest
    public void asyncCallbackFlushed() throws InterruptedException {
        R r = new R();
        for (int i = 0; i < 10; ++i) {
            Bodies.asyncCallback(r);
        }
        int fourtyTwo = Bodies.sum(35, 7);
        JavaScriptBodyTest.assertEquals(r.cnt, 10, "Ten calls: " + r.cnt);
        JavaScriptBodyTest.assertEquals(fourtyTwo, 42, "Meaning of the world expected: " + fourtyTwo);
    }

    @KOTest
    public void typeOfCharacter() {
        String charType = Bodies.typeof(Character.valueOf('a'), false);
        JavaScriptBodyTest.assertEquals("number", charType, "Expecting number type: " + charType);
    }

    @KOTest
    public void typeOfBoolean() {
        String booleanType = Bodies.typeof(true, false);
        JavaScriptBodyTest.assertEquals("boolean", booleanType, "Expecting boolean type: " + booleanType);
    }

    @KOTest
    public void typeOfPrimitiveBoolean() {
        String booleanType = Bodies.typeof(true);
        JavaScriptBodyTest.assertTrue("boolean".equals(booleanType) || "number".equals(booleanType), "Expecting boolean or at least number type: " + booleanType);
    }

    @KOTest
    public void typeOfInteger() {
        String intType = Bodies.typeof(1, false);
        JavaScriptBodyTest.assertEquals("number", intType, "Expecting number type: " + intType);
    }

    @KOTest
    public void typeOfString() {
        String strType = Bodies.typeof("Ahoj", false);
        JavaScriptBodyTest.assertEquals("string", strType, "Expecting string type: " + strType);
    }

    @KOTest
    public void typeOfDouble() {
        String doubleType = Bodies.typeof(0.33, false);
        JavaScriptBodyTest.assertEquals("number", doubleType, "Expecting number type: " + doubleType);
    }

    @KOTest
    public void typeOfBooleanValueOf() {
        String booleanType = Bodies.typeof(true, true);
        JavaScriptBodyTest.assertEquals("boolean", booleanType, "Expecting boolean type: " + booleanType);
    }

    @KOTest
    public void typeOfIntegerValueOf() {
        String intType = Bodies.typeof(1, true);
        JavaScriptBodyTest.assertEquals("number", intType, "Expecting number type: " + intType);
    }

    @KOTest
    public void typeOfStringValueOf() {
        String strType = Bodies.typeof("Ahoj", true);
        JavaScriptBodyTest.assertEquals("string", strType, "Expecting string type: " + strType);
    }

    @KOTest
    public void typeOfDoubleValueOf() {
        String doubleType = Bodies.typeof(0.33, true);
        JavaScriptBodyTest.assertEquals("number", doubleType, "Expecting number type: " + doubleType);
    }

    @KOTest
    public void toStringOfAnEnum() {
        String enumStr = Bodies.toString((Object)Two.ONE);
        JavaScriptBodyTest.assertEquals(Two.ONE.toString(), enumStr, "Enum toString() used: " + enumStr);
    }

    @KOTest
    public void computeInARunnable() {
        final int[] sum = new int[2];
        class First
        implements Runnable {
            First() {
            }

            @Override
            public void run() {
                sum[0] = Bodies.sum(22, 20);
                sum[1] = Bodies.sum(32, 10);
            }
        }
        Bodies.callback(new First());
        JavaScriptBodyTest.assertEquals(sum[0], 42, "Computed OK " + sum[0]);
        JavaScriptBodyTest.assertEquals(sum[1], 42, "Computed OK too: " + sum[1]);
    }

    @KOTest
    public void doubleCallbackToRunnable() {
        final R run = new R();
        final R r2 = new R();
        class First
        implements Runnable {
            First() {
            }

            @Override
            public void run() {
                Bodies.callback(run);
                Bodies.callback(r2);
            }
        }
        Bodies.callback(new First());
        JavaScriptBodyTest.assertEquals(run.cnt, 1, "Can call even private implementation classes: " + run.cnt);
        JavaScriptBodyTest.assertEquals(r2.cnt, 1, "Can call even private implementation classes: " + r2.cnt);
    }

    @KOTest
    public void identity() {
        Object p = new Object();
        Object r = Bodies.id(p);
        JavaScriptBodyTest.assertEquals(r, p, "The object is the same");
    }

    @KOTest
    public void encodingString() {
        String p = "Ji\n\"Hi\"\nHon";
        Object r = Bodies.id(p);
        JavaScriptBodyTest.assertEquals(p, r, "The object is the same: " + p + " != " + r);
    }

    @KOTest
    public void encodingBackslashString() {
        String p = "{\"firstName\":\"/*\\n * Copyright (c) 2013\",\"lastName\":null,\"sex\":\"MALE\",\"address\":{\"street\":null}}";
        Object r = Bodies.id(p);
        JavaScriptBodyTest.assertEquals(p, r, "The object is the same: " + p + " != " + r);
    }

    @KOTest
    public void nullIsNull() {
        Object p = null;
        Object r = Bodies.id(p);
        JavaScriptBodyTest.assertEquals(r, p, "The null is the same");
    }

    @KOTest
    public void callbackWithTrueResult() {
        C c = new C(true);
        String b = Bodies.yesNo(c);
        JavaScriptBodyTest.assertEquals(b, "yes", "Should return true");
    }

    @KOTest
    public void callbackWithFalseResult() {
        C c = new C(false);
        String b = Bodies.yesNo(c);
        JavaScriptBodyTest.assertEquals(b, "no", "Should return false");
    }

    @KOTest
    public void callbackWithParameters() throws InterruptedException {
        Sum s = new Sum();
        int res = Bodies.sumIndirect(s, 40, 2);
        JavaScriptBodyTest.assertEquals(res, 42, "Expecting 42");
    }

    @KOTest
    public void selectFromStringJavaArray() {
        Object[] arr = new String[]{"Ahoj", "Wo\nrld"};
        Object res = Bodies.select(arr, 1);
        JavaScriptBodyTest.assertEquals("Wo\nrld", res, "Expecting World, but was: " + res);
    }

    @KOTest
    public void selectFromObjectJavaArray() {
        Object[] arr = new Object[]{new Object(), new Object()};
        Object res = Bodies.select(arr, 1);
        JavaScriptBodyTest.assertEquals(arr[1], res, "Expecting " + arr[1] + ", but was: " + res);
    }

    @KOTest
    public void lengthOfJavaArray() {
        Object[] arr = new String[]{"Ahoj", "World"};
        int res = Bodies.length(arr);
        JavaScriptBodyTest.assertEquals(res, 2, "Expecting 2, but was: " + res);
    }

    @KOTest
    public void isJavaArray() {
        String[] arr = new String[]{"Ahoj", "World"};
        boolean is = Bodies.isArray(arr);
        JavaScriptBodyTest.assertTrue(is, "Expecting it to be an array: " + is);
    }

    @KOTest
    public void javaArrayInOutIsCopied() {
        String[] arr = new String[]{"Ahoj", "Wo\nrld"};
        Object res = Bodies.id(arr);
        JavaScriptBodyTest.assertNotNull(res, "Non-null is returned");
        JavaScriptBodyTest.assertTrue(res instanceof Object[], "Returned an array: " + res);
        JavaScriptBodyTest.assertFalse(res instanceof String[], "Not returned a string array: " + res);
        Object[] ret = (Object[])res;
        JavaScriptBodyTest.assertEquals(arr.length, ret.length, "Same length: " + ret.length);
        JavaScriptBodyTest.assertEquals(arr[0], ret[0], "Same first elem");
        JavaScriptBodyTest.assertEquals(arr[1], ret[1], "Same 2nd elem");
    }

    @KOTest
    public void modifyJavaArrayHasNoEffect() {
        String[] arr = new String[]{"Ah\noj", "World"};
        String value = Bodies.modify(arr, 0, "H\tello");
        JavaScriptBodyTest.assertEquals("H\tello", value, "Inside JS the value is changed: " + value);
        JavaScriptBodyTest.assertEquals("Ah\noj", arr[0], "From a Java point of view it remains: " + arr[0]);
    }

    @KOTest
    public void callbackWithArray() {
        class A
        implements Callable<String[]> {
            A() {
            }

            @Override
            public String[] call() throws Exception {
                return new String[]{"He\nllo"};
            }
        }
        A a = new A();
        Object b = Bodies.callbackAndPush(a, "Worl\nd!");
        JavaScriptBodyTest.assertTrue(b instanceof Object[], "Returns an array: " + b);
        Object[] arr = (Object[])b;
        String str = Models.asList((Object[])arr).toString();
        JavaScriptBodyTest.assertEquals(arr.length, 2, "Size is two " + str);
        JavaScriptBodyTest.assertEquals("He\nllo", arr[0], "Hello expected: " + arr[0]);
        JavaScriptBodyTest.assertEquals("Worl\nd!", arr[1], "World! expected: " + arr[1]);
    }

    @KOTest
    public void sumVector() {
        double[] arr = new double[]{1.0, 2.0, 3.0};
        double res = Bodies.sumVector(arr);
        JavaScriptBodyTest.assertEquals(6.0, res, "Expecting six: " + res);
    }

    @KOTest
    public void sumMatrix() {
        double[][] arr = new double[][]{{1.0}, {1.0, 1.0}, {1.0, 1.0, 1.0}};
        double res = Bodies.sumMatrix(arr);
        JavaScriptBodyTest.assertEquals(6.0, res, "Expecting six: " + res);
    }

    @KOTest
    public void truth() {
        JavaScriptBodyTest.assertTrue(Bodies.truth(), "True is true");
    }

    @KOTest
    public void factorial2() {
        JavaScriptBodyTest.assertEquals(new Factorial().factorial(2), 2);
    }

    @KOTest
    public void factorial3() {
        JavaScriptBodyTest.assertEquals(new Factorial().factorial(3), 6);
    }

    @KOTest
    public void factorial4() {
        JavaScriptBodyTest.assertEquals(new Factorial().factorial(4), 24);
    }

    @KOTest
    public void factorial5() {
        JavaScriptBodyTest.assertEquals(new Factorial().factorial(5), 120);
    }

    @KOTest
    public void factorial6() {
        JavaScriptBodyTest.assertEquals(new Factorial().factorial(6), 720);
    }

    @KOTest
    public void sumArray() {
        int r = Bodies.sumArr(new Sum());
        JavaScriptBodyTest.assertEquals(r, 6, "Sum is six: " + r);
    }

    @KOTest
    public void staticCallback() {
        int r = Bodies.staticCallback();
        JavaScriptBodyTest.assertEquals(r, 42, "Expecting 42: " + r);
    }

    @KOTest
    public void delayCallback() {
        Object fn = Bodies.delayCallback();
        Object r = Bodies.invokeFn(fn);
        JavaScriptBodyTest.assertNotNull(r, "Is not null");
        JavaScriptBodyTest.assertTrue(r instanceof Number, "Is number " + r);
        JavaScriptBodyTest.assertEquals(((Number)r).intValue(), 42, "Expecting 42: " + r);
    }

    @KOTest
    public void asyncCallFromAJSCallbackNeedToFinishBeforeReturnToJS() {
        int r = Bodies.incAsync();
        JavaScriptBodyTest.assertEquals(r, 42, "Expecting 42: " + r);
    }

    @KOTest
    public void iterateArray() {
        String[] arr = new String[]{"Ahoj", "Hi", "Ciao"};
        Object[] ret = Bodies.forIn(arr);
        JavaScriptBodyTest.assertEquals(ret.length, 6, "Three elements returned: " + ret.length);
        JavaScriptBodyTest.assertNotEquals(ret, arr, "Different arrays");
        JavaScriptBodyTest.assertEquals(ret[1], "Ahoj", "Expecting Ahoj: " + ret[0]);
        JavaScriptBodyTest.assertEquals(ret[3], "Hi", "Expecting Hi: " + ret[1]);
        JavaScriptBodyTest.assertEquals(ret[5], "Ciao", "Expecting Ciao: " + ret[2]);
    }

    @KOTest
    public void primitiveTypes() {
        String all = Bodies.primitiveTypes(new Sum());
        JavaScriptBodyTest.assertEquals("Ahojfalse12356.07.0 TheEND", all, "Valid return type: " + all);
    }

    @KOTest
    public void returnUnknown() {
        Object o = Bodies.unknown();
        JavaScriptBodyTest.assertNull(o, "Unknown is converted to null");
    }

    @KOTest
    public void returnUndefinedString() {
        Object o = Bodies.id("undefined");
        JavaScriptBodyTest.assertNotNull(o, "String remains string");
    }

    @KOTest
    public void returnUnknownArray() {
        Object[] arr = Bodies.unknownArray();
        JavaScriptBodyTest.assertEquals(arr.length, 2, "Two elements");
        JavaScriptBodyTest.assertNull(arr[0], "1st element is null");
        JavaScriptBodyTest.assertNull(arr[1], "2nd element is null");
    }

    @KOTest
    public void callbackKnown() {
        Sum s = new Sum();
        boolean nonNull = Bodies.nonNull(s, "x");
        JavaScriptBodyTest.assertTrue(nonNull, "x property exists");
    }

    @KOTest
    public void callbackUnknown() {
        Sum s = new Sum();
        boolean nonNull = Bodies.nonNull(s, "y");
        JavaScriptBodyTest.assertFalse(nonNull, "y property doesn't exist");
    }

    @KOTest
    public void callbackUnknownArray() {
        Sum s = new Sum();
        int nullAndUnknown = Bodies.sumNonNull(s);
        JavaScriptBodyTest.assertEquals(nullAndUnknown, 1, "Only one slot");
    }

    @KOTest
    public void problematicString() {
        String js;
        String orig = Bodies.problematicString();
        if (orig.equals(js = Bodies.problematicCallback())) {
            return;
        }
        int len = Math.min(orig.length(), js.length());
        for (int i = 0; i < len; ++i) {
            if (orig.charAt(i) == js.charAt(i)) continue;
            JavaScriptBodyTest.fail("Difference at position " + i + "\norig: " + orig.substring(i - 5, Math.min(i + 10, orig.length())) + "\n  js: " + js.substring(i - 5, Math.min(i + 10, js.length())));
        }
        JavaScriptBodyTest.fail("The JS string is different: " + js);
    }

    @KOTest
    public void doubleInAnArray() throws Exception {
        Double val = 2.2;
        boolean res = Bodies.isInArray(new Object[]{val}, val);
        JavaScriptBodyTest.assertTrue(res, "Should be in the array");
    }

    @KOTest
    public void callLater() throws Exception {
        Fn.Presenter p = Fn.activePresenter();
        if (p == null) {
            return;
        }
        if (this.l == null) {
            JsUtils.execute(JavaScriptBodyTest.class, "if (typeof window === 'undefined') window = {};");
            this.l = new Later();
            this.l.register();
            JsUtils.execute(JavaScriptBodyTest.class, "window.later();");
        }
        if (this.l.call != 42) {
            throw new InterruptedException();
        }
        JavaScriptBodyTest.assertEquals(this.l.call, 42, "Method was called: " + this.l.call);
    }

    @KOTest
    public void laterCallFromJavaScriptInMiddleOfDefferedProcessing() {
        LaterJavaScriptAction t = new LaterJavaScriptAction();
        t.testWithoutCallback();
    }

    @KOTest
    public void laterCallFromJavaScriptInMiddleOfDefferedProcessingFromCallback() {
        LaterJavaScriptAction t = new LaterJavaScriptAction();
        t.testWithCallback();
    }

    @KOTest
    public void globalStringAvailable() throws Exception {
        JavaScriptBodyTest.assertEquals("HTML/Java", GlobalString.init());
        JavaScriptBodyTest.assertEquals("HTML/Java", Bodies.readGlobalString());
    }

    @KOTest
    public void orderOfJavaScriptResources() throws Exception {
        JavaScriptBodyTest.assertEquals("Hello World!", ResourceOrder.helloWorld());
    }

    @KOTest
    public void globalValueInCallbackAvailable() throws Exception {
        final String[] value = new String[]{null, null};
        Bodies.callback(new Runnable(){

            @Override
            public void run() {
                value[0] = Global2String.init();
                value[1] = Bodies.readGlobal2String();
            }
        });
        JavaScriptBodyTest.assertEquals(value[0], "NetBeans", "As a returned value from defining method");
        JavaScriptBodyTest.assertEquals(value[1], "NetBeans", "As read later by different method");
    }

    @KOTest
    public void nestedArray() {
        Object nested = Bodies.createNested();
        JavaScriptBodyTest.assertTrue(nested instanceof Object[], "Returns an array: " + nested);
        Object flat = ((Object[])nested)[0];
        JavaScriptBodyTest.assertTrue(flat instanceof Object[], "Containing an array: " + flat);
        JavaScriptBodyTest.assertEquals("eggs", ((Object[])flat)[0]);
    }

    static void assertEquals(Object a, Object b, String msg) {
        if (a == b) {
            return;
        }
        if (a != null && a.equals(b)) {
            return;
        }
        throw new AssertionError((Object)msg);
    }

    private static void assertNotEquals(Object a, Object b, String msg) {
        if (a == null) {
            if (b == null) {
                throw new AssertionError((Object)msg);
            }
            return;
        }
        if (a.equals(b)) {
            throw new AssertionError((Object)msg);
        }
    }

    static void assertEquals(Object a, Object b) {
        if (a == b) {
            return;
        }
        if (a != null && a.equals(b)) {
            return;
        }
        throw new AssertionError((Object)("Expecting " + b + " but found " + a));
    }

    static void fail(String msg) {
        throw new AssertionError((Object)msg);
    }

    static void assertTrue(boolean c, String msg) {
        if (!c) {
            throw new AssertionError((Object)msg);
        }
    }

    static void assertFalse(boolean c, String msg) {
        if (c) {
            throw new AssertionError((Object)msg);
        }
    }

    static void assertNull(Object o, String msg) {
        if (o != null) {
            throw new AssertionError((Object)msg);
        }
    }

    static void assertNotNull(Object o, String msg) {
        if (o == null) {
            throw new AssertionError((Object)msg);
        }
    }

    private static class R
    implements Runnable {
        int cnt;
        private final Thread initThread = Thread.currentThread();

        @Override
        public void run() {
            JavaScriptBodyTest.assertEquals(this.initThread, Thread.currentThread(), "Expecting to run in " + this.initThread + " but running in " + Thread.currentThread());
            ++this.cnt;
        }
    }

    static enum Two {
        ONE,
        TWO;

    }

    private static class C
    implements Callable<Boolean> {
        private final boolean ret;

        public C(boolean ret) {
            this.ret = ret;
        }

        @Override
        public Boolean call() throws Exception {
            return this.ret;
        }
    }
}

