/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.util.List;
import net.java.html.json.Models;
import net.java.html.json.tests.Utils;

public final class PhaseExecutor<T> {
    private final T data;
    private int at = -1;
    private int retry = 10;
    private List<Action<T>> tasks = Models.asList((Object[])new Action[0]);
    private List<Action<T>> clean = Models.asList((Object[])new Action[0]);

    private PhaseExecutor(T data) {
        this.data = data;
    }

    public static <T> PhaseExecutor<T> schedule(PhaseExecutor[] phases, Init<T> data) throws Exception {
        if (phases[0] == null) {
            phases[0] = new PhaseExecutor<T>(data.initialize());
        } else if (phases[0].at == -1) {
            Utils.fail("A PhaseExecutor hasn't been started! " + phases[0]);
        }
        return phases[0];
    }

    public PhaseExecutor<T> then(Action<T> a) {
        if (this.at == -1) {
            this.tasks.add(a);
        }
        return this;
    }

    public PhaseExecutor<T> finalize(Action<T> a) {
        if (this.at == -1) {
            this.clean.add(a);
        }
        return this;
    }

    public void start() throws Exception {
        if (this.at < 0) {
            this.at = 0;
        }
        while (this.at < this.tasks.size()) {
            Action<T> a = this.tasks.get(this.at);
            try {
                a.run(this.data);
            }
            catch (Error | Exception ex) {
                if (this.retry-- == 0) {
                    this.cleanUp();
                    throw ex;
                }
                throw (InterruptedException)new InterruptedException().initCause(ex);
            }
            ++this.at;
            this.retry = 10;
        }
        this.cleanUp();
    }

    private final void cleanUp() throws Exception {
        for (Action<T> a : this.clean) {
            a.run(this.data);
        }
    }

    @FunctionalInterface
    public static interface Action<T> {
        public void run(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Init<T> {
        public T initialize() throws Exception;
    }
}

