/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.spi;

import org.apidesign.html.json.spi.Proto;

public abstract class FunctionBinding {
    FunctionBinding() {
    }

    public abstract String getFunctionName();

    public abstract void call(Object var1, Object var2);

    static <M> FunctionBinding registerFunction(String name, int index, M model, Proto.Type<M> access) {
        return new Impl<M>(name, index, model, access);
    }

    private static final class Impl<M>
    extends FunctionBinding {
        final String name;
        private final M model;
        private final Proto.Type<M> access;
        private final int index;

        public Impl(String name, int index, M model, Proto.Type<M> access) {
            this.name = name;
            this.index = index;
            this.model = model;
            this.access = access;
        }

        @Override
        public String getFunctionName() {
            return this.name;
        }

        @Override
        public void call(Object data, Object ev) {
            try {
                this.access.call(this.model, this.index, data, ev);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

