/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.spi;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apidesign.html.json.spi.Proto;

final class Observers {
    private static final LinkedList<Watcher> GLOBAL = new LinkedList();
    private final List<Watcher> watchers = new ArrayList<Watcher>();
    private final List<Ref> observers = new ArrayList<Ref>();

    Observers() {
        assert (Thread.holdsLock(GLOBAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void beginComputing(Proto p, String name) {
        LinkedList<Watcher> linkedList = GLOBAL;
        synchronized (linkedList) {
            Observers.verifyUnlocked(p);
            Watcher nw = new Watcher(p, name);
            GLOBAL.push(nw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verifyUnlocked(Proto p) {
        LinkedList<Watcher> linkedList = GLOBAL;
        synchronized (linkedList) {
            for (Watcher w : GLOBAL) {
                if (w.proto != p) continue;
                throw new IllegalStateException("Re-entrant attempt to access " + p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void accessingValue(Proto p, String propName) {
        LinkedList<Watcher> linkedList = GLOBAL;
        synchronized (linkedList) {
            Observers.verifyUnlocked(p);
            for (Watcher w : GLOBAL) {
                Observers mine = p.observers(true);
                mine.add(w, new Ref(w, propName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void finishComputing(Proto p) {
        LinkedList<Watcher> linkedList = GLOBAL;
        synchronized (linkedList) {
            Watcher w = GLOBAL.pop();
            if (w.proto != p) {
                throw new IllegalStateException("Inconsistency: " + w.proto + " != " + p);
            }
            if (w.prop != null) {
                Observers mine = p.observers(true);
                mine.add(w);
            }
        }
    }

    private Watcher find(String prop) {
        if (prop == null) {
            return null;
        }
        for (Watcher w : this.watchers) {
            if (!prop.equals(w.prop)) continue;
            return w;
        }
        return null;
    }

    final void add(Watcher w) {
        for (int i = 0; i < this.watchers.size(); ++i) {
            Watcher ith = this.watchers.get(i);
            if (w.prop == null) {
                if (ith.prop != null) continue;
                this.watchers.set(i, w);
                return;
            }
            if (!w.prop.equals(ith.prop)) continue;
            this.watchers.set(i, w);
            return;
        }
        this.watchers.add(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void valueHasMutated(Proto p, String propName) {
        LinkedList<Watcher> mutated = new LinkedList<Watcher>();
        LinkedList<Watcher> linkedList = GLOBAL;
        synchronized (linkedList) {
            Observers mine = p.observers(false);
            if (mine == null) {
                return;
            }
            Iterator<Ref> it = mine.observers.iterator();
            while (it.hasNext()) {
                Watcher w;
                Ref ref = it.next();
                if (ref.get() == null) {
                    it.remove();
                    continue;
                }
                if (!ref.prop.equals(propName) || (w = ref.watcher()) == null) continue;
                mutated.add(w);
            }
        }
        for (Watcher w : mutated) {
            w.proto.valueHasMutated(w.prop);
        }
    }

    void add(Watcher w, Ref r) {
        Thread.holdsLock(GLOBAL);
        if (w == null) {
            return;
        }
        Iterator<Ref> it = this.observers.iterator();
        while (it.hasNext()) {
            Ref ref = it.next();
            if (r == ref) {
                return;
            }
            Watcher rw = (Watcher)ref.get();
            if (rw == null) {
                it.remove();
                continue;
            }
            if (rw != w || !r.prop.equals(r.prop)) continue;
            return;
        }
        this.observers.add(r);
    }

    private static final class Watcher {
        final Proto proto;
        final String prop;

        Watcher(Proto proto, String prop) {
            this.proto = proto;
            this.prop = prop;
        }

        public String toString() {
            return "Watcher: " + this.proto + ", " + this.prop;
        }
    }

    private static final class Ref
    extends WeakReference<Watcher> {
        private final String prop;

        public Ref(Watcher ref, String prop) {
            super(ref);
            this.prop = prop;
        }

        final Watcher watcher() {
            Watcher w = (Watcher)this.get();
            if (w == null) {
                return null;
            }
            Observers o = w.proto.observers(false);
            if (o == null) {
                return null;
            }
            if (o.find(w.prop) == w) {
                return w;
            }
            return null;
        }
    }
}

