/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.json.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.netbeans.html.json.impl.Bindings;
import org.netbeans.html.json.impl.JSON;
import org.netbeans.html.json.impl.PropertyBindingAccessor;
import org.netbeans.html.json.spi.Proto;

public final class JSONList<T>
extends ArrayList<T> {
    private final Proto proto;
    private final String name;
    private final String[] deps;
    private final int index;

    public JSONList(Proto proto, String name, int changeIndex, String ... deps) {
        this.proto = proto;
        this.name = name;
        this.deps = deps;
        this.index = changeIndex;
    }

    public void init(Object values) {
        int len;
        if (values == null || (len = Array.getLength(values)) == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            Object data = Array.get(values, i);
            super.add(data);
        }
    }

    public static <T> void init(Collection<T> to, Object values) {
        int len;
        if (values == null || (len = Array.getLength(values)) == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            Object data = Array.get(values, i);
            to.add(data);
        }
    }

    @Override
    public boolean add(T e) {
        this.prepareChange();
        boolean ret = super.add(e);
        this.notifyChange();
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.prepareChange();
        boolean ret = super.addAll(c);
        this.notifyChange();
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.prepareChange();
        boolean ret = super.addAll(index, c);
        this.notifyChange();
        return ret;
    }

    public void fastReplace(Collection<? extends T> c) {
        this.prepareChange();
        super.clear();
        super.addAll(c);
        this.notifyChange();
    }

    @Override
    public boolean remove(Object o) {
        this.prepareChange();
        boolean ret = super.remove(o);
        this.notifyChange();
        return ret;
    }

    @Override
    public void clear() {
        this.prepareChange();
        super.clear();
        this.notifyChange();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.prepareChange();
        boolean ret = super.removeAll(c);
        this.notifyChange();
        return ret;
    }

    @Override
    public void sort(Comparator<? super T> c) {
        Object[] arr = this.toArray();
        Arrays.sort(arr, c);
        for (int i = 0; i < arr.length; ++i) {
            super.set(i, arr[i]);
        }
        this.notifyChange();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.prepareChange();
        boolean ret = super.retainAll(c);
        this.notifyChange();
        return ret;
    }

    @Override
    public T set(int index, T element) {
        this.prepareChange();
        T ret = super.set(index, element);
        this.notifyChange();
        return ret;
    }

    @Override
    public void add(int index, T element) {
        this.prepareChange();
        super.add(index, element);
        this.notifyChange();
    }

    @Override
    public T remove(int index) {
        this.prepareChange();
        Object ret = super.remove(index);
        this.notifyChange();
        return (T)ret;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.notifyChange();
    }

    @Override
    public String toString() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        String sep = "";
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (it.hasNext()) {
            Object t = it.next();
            sb.append(sep);
            sb.append(JSON.toJSON(t));
            sep = ",";
        }
        sb.append(']');
        return sb.toString();
    }

    private void prepareChange() {
        if (this.index == Integer.MIN_VALUE) {
            try {
                this.proto.initTo(null, null);
            }
            catch (IllegalStateException ex) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void notifyChange() {
        this.proto.getContext().execute(new Runnable(){

            @Override
            public void run() {
                Bindings m = PropertyBindingAccessor.getBindings(JSONList.this.proto, false, null);
                if (m != null) {
                    m.valueHasMutated(JSONList.this.name, null, JSONList.this);
                    for (String dependant : JSONList.this.deps) {
                        m.valueHasMutated(dependant, null, null);
                    }
                    if (JSONList.this.index >= 0) {
                        PropertyBindingAccessor.notifyProtoChange(JSONList.this.proto, JSONList.this.index);
                    }
                }
            }
        });
    }

    @Override
    public JSONList clone() {
        throw new UnsupportedOperationException();
    }

    static final Object koData(Collection<?> c, Bindings m) {
        Object[] arr = c.toArray(new Object[c.size()]);
        for (int i = 0; i < arr.length; ++i) {
            Object r = JSON.find(arr[i], m);
            if (r == null) continue;
            arr[i] = r;
        }
        return m.wrapArray(arr);
    }

    final Object koData() {
        return JSONList.koData(this, PropertyBindingAccessor.getBindings(this.proto, true, null));
    }
}

