/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.sound;

import java.util.ServiceLoader;
import org.apidesign.html.sound.spi.AudioEnvironment;

public abstract class AudioClip {
    private AudioClip() {
    }

    public static AudioClip create(String src) {
        src.getClass();
        for (AudioEnvironment ae : ServiceLoader.load(AudioEnvironment.class)) {
            Impl handle = AudioClip.create(ae, src);
            if (handle == null) continue;
            return handle;
        }
        return DummyClip.INSTANCE;
    }

    public abstract void play();

    public abstract void pause();

    public abstract void setVolume(double var1);

    public abstract boolean isSupported();

    private static <Audio> Impl<Audio> create(AudioEnvironment<Audio> env, String src) {
        Audio a = env.create(src);
        if (a != null) {
            return new Impl<Audio>(env, src, a);
        }
        return null;
    }

    private static final class DummyClip
    extends AudioClip {
        static AudioClip INSTANCE = new DummyClip();

        private DummyClip() {
        }

        @Override
        public void play() {
        }

        @Override
        public void pause() {
        }

        @Override
        public void setVolume(double volume) {
        }

        @Override
        public boolean isSupported() {
            return false;
        }
    }

    private static final class Impl<Audio>
    extends AudioClip {
        private final String src;
        private final Audio clip;
        private final AudioEnvironment<Audio> env;

        public Impl(AudioEnvironment<Audio> env, String src, Audio clip) {
            this.clip = clip;
            this.env = env;
            this.src = src;
        }

        @Override
        public void play() {
            this.env.play(this.clip);
        }

        @Override
        public void pause() {
            this.env.pause(this.clip);
        }

        @Override
        public void setVolume(double volume) {
            this.env.setVolume(this.clip, volume);
        }

        @Override
        public boolean isSupported() {
            return this.env.isSupported(this.clip);
        }

        public int hashCode() {
            return 59 * this.src.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Impl) {
                return this.src.equals(((Impl)obj).src);
            }
            return false;
        }
    }
}

