/*
 * Decompiled with CFR 0.152.
 */
package org.cpp4j.java;

public class IntArray {
    private final int[] _data;
    private int _ofs;

    public IntArray(int size) {
        this._data = new int[size];
        this._ofs = 0;
    }

    public IntArray(int[] array) {
        this._data = array;
        this._ofs = 0;
    }

    public IntArray(int[] array, int ofs) {
        this._data = array;
        this._ofs = ofs;
    }

    public IntArray(IntArray array) {
        this._data = array._data;
        this._ofs = array._ofs;
    }

    public IntArray(IntArray array, int ofs) {
        this._data = array._data;
        this._ofs = array._ofs + ofs;
        if (this._ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(array._ofs + " + " + ofs + " = " + this._ofs + " >= " + this._data.length);
        }
    }

    public int at0() {
        return this._data[this._ofs];
    }

    public int at(int ofs) {
        return this._data[this._ofs + ofs];
    }

    public void setAt0(int d) {
        this._data[this._ofs] = d;
    }

    public void setAt(int ofs, int d) {
        this._data[this._ofs + ofs] = d;
    }

    public void setData(int[] data) {
        if (data.length + this._ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(data.length + " + " + this._ofs + " = " + (data.length + this._ofs) + " >= " + this._data.length);
        }
        System.arraycopy(data, 0, this._data, this._ofs, data.length);
    }

    public void setData(IntArray array) {
        int[] data = array._data;
        int ofs = array._ofs;
        if (data.length + this._ofs + ofs >= this._data.length) {
            throw new IndexOutOfBoundsException(data.length + " + " + ofs + " + " + this._ofs + " = " + (data.length + this._ofs + ofs) + " >= " + this._data.length);
        }
        System.arraycopy(data, 0, this._data, this._ofs, data.length);
    }

    public int[] cloneData() {
        int[] ret = new int[this._data.length - this._ofs];
        System.arraycopy(this._data, this._ofs, ret, 0, this._data.length - this._ofs);
        return ret;
    }

    public int[] cloneData(int ofs, int len) {
        int[] ret = new int[len];
        System.arraycopy(this._data, this._ofs + ofs, ret, 0, len);
        return ret;
    }

    public void dec() {
        --this._ofs;
    }

    public void dec(int n) {
        this._ofs -= n;
    }

    public void inc() {
        ++this._ofs;
    }

    public void inc(int n) {
        this._ofs += n;
    }

    public int getOfs() {
        return this._ofs;
    }

    public int size() {
        return this._data.length - this._ofs;
    }
}

