/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.impl.io;

import java.util.Base64;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.Value;
import org.opencompare.api.java.util.PCMVisitor;
import org.opencompare.api.java.value.BooleanValue;
import org.opencompare.api.java.value.Conditional;
import org.opencompare.api.java.value.DateValue;
import org.opencompare.api.java.value.Dimension;
import org.opencompare.api.java.value.IntegerValue;
import org.opencompare.api.java.value.Multiple;
import org.opencompare.api.java.value.NotApplicable;
import org.opencompare.api.java.value.NotAvailable;
import org.opencompare.api.java.value.Partial;
import org.opencompare.api.java.value.RealValue;
import org.opencompare.api.java.value.StringValue;
import org.opencompare.api.java.value.Unit;
import org.opencompare.api.java.value.Version;

public class PCMBase64Encoder
implements PCMVisitor {
    private Base64.Encoder encoder = Base64.getEncoder();
    private Base64.Decoder decoder = Base64.getDecoder();
    private boolean encoding = true;

    public void encode(PCM pcm) {
        this.encoding = true;
        pcm.accept((PCMVisitor)this);
    }

    public void decode(PCM pcm) {
        this.encoding = false;
        pcm.accept((PCMVisitor)this);
    }

    private String encodeBase64(String str) {
        if (this.encoding) {
            return new String(this.encoder.encode(str.getBytes()));
        }
        return new String(this.decoder.decode(str.getBytes()));
    }

    public void visit(PCM pcm) {
        pcm.setName(this.encodeBase64(pcm.getName()));
        for (AbstractFeature feature : pcm.getFeatures()) {
            feature.accept((PCMVisitor)this);
        }
        for (Product product : pcm.getProducts()) {
            product.accept((PCMVisitor)this);
        }
    }

    public void visit(Feature feature) {
        feature.setName(this.encodeBase64(feature.getName()));
    }

    public void visit(FeatureGroup featureGroup) {
        featureGroup.setName(this.encodeBase64(featureGroup.getName()));
        for (AbstractFeature feature : featureGroup.getFeatures()) {
            feature.accept((PCMVisitor)this);
        }
    }

    public void visit(Product product) {
        product.setName(this.encodeBase64(product.getName()));
        for (Cell cell : product.getCells()) {
            cell.accept((PCMVisitor)this);
        }
    }

    public void visit(Cell cell) {
        cell.setContent(this.encodeBase64(cell.getContent()));
        cell.setRawContent(this.encodeBase64(cell.getRawContent()));
        if (cell.getInterpretation() != null) {
            cell.getInterpretation().accept((PCMVisitor)this);
        }
    }

    public void visit(BooleanValue booleanValue) {
    }

    public void visit(Conditional conditional) {
        conditional.getCondition().accept((PCMVisitor)this);
        conditional.getValue().accept((PCMVisitor)this);
    }

    public void visit(DateValue dateValue) {
        dateValue.setValue(this.encodeBase64(dateValue.getValue()));
    }

    public void visit(Dimension dimension) {
    }

    public void visit(IntegerValue integerValue) {
    }

    public void visit(Multiple multiple) {
        for (Value subValue : multiple.getSubValues()) {
            subValue.accept((PCMVisitor)this);
        }
    }

    public void visit(NotApplicable notApplicable) {
    }

    public void visit(NotAvailable notAvailable) {
    }

    public void visit(Partial partial) {
        partial.getValue().accept((PCMVisitor)this);
    }

    public void visit(RealValue realValue) {
    }

    public void visit(StringValue stringValue) {
        stringValue.setValue(this.encodeBase64(stringValue.getValue()));
    }

    public void visit(Unit unit) {
    }

    public void visit(Version version) {
    }
}

