/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.io.IOCell;
import org.opencompare.api.java.io.IOMatrix;
import org.opencompare.api.java.io.IOMatrixLoader;
import org.opencompare.api.java.io.PCMLoader;

public class CSVLoader
implements PCMLoader {
    private PCMFactory factory;
    private char separator;
    private char quote;
    private boolean productsAsLines;
    private Map<Integer, AbstractFeature> features;

    public CSVLoader(PCMFactory factory) {
        this(factory, ',', '\"', true);
    }

    public CSVLoader(PCMFactory factory, char separator) {
        this(factory, separator, '\"', true);
    }

    public CSVLoader(PCMFactory factory, char separator, char quote) {
        this(factory, separator, quote, true);
    }

    public CSVLoader(PCMFactory factory, boolean productsAsLines) {
        this(factory, ',', '\"', productsAsLines);
    }

    public CSVLoader(PCMFactory factory, char separator, char quote, boolean productsAsLines) {
        this.factory = factory;
        this.separator = separator;
        this.quote = quote;
        this.productsAsLines = productsAsLines;
    }

    public static IOMatrix createMatrix(CSVReader reader) throws IOException {
        List csvMatrix = reader.readAll();
        IOMatrix matrix = new IOMatrix();
        for (int i = 0; i < csvMatrix.size(); ++i) {
            for (int j = 0; j < ((String[])csvMatrix.get(i)).length; ++j) {
                String content = ((String[])csvMatrix.get(i))[j];
                IOCell cell = new IOCell(content);
                matrix.setCell(cell, i, j, 1, 1);
            }
        }
        return matrix;
    }

    @Override
    public List<PCMContainer> load(String pcm) {
        List<PCMContainer> containers = new ArrayList<PCMContainer>();
        try {
            containers = this.load(new StringReader(pcm));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return containers;
    }

    @Override
    public List<PCMContainer> load(File file) throws IOException {
        List<PCMContainer> containers = new ArrayList<PCMContainer>();
        try {
            containers = this.load(new FileReader(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return containers;
    }

    public List<PCMContainer> load(IOMatrix matrix) {
        return new IOMatrixLoader(this.factory, this.productsAsLines).load(matrix);
    }

    public List<PCMContainer> load(Reader reader) throws IOException {
        CSVReader csvReader = new CSVReader(reader, this.separator, this.quote);
        IOMatrix matrix = CSVLoader.createMatrix(csvReader);
        return this.load(matrix);
    }
}

