/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.util;

import java.io.PrintStream;

public final class PrettyPrinter {
    private static final char BORDER_KNOT = '+';
    private static final char HORIZONTAL_BORDER = '-';
    private static final char VERTICAL_BORDER = '|';
    private static final String DEFAULT_AS_NULL = "(NULL)";
    private final PrintStream out;
    private final String asNull;

    public PrettyPrinter(PrintStream out) {
        this(out, DEFAULT_AS_NULL);
    }

    public PrettyPrinter(PrintStream out, String asNull) {
        if (out == null) {
            throw new IllegalArgumentException("No print stream provided");
        }
        if (asNull == null) {
            throw new IllegalArgumentException("No NULL-value placeholder provided");
        }
        this.out = out;
        this.asNull = asNull;
    }

    public void print(String[][] table) {
        if (table == null) {
            throw new IllegalArgumentException("No tabular data provided");
        }
        if (table.length == 0) {
            return;
        }
        int[] widths = new int[this.getMaxColumns(table)];
        this.adjustColumnWidths(table, widths);
        this.printPreparedTable(table, widths, this.getHorizontalBorder(widths));
    }

    private void printPreparedTable(String[][] table, int[] widths, String horizontalBorder) {
        int lineLength = horizontalBorder.length();
        this.out.println(horizontalBorder);
        for (String[] row : table) {
            if (row == null) continue;
            this.out.println(this.getRow(row, widths, lineLength));
            this.out.println(horizontalBorder);
        }
    }

    private String getRow(String[] row, int[] widths, int lineLength) {
        StringBuilder builder = new StringBuilder(lineLength).append('|');
        int maxWidths = widths.length;
        for (int i = 0; i < maxWidths; ++i) {
            builder.append(PrettyPrinter.padRight(this.getCellValue(PrettyPrinter.safeGet(row, i, null)), widths[i])).append('|');
        }
        return builder.toString();
    }

    private String getHorizontalBorder(int[] widths) {
        StringBuilder builder = new StringBuilder(256);
        builder.append('+');
        for (int w : widths) {
            for (int i = 0; i < w; ++i) {
                builder.append('-');
            }
            builder.append('+');
        }
        return builder.toString();
    }

    private int getMaxColumns(String[][] rows) {
        int max = 0;
        for (String[] row : rows) {
            if (row == null || row.length <= max) continue;
            max = row.length;
        }
        return max;
    }

    private void adjustColumnWidths(String[][] rows, int[] widths) {
        for (String[] row : rows) {
            if (row == null) continue;
            for (int c = 0; c < widths.length; ++c) {
                String cv = this.getCellValue(PrettyPrinter.safeGet(row, c, this.asNull));
                int l = cv.length();
                if (widths[c] >= l) continue;
                widths[c] = l;
            }
        }
    }

    private static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    private static String safeGet(String[] array, int index, String defaultValue) {
        return index < array.length ? array[index] : defaultValue;
    }

    private String getCellValue(Object value) {
        return value == null ? this.asNull : value.toString();
    }
}

