/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.util;

import org.opencompare.api.java.io.IOCell;
import org.opencompare.api.java.io.IOMatrix;
import org.opencompare.api.java.io.IONode;
import org.opencompare.api.java.util.MatrixComparator;

public class MatrixAnalyser {
    private IOMatrix matrix;
    private MatrixComparator comparator;
    private int height;
    private int width;
    private int currentLine;
    private int currentColumn;
    private int relativeLine;
    private int relativeColumn;
    private int headerOffset;
    private boolean stop;
    private boolean transposed;

    public MatrixAnalyser(IOMatrix matrix, MatrixComparator comparator) {
        this.matrix = matrix;
        this.comparator = comparator;
        this.reset();
    }

    public MatrixAnalyser reset() {
        this.height = this.matrix.getNumberOfRows() - 1;
        this.width = this.matrix.getNumberOfColumns() - 1;
        this.currentLine = 0;
        this.currentColumn = 0;
        this.relativeLine = 1;
        this.relativeColumn = 1;
        this.headerOffset = 0;
        this.stop = false;
        this.transposed = false;
        return this;
    }

    public MatrixAnalyser set(IOCell cell, int i, int j, int rowspan, int colspan) {
        if (this.transposed) {
            this.matrix.setCell(cell, j, i, colspan, rowspan);
        } else {
            this.matrix.setCell(cell, i, j, rowspan, colspan);
        }
        return this;
    }

    public IOCell get(int i, int j) {
        return this.transposed ? this.matrix.getOrCreateCell(j, i) : this.matrix.getOrCreateCell(i, j);
    }

    private int getInternalHeight() {
        return this.transposed ? this.width : this.height;
    }

    private int getInternalWidth() {
        return this.transposed ? this.height : this.width;
    }

    private int getCurrentLine() {
        return this.transposed ? this.currentColumn : this.currentLine;
    }

    private int getCurrentColumn() {
        return this.transposed ? this.currentLine : this.currentColumn;
    }

    private int getRelativeLine() {
        return this.transposed ? this.relativeColumn : this.relativeLine;
    }

    private int getRelativeColumn() {
        return this.transposed ? this.relativeLine : this.relativeColumn;
    }

    private void setCurrentLine(int value) {
        if (this.transposed) {
            this.currentColumn = value;
        } else {
            this.currentLine = value;
        }
    }

    private void setCurrentColumn(int value) {
        if (this.transposed) {
            this.currentLine = value;
        } else {
            this.currentColumn = value;
        }
    }

    private void setRelativeLine(int value) {
        if (this.transposed) {
            this.relativeColumn = value;
        } else {
            this.relativeLine = value;
        }
    }

    private void setRelativeColumn(int value) {
        if (this.transposed) {
            this.relativeLine = value;
        } else {
            this.relativeColumn = value;
        }
    }

    private boolean isEqual(int line, int column, int relativeLine, int relativeColumn) {
        IOCell cell1 = this.get(line, column);
        IOCell cell2 = this.get(relativeLine, relativeColumn);
        return this.comparator.compareCells(cell1, cell2);
    }

    private boolean isDifferent(int line, int column, int relativeLine, int relativeColumn) {
        return !this.isEqual(line, column, relativeLine, relativeColumn);
    }

    private boolean isUniqueLine() {
        for (int col = 0; col <= this.getInternalWidth(); ++col) {
            if (!this.isDifferent(this.getCurrentLine(), 0, this.getCurrentLine(), col)) continue;
            return false;
        }
        this.set(this.get(this.getCurrentLine(), 0), this.getCurrentLine(), this.getCurrentColumn(), 1, this.getWidth());
        if (this.getCurrentLine() > 0) {
            this.previousLine();
            this.stop();
        } else if (this.getCurrentLine() == 0) {
            this.nextLine();
            ++this.headerOffset;
        }
        return true;
    }

    private boolean isUniqueColumn() {
        for (int line = 0; line < this.getInternalHeight(); ++line) {
            if (!this.isDifferent(0, this.getCurrentColumn(), line, this.getCurrentColumn())) continue;
            return false;
        }
        this.set(this.get(0, this.getCurrentColumn()), this.getCurrentLine(), this.getCurrentColumn(), this.getHeight(), 1);
        this.nextColumn();
        return true;
    }

    private boolean isRowspan() {
        boolean result = false;
        while (this.isEqual(this.getCurrentLine(), this.getCurrentColumn(), this.getRelativeLine(), this.getCurrentColumn())) {
            result = true;
            if (this.getRelativeLine() == this.getInternalHeight()) break;
            this.setRelativeLine(this.getRelativeLine() + 1);
        }
        if (result) {
            this.set(this.get(this.getCurrentLine(), this.getCurrentColumn()), this.getCurrentLine(), this.getCurrentColumn(), this.getRelativeLine() - this.getCurrentLine(), 1);
            this.setCurrentLine(this.getRelativeLine() - 1);
        }
        return result;
    }

    private boolean isColspan() {
        boolean result = false;
        while (this.isEqual(this.getCurrentLine(), this.getCurrentColumn(), this.getCurrentLine(), this.getRelativeColumn())) {
            result = true;
            if (this.getRelativeColumn() == this.getInternalWidth()) break;
            this.setRelativeColumn(this.getRelativeColumn() + 1);
        }
        if (result) {
            this.set(this.get(this.getCurrentLine(), this.getCurrentColumn()), this.getCurrentLine(), this.getCurrentColumn(), 1, this.getRelativeColumn() - this.getCurrentColumn());
            if (this.getCurrentColumn() != 0) {
                this.nextLine();
                this.firstColumn();
            }
        }
        return result;
    }

    private void nextPosition() {
        this.setRelativeLine(this.getCurrentLine() + 1);
        this.setRelativeColumn(this.getCurrentColumn() + 1);
    }

    private boolean validPosition() {
        return this.getRelativeLine() < this.getInternalHeight() && this.getRelativeColumn() < this.getInternalWidth() && !this.stop;
    }

    private void previousLine() {
        this.setCurrentLine(this.getCurrentLine() - 1);
        this.setRelativeLine(this.getCurrentLine() + 1);
    }

    private void previousColumn() {
        this.setCurrentColumn(this.getCurrentColumn() - 1);
        this.setRelativeColumn(this.getCurrentColumn() + 1);
    }

    private void nextLine() {
        this.setCurrentLine(this.getCurrentLine() + 1);
        this.setRelativeLine(this.getCurrentLine() + 1);
    }

    private void nextColumn() {
        this.setCurrentColumn(this.getCurrentColumn() + 1);
        this.setRelativeColumn(this.getCurrentColumn() + 1);
    }

    private void firstColumn() {
        this.setCurrentColumn(0);
        this.setRelativeColumn(1);
    }

    private void stop() {
        this.stop = true;
    }

    public MatrixAnalyser setTransposition(boolean value) {
        this.reset();
        this.transposed = value;
        return this;
    }

    public MatrixAnalyser process() {
        while (this.validPosition()) {
            if (this.isUniqueLine() || this.isUniqueColumn() || this.isRowspan() || this.isColspan()) continue;
            this.nextColumn();
            this.nextPosition();
        }
        return this;
    }

    public int getHeaderOffset() {
        this.process();
        return this.headerOffset;
    }

    public int getHeaderColumnOffset() {
        return 1;
    }

    public int getHeaderHeight() {
        this.process();
        return this.getCurrentLine() + 1;
    }

    public int getWidth() {
        return this.getInternalWidth() + 1;
    }

    public int getHeight() {
        return this.getInternalHeight() + 1;
    }

    public IOMatrix getMatrix() {
        return this.matrix;
    }

    public IONode getHeaderNode() {
        IONode root = new IONode("root", true);
        for (int j = this.getHeaderColumnOffset(); j < this.getWidth(); ++j) {
            IONode node2;
            String name = this.get(this.getHeaderOffset(), j).getContent();
            IONode parentNode = new IONode(name, this.getHeaderHeight() > 1, j);
            for (IONode node2 : root.iterable()) {
                if (!node2.getName().equals(name)) continue;
                parentNode = node2;
            }
            if (!root.iterable().contains(parentNode)) {
                root.add(parentNode);
            }
            if (this.getHeaderHeight() <= 1) continue;
            IONode subparentNode = null;
            for (int i = this.getHeaderOffset() + 1; i < this.getHeaderHeight() - 1; ++i) {
                String subname = this.get(i, j).getContent();
                subparentNode = new IONode(name, true, j);
                for (IONode subnode : root.iterable()) {
                    if (!subnode.getName().equals(subname)) continue;
                    subparentNode = subnode;
                }
                if (parentNode.isNodeAncestor(subparentNode) || parentNode.isNodeDescendant(subparentNode)) continue;
                parentNode.add(subparentNode);
            }
            if (subparentNode != null) {
                parentNode = subparentNode;
            }
            node2 = new IONode(this.get(this.getHeaderHeight() - 1, j).getContent(), false, j);
            parentNode.add(node2);
        }
        return root;
    }
}

