/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencompare.api.java.io.IOCell;
import org.opencompare.api.java.util.Pair;

public class IOMatrix {
    private String name = "";
    private int maxRow = 0;
    private int maxColumn = 0;
    private Map<Pair<Integer, Integer>, IOCell> cells = new HashMap<Pair<Integer, Integer>, IOCell>();

    public IOMatrix() {
    }

    public IOMatrix(List<String[]> lines) {
        for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
            int lineLength = lines.get(lineIndex).length;
            for (int colIndex = 0; colIndex < lineLength; ++colIndex) {
                this.getOrCreateCell(lineIndex, colIndex).setContent(lines.get(lineIndex)[colIndex]);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public IOMatrix setName(String name) {
        this.name = name;
        return this;
    }

    public IOCell getCell(int row, int column) {
        return this.cells.get(new Pair<Integer, Integer>(row, column));
    }

    public IOMatrix setCell(IOCell cell, int row, int column) {
        return this.setCell(cell, row, column, 1, 1);
    }

    public IOMatrix setCell(IOCell cell, int row, int column, int rowspan, int colspan) {
        this.maxRow = this.maxRow < row + rowspan - 1 ? row + rowspan - 1 : this.maxRow;
        this.maxColumn = this.maxColumn < column + colspan - 1 ? column + colspan - 1 : this.maxColumn;
        for (int i = 0; i < rowspan; ++i) {
            for (int j = 0; j < colspan; ++j) {
                this.cells.put(new Pair<Integer, Integer>(row + i, column + j), cell);
            }
        }
        return this;
    }

    public IOCell getOrCreateCell(int row, int column) {
        if (this.cells.containsKey(new Pair<Integer, Integer>(row, column))) {
            return this.cells.get(new Pair<Integer, Integer>(row, column));
        }
        IOCell cell = new IOCell("");
        this.setCell(cell, row, column, 1, 1);
        return cell;
    }

    public int getNumberOfRows() {
        return this.maxRow + 1;
    }

    public int getNumberOfColumns() {
        return this.maxColumn + 1;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                result.append(i + "," + j + ":");
                IOCell cell = this.getCell(i, j);
                if (cell != null) {
                    result.append(cell.getContent());
                } else {
                    result.append("");
                }
                result.append('\n');
            }
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof IOMatrix) {
            IOMatrix matrix = (IOMatrix)obj;
            if (!this.name.equals(matrix.getName())) {
                return false;
            }
            for (Pair<Integer, Integer> pos : this.cells.keySet()) {
                IOCell cell2;
                IOCell cell1 = this.getCell((Integer)pos._1, (Integer)pos._2);
                if (cell1.equals(cell2 = matrix.getCell((Integer)pos._1, (Integer)pos._2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<String[]> toList() {
        ArrayList<String[]> matrix = new ArrayList<String[]>(this.getNumberOfRows());
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            String[] line = new String[this.getNumberOfColumns()];
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                line[j] = this.getCell(i, j).getContent();
            }
            matrix.add(line);
        }
        return matrix;
    }

    public void transpose() {
        HashMap<Pair<Integer, Integer>, IOCell> transposedCells = new HashMap<Pair<Integer, Integer>, IOCell>();
        for (Map.Entry<Pair<Integer, Integer>, IOCell> entry : this.cells.entrySet()) {
            transposedCells.put(new Pair(entry.getKey()._2, entry.getKey()._1), entry.getValue());
        }
        int tempMaxRow = this.maxRow;
        this.maxRow = this.maxColumn;
        this.maxColumn = tempMaxRow;
        this.cells = transposedCells;
    }
}

