/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.io.IOCell;
import org.opencompare.api.java.io.IOMatrix;
import org.opencompare.api.java.io.IONode;
import org.opencompare.api.java.util.MatrixAnalyser;
import org.opencompare.api.java.util.MatrixComparatorEqualityImpl;

public class IOMatrixLoader {
    private PCMFactory factory;
    private boolean productsAsLines;
    private Map<Integer, AbstractFeature> features;

    public IOMatrixLoader(PCMFactory factory) {
        this(factory, true);
    }

    public IOMatrixLoader(PCMFactory factory, boolean productsAsLines) {
        this.factory = factory;
        this.productsAsLines = productsAsLines;
    }

    public List<PCMContainer> load(IOMatrix matrix) {
        ArrayList<PCMContainer> containers = new ArrayList<PCMContainer>();
        MatrixAnalyser detector = new MatrixAnalyser(matrix, new MatrixComparatorEqualityImpl());
        detector.setTransposition(!this.productsAsLines);
        containers.add(this.load(detector));
        return containers;
    }

    private PCMContainer load(MatrixAnalyser detector) {
        PCM pcm = this.factory.createPCM();
        PCMMetadata metadata = new PCMMetadata(pcm);
        metadata.setProductAsLines(this.productsAsLines);
        PCMContainer container = new PCMContainer(metadata);
        int headerLength = detector.getHeaderHeight();
        int matrixHeight = detector.getHeight();
        int matrixWidth = detector.getWidth();
        int headerColumnStart = detector.getHeaderColumnOffset();
        this.createFeatures(detector, container);
        for (int i = headerLength; i < matrixHeight; ++i) {
            Product product = this.factory.createProduct();
            product.setName(detector.get(i, 0).getContent());
            pcm.addProduct(product);
            for (int j = headerColumnStart; j < matrixWidth; ++j) {
                Cell cell = this.factory.createCell();
                IOCell ioCell = detector.get(i, j);
                cell.setContent(ioCell.getContent());
                cell.setFeature((Feature)this.features.get(j));
                product.addCell(cell);
            }
            metadata.setProductPosition(product, i);
        }
        container.getPcm().setName(detector.getMatrix().getName());
        return container;
    }

    private void parseNodes(FeatureGroup parent, List<IONode> nodes, PCMContainer container) {
        for (IONode node : nodes) {
            if (node.isLeaf()) {
                Feature feature = this.factory.createFeature();
                feature.setName(node.getName());
                if (parent != null) {
                    parent.addFeature(feature);
                } else {
                    container.getPcm().addFeature(feature);
                }
                container.getMetadata().setFeaturePosition(feature, node.getPosition());
                this.features.put(node.getPosition(), feature);
                continue;
            }
            FeatureGroup featureGroup = this.factory.createFeatureGroup();
            featureGroup.setName(node.getName());
            if (parent != null) {
                parent.addFeature(featureGroup);
            } else {
                container.getPcm().addFeature(featureGroup);
            }
            this.parseNodes(featureGroup, node.iterable(), container);
        }
    }

    public void createFeatures(MatrixAnalyser detector, PCMContainer container) {
        this.features = new HashMap<Integer, AbstractFeature>();
        this.parseNodes(null, detector.getHeaderNode().iterable(), container);
    }
}

