/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.io.CSVLoader;

public abstract class CSVLoaderTest {
    protected PCMFactory factory;

    @Before
    public abstract void setUp();

    @Test
    public void testAMDProcessors() throws IOException {
        InputStream inputCSVStream = this.getClass().getResourceAsStream("/csv/Comparison_of_AMD_processors.csv");
        CSVLoader loader = new CSVLoader(this.factory);
        List containers = loader.load((Reader)new InputStreamReader(inputCSVStream));
        inputCSVStream.close();
        for (PCMContainer container : containers) {
            PCM pcm = container.getPcm();
            Assert.assertNotEquals((String)"number of features", (long)0L, (long)pcm.getFeatures().size());
            Assert.assertNotEquals((String)"number of products", (long)0L, (long)pcm.getProducts().size());
        }
    }

    @Test
    public void testAMDProcessorsInverted() throws IOException {
        InputStream inputCSVStream = this.getClass().getResourceAsStream("/csv/Comparison_of_AMD_processors.csv");
        CSVLoader loader = new CSVLoader(this.factory, false);
        List containers = loader.load((Reader)new InputStreamReader(inputCSVStream));
        inputCSVStream.close();
        for (PCMContainer container : containers) {
            PCM pcm = container.getPcm();
            Assert.assertNotEquals((String)"number of features", (long)0L, (long)pcm.getFeatures().size());
            Assert.assertNotEquals((String)"number of products", (long)0L, (long)pcm.getProducts().size());
        }
    }
}

