/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.io.PCMExporter;
import org.opencompare.api.java.util.PCMVisitor;
import org.opencompare.api.java.value.BooleanValue;
import org.opencompare.api.java.value.Conditional;
import org.opencompare.api.java.value.DateValue;
import org.opencompare.api.java.value.Dimension;
import org.opencompare.api.java.value.IntegerValue;
import org.opencompare.api.java.value.Multiple;
import org.opencompare.api.java.value.NotApplicable;
import org.opencompare.api.java.value.NotAvailable;
import org.opencompare.api.java.value.Partial;
import org.opencompare.api.java.value.RealValue;
import org.opencompare.api.java.value.StringValue;
import org.opencompare.api.java.value.Unit;
import org.opencompare.api.java.value.Version;

public class HTMLExporter
implements PCMVisitor,
PCMExporter {
    private Document doc;
    private Element body;
    private PCMMetadata metadata;
    private Element tr;
    Document.OutputSettings settings = new Document.OutputSettings();
    private String templateFull = "<html>\n\t<head>\n\t\t<meta charset=\"utf-8\"/>\n\t\t<title></title>\n\t</head>\n\t<body>\n\t</body>\n</html>";
    private LinkedList<AbstractFeature> nextFeaturesToVisit;
    private int featureDepth;

    @Override
    public String export(PCMContainer container) {
        return this.toHTML(container);
    }

    public String toHTML(PCM pcm) {
        this.settings.prettyPrint();
        this.doc = Jsoup.parse((String)this.templateFull);
        this.body = this.doc.body();
        this.doc.head().select("title").first().text(pcm.getName());
        if (this.metadata == null) {
            this.metadata = new PCMMetadata(pcm);
        }
        pcm.accept(this);
        return this.doc.outputSettings(this.settings).outerHtml();
    }

    public String toHTML(PCMContainer container) {
        this.metadata = container.getMetadata();
        return this.toHTML(container.getPcm());
    }

    @Override
    public void visit(PCM pcm) {
        this.body.appendElement("h1").text(pcm.getName());
        Element title = this.body.appendElement("h1");
        title.attr("id", "title").text(pcm.getName());
        Element table = this.body.appendElement("table");
        table.attr("id", "matrix_" + pcm.getName().hashCode()).attr("border", "1");
        this.featureDepth = pcm.getFeaturesDepth();
        LinkedList<AbstractFeature> featuresToVisit = new LinkedList<AbstractFeature>();
        this.nextFeaturesToVisit = new LinkedList();
        featuresToVisit.addAll(pcm.getFeatures());
        this.tr = table.appendElement("tr");
        this.tr.appendElement("th").attr("rowspan", Integer.toString(this.featureDepth)).text("Product");
        while (!featuresToVisit.isEmpty()) {
            Collections.sort(featuresToVisit, new Comparator<AbstractFeature>(){

                @Override
                public int compare(AbstractFeature feat1, AbstractFeature feat2) {
                    return HTMLExporter.this.metadata.getFeaturePosition(feat1) - HTMLExporter.this.metadata.getFeaturePosition(feat2);
                }
            });
            for (AbstractFeature feature : featuresToVisit) {
                feature.accept(this);
            }
            featuresToVisit = this.nextFeaturesToVisit;
            this.nextFeaturesToVisit = new LinkedList();
            --this.featureDepth;
            if (this.featureDepth < 1) continue;
            this.tr = table.appendElement("tr");
        }
        for (Product product : pcm.getProducts()) {
            this.tr = table.appendElement("tr");
            product.accept(this);
        }
    }

    @Override
    public void visit(Feature feature) {
        Element th = this.tr.appendElement("th");
        if (this.featureDepth > 1) {
            th.attr("rowspan", Integer.toString(this.featureDepth));
        }
        th.text(feature.getName());
    }

    @Override
    public void visit(FeatureGroup featureGroup) {
        Element th = this.tr.appendElement("th");
        if (!featureGroup.getFeatures().isEmpty()) {
            th.attr("colspan", Integer.toString(featureGroup.getFeatures().size()));
        }
        th.text(featureGroup.getName());
        this.nextFeaturesToVisit.addAll(featureGroup.getFeatures());
    }

    @Override
    public void visit(Product product) {
        this.tr.appendElement("th").text(product.getName());
        List<Cell> cells = product.getCells();
        Collections.sort(cells, new Comparator<Cell>(){

            @Override
            public int compare(Cell cell1, Cell cell2) {
                return HTMLExporter.this.metadata.getSortedFeatures().indexOf(cell1.getFeature()) - HTMLExporter.this.metadata.getSortedFeatures().indexOf(cell2.getFeature());
            }
        });
        for (Cell cell : cells) {
            Element td = this.tr.appendElement("td");
            td.appendElement("span").text(cell.getContent());
        }
    }

    @Override
    public void visit(Cell cell) {
    }

    @Override
    public void visit(BooleanValue booleanValue) {
    }

    @Override
    public void visit(Conditional conditional) {
    }

    @Override
    public void visit(DateValue dateValue) {
    }

    @Override
    public void visit(Dimension dimension) {
    }

    @Override
    public void visit(IntegerValue integerValue) {
    }

    @Override
    public void visit(Multiple multiple) {
    }

    @Override
    public void visit(NotApplicable notApplicable) {
    }

    @Override
    public void visit(NotAvailable notAvailable) {
    }

    @Override
    public void visit(Partial partial) {
    }

    @Override
    public void visit(RealValue realValue) {
    }

    @Override
    public void visit(StringValue stringValue) {
    }

    @Override
    public void visit(Unit unit) {
    }

    @Override
    public void visit(Version version) {
    }
}

