/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.io.PCMLoader;

public class SimpleCSVLoader
implements PCMLoader {
    private PCMFactory factory;
    private char separator;
    private char quote;
    private boolean productsAsLines;

    public SimpleCSVLoader(PCMFactory factory) {
        this(factory, ',', '\"', true);
    }

    public SimpleCSVLoader(PCMFactory factory, char separator) {
        this(factory, separator, '\"', true);
    }

    public SimpleCSVLoader(PCMFactory factory, char separator, char quote) {
        this(factory, separator, quote, true);
    }

    public SimpleCSVLoader(PCMFactory factory, boolean productsAsLines) {
        this(factory, ',', '\"', productsAsLines);
    }

    public SimpleCSVLoader(PCMFactory factory, char separator, char quote, boolean productsAsLines) {
        this.factory = factory;
        this.separator = separator;
        this.quote = quote;
        this.productsAsLines = productsAsLines;
    }

    @Override
    public List<PCMContainer> load(String pcm) {
        List<PCMContainer> containers = new ArrayList<PCMContainer>();
        try {
            containers = this.load(new StringReader(pcm));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return containers;
    }

    @Override
    public List<PCMContainer> load(File file) throws IOException {
        List<PCMContainer> containers = new ArrayList<PCMContainer>();
        try {
            containers = this.load(new FileReader(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return containers;
    }

    public List<PCMContainer> load(Reader reader) throws IOException {
        CSVReader csvReader = new CSVReader(reader, this.separator, this.quote);
        ArrayList<PCMContainer> containers = new ArrayList<PCMContainer>();
        if (this.productsAsLines) {
            containers.add(this.loadFeatureFirst(csvReader));
        } else {
            containers.add(this.loadProductFirst(csvReader));
        }
        csvReader.close();
        return containers;
    }

    private PCMContainer loadFeatureFirst(CSVReader reader) throws IOException {
        PCM pcm = this.factory.createPCM();
        PCMMetadata metadata = new PCMMetadata(pcm);
        metadata.setProductAsLines(this.productsAsLines);
        PCMContainer container = new PCMContainer(metadata);
        String[] featureNames = reader.readNext();
        if (featureNames != null) {
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (int i = 1; i < featureNames.length; ++i) {
                String featureName = featureNames[i];
                Feature feature = this.factory.createFeature();
                feature.setName(featureName);
                pcm.addFeature(feature);
                features.add(feature);
                metadata.setFeaturePosition(feature, i);
            }
            String[] line = reader.readNext();
            int index = 0;
            while (line != null) {
                Product product = this.factory.createProduct();
                product.setName(line[0]);
                pcm.addProduct(product);
                metadata.setProductPosition(product, index);
                for (int i = 1; i < line.length; ++i) {
                    Cell cell = this.factory.createCell();
                    cell.setContent(line[i]);
                    cell.setRawContent(line[i]);
                    if (i > features.size()) {
                        Feature newFeature = this.factory.createFeature();
                        newFeature.setName("Feature");
                        pcm.addFeature(newFeature);
                        features.add(newFeature);
                        metadata.setFeaturePosition(newFeature, i);
                    }
                    cell.setFeature((Feature)features.get(i - 1));
                    product.addCell(cell);
                }
                line = reader.readNext();
                ++index;
            }
        }
        return container;
    }

    private PCMContainer loadProductFirst(CSVReader reader) throws IOException {
        PCM pcm = this.factory.createPCM();
        PCMMetadata metadata = new PCMMetadata(pcm);
        metadata.setProductAsLines(this.productsAsLines);
        PCMContainer container = new PCMContainer(metadata);
        String[] productNames = reader.readNext();
        if (productNames != null) {
            ArrayList<Product> products = new ArrayList<Product>();
            for (int i = 1; i < productNames.length; ++i) {
                String productName = productNames[i];
                Product product = this.factory.createProduct();
                product.setName(productName);
                pcm.addProduct(product);
                products.add(product);
                metadata.setProductPosition(product, i);
            }
            String[] line = reader.readNext();
            int index = 0;
            while (line != null) {
                Feature feature = this.factory.createFeature();
                feature.setName(line[0]);
                pcm.addFeature(feature);
                metadata.setFeaturePosition(feature, index);
                for (int i = 1; i < line.length; ++i) {
                    Cell cell = this.factory.createCell();
                    cell.setContent(line[i]);
                    cell.setRawContent(line[i]);
                    cell.setFeature(feature);
                    if (i > products.size()) {
                        Product newProduct = this.factory.createProduct();
                        newProduct.setName("Product");
                        pcm.addProduct(newProduct);
                        products.add(newProduct);
                        metadata.setProductPosition(newProduct, i);
                    }
                    ((Product)products.get(i - 1)).addCell(cell);
                }
                line = reader.readNext();
            }
        }
        return container;
    }
}

