/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.Value;
import org.opencompare.api.java.exception.MergeConflictException;
import org.opencompare.api.java.util.DiffResult;
import org.opencompare.api.java.util.PCMElementComparator;
import org.opencompare.api.java.util.SimplePCMElementComparator;
import org.opencompare.api.java.value.BooleanValue;

public abstract class PCMTest {
    protected PCMFactory factory;

    public Feature createFeature(PCM pcm, String name) {
        Feature feature = this.factory.createFeature();
        feature.setName(name);
        pcm.addFeature((AbstractFeature)feature);
        return feature;
    }

    public FeatureGroup createFeatureGroup(PCM pcm, String name) {
        FeatureGroup featureGroup = this.factory.createFeatureGroup();
        featureGroup.setName(name);
        pcm.addFeature((AbstractFeature)featureGroup);
        return featureGroup;
    }

    public Product createProduct(PCM pcm) {
        Product product = this.factory.createProduct();
        pcm.addProduct(product);
        return product;
    }

    public Cell createCell(Product product, Feature feature, String content, Value interpretation) {
        Cell cell = this.factory.createCell();
        cell.setFeature(feature);
        cell.setContent(content);
        cell.setInterpretation(interpretation);
        product.addCell(cell);
        return cell;
    }

    @Before
    public abstract void setUp();

    @Test
    public void testPCM() {
        PCM pcm = this.factory.createPCM();
        Assert.assertEquals((long)pcm.getFeatures().size(), (long)0L);
        Assert.assertEquals((long)pcm.getProducts().size(), (long)0L);
        pcm.setName("pcm name");
        Assert.assertEquals((Object)pcm.getName(), (Object)"pcm name");
        pcm.addFeature((AbstractFeature)this.factory.createFeature());
        pcm.addFeature((AbstractFeature)this.factory.createFeatureGroup());
        Assert.assertEquals((long)pcm.getFeatures().size(), (long)2L);
        pcm.removeFeature((AbstractFeature)pcm.getFeatures().get(0));
        Assert.assertEquals((long)pcm.getFeatures().size(), (long)1L);
        pcm.addProduct(this.factory.createProduct());
        Assert.assertEquals((long)pcm.getProducts().size(), (long)1L);
        pcm.removeProduct((Product)pcm.getProducts().get(0));
        Assert.assertEquals((long)pcm.getProducts().size(), (long)0L);
    }

    @Test
    public void testFeature() throws Exception {
        Feature feature = this.factory.createFeature();
        feature.setName("feature name");
        Assert.assertEquals((Object)feature.getName(), (Object)"feature name");
    }

    @Test
    public void testFeatureGroup() throws Exception {
        FeatureGroup featureGroup = this.factory.createFeatureGroup();
        Assert.assertEquals((long)featureGroup.getFeatures().size(), (long)0L);
        featureGroup.setName("feature group name");
        Assert.assertEquals((Object)featureGroup.getName(), (Object)"feature group name");
        Feature feature = this.factory.createFeature();
        featureGroup.addFeature((AbstractFeature)feature);
        featureGroup.addFeature((AbstractFeature)this.factory.createFeatureGroup());
        Assert.assertEquals((long)featureGroup.getFeatures().size(), (long)2L);
        featureGroup.removeFeature((AbstractFeature)feature);
        Assert.assertEquals((long)featureGroup.getFeatures().size(), (long)1L);
        Assert.assertThat(featureGroup.getFeatures().get(0), (Matcher)CoreMatchers.instanceOf(FeatureGroup.class));
    }

    @Test
    public void testProduct() throws Exception {
        Product product = this.factory.createProduct();
        Assert.assertEquals((long)product.getCells().size(), (long)0L);
        Cell cell = this.factory.createCell();
        product.addCell(cell);
        Assert.assertEquals((long)product.getCells().size(), (long)1L);
        product.removeCell(cell);
        Assert.assertEquals((long)product.getCells().size(), (long)0L);
    }

    @Test
    public void testCell() throws Exception {
        Cell cell = this.factory.createCell();
        cell.setContent("content");
        Assert.assertEquals((Object)cell.getContent(), (Object)"content");
        BooleanValue value = this.factory.createBooleanValue();
        value.setValue(true);
        cell.setInterpretation((Value)value);
        Assert.assertThat((Object)cell.getInterpretation(), (Matcher)CoreMatchers.instanceOf(BooleanValue.class));
        Assert.assertEquals((Object)((BooleanValue)cell.getInterpretation()).getValue(), (Object)true);
        Feature feature = this.factory.createFeature();
        feature.setName("feature name");
        cell.setFeature(feature);
        Assert.assertEquals((Object)cell.getFeature().getName(), (Object)"feature name");
    }

    @Test
    public void testMerge() throws MergeConflictException {
        PCM pcm1 = this.factory.createPCM();
        Feature productsFeature1 = this.createFeature(pcm1, "Products");
        pcm1.setProductsKey(productsFeature1);
        Feature commonFeature1 = this.createFeature(pcm1, "Common feature");
        Feature feature1 = this.createFeature(pcm1, "Feature from PCM 1");
        FeatureGroup commonFeatureGroup1 = this.createFeatureGroup(pcm1, "Common feature group");
        Feature commonFeatureFG1 = this.factory.createFeature();
        commonFeatureFG1.setName("Common feature group - common feature");
        commonFeatureGroup1.addFeature((AbstractFeature)commonFeatureFG1);
        FeatureGroup featureGroup1 = this.createFeatureGroup(pcm1, "Feature group from PCM 1");
        Feature featureFG1 = this.factory.createFeature();
        featureFG1.setName("Feature group from PCM 1 - feature");
        featureGroup1.addFeature((AbstractFeature)featureFG1);
        Product commonProduct1 = this.createProduct(pcm1);
        this.createCell(commonProduct1, productsFeature1, "Common product", null);
        this.createCell(commonProduct1, commonFeature1, "", null);
        this.createCell(commonProduct1, feature1, "", null);
        this.createCell(commonProduct1, commonFeatureFG1, "", null);
        this.createCell(commonProduct1, featureFG1, "", null);
        Product product1 = this.createProduct(pcm1);
        this.createCell(product1, productsFeature1, "Product from PCM 1", null);
        this.createCell(product1, commonFeature1, "", null);
        this.createCell(product1, feature1, "", null);
        this.createCell(product1, commonFeatureFG1, "", null);
        this.createCell(product1, featureFG1, "", null);
        PCM pcm2 = this.factory.createPCM();
        Feature productsFeature2 = this.createFeature(pcm2, "Products");
        pcm2.setProductsKey(productsFeature2);
        Feature commonFeature2 = this.createFeature(pcm2, "Common feature");
        Feature feature2 = this.createFeature(pcm2, "Feature from PCM 2");
        FeatureGroup commonFeatureGroup2 = this.createFeatureGroup(pcm2, "Common feature group");
        Feature commonFeatureFG2 = this.factory.createFeature();
        commonFeatureFG2.setName("Common feature group - common feature");
        commonFeatureGroup2.addFeature((AbstractFeature)commonFeatureFG2);
        FeatureGroup featureGroup2 = this.createFeatureGroup(pcm2, "Feature group from PCM 2");
        Feature featureFG2 = this.factory.createFeature();
        featureFG2.setName("Feature group from PCM 2 - feature");
        featureGroup2.addFeature((AbstractFeature)featureFG2);
        Product commonProduct2 = this.createProduct(pcm2);
        this.createCell(commonProduct2, productsFeature2, "Common product", null);
        this.createCell(commonProduct2, commonFeature2, "", null);
        this.createCell(commonProduct2, feature2, "", null);
        this.createCell(commonProduct2, commonFeatureFG2, "", null);
        this.createCell(commonProduct2, featureFG2, "", null);
        Product product2 = this.createProduct(pcm2);
        this.createCell(product2, productsFeature2, "Product from PCM 2", null);
        this.createCell(product2, commonFeature2, "", null);
        this.createCell(product2, feature2, "", null);
        this.createCell(product2, commonFeatureFG2, "", null);
        this.createCell(product2, featureFG2, "", null);
        pcm1.merge(pcm2, this.factory);
        Assert.assertEquals((String)"number of features", (long)7L, (long)pcm1.getFeatures().size());
        Assert.assertEquals((String)"number of concrete features", (long)7L, (long)pcm1.getFeatures().size());
        Assert.assertEquals((String)"number of products", (long)3L, (long)pcm1.getProducts().size());
        for (Product product : pcm1.getProducts()) {
            Assert.assertEquals((String)"number of cells", (long)7L, (long)product.getCells().size());
        }
    }

    @Test
    public void testIsValid() {
        PCM pcm = this.factory.createPCM();
        Feature productsF = this.createFeature(pcm, "Products");
        pcm.setProductsKey(productsF);
        Feature f1 = this.createFeature(pcm, "F1");
        Feature f2 = this.createFeature(pcm, "F2");
        Assert.assertTrue((boolean)pcm.isValid());
        Feature f3 = this.createFeature(pcm, "F2");
        Assert.assertFalse((boolean)pcm.isValid());
        pcm.removeFeature((AbstractFeature)f3);
        Assert.assertTrue((boolean)pcm.isValid());
        Product p1 = this.createProduct(pcm);
        this.createCell(p1, productsF, "P1", null);
        this.createCell(p1, f1, "C11", null);
        Assert.assertFalse((boolean)pcm.isValid());
        this.createCell(p1, f2, "C12", null);
        Assert.assertTrue((boolean)pcm.isValid());
        Product p2 = this.createProduct(pcm);
        this.createCell(p2, productsF, "P2", null);
        this.createCell(p2, f1, "C21", null);
        Assert.assertFalse((boolean)pcm.isValid());
        this.createCell(p2, f2, "C22", null);
        Assert.assertTrue((boolean)pcm.isValid());
        Product p3 = this.createProduct(pcm);
        this.createCell(p3, productsF, "P2", null);
        this.createCell(p3, f1, "C21", null);
        this.createCell(p3, f2, "C22", null);
        Assert.assertFalse((boolean)pcm.isValid());
        pcm.removeProduct(p3);
        Assert.assertTrue((boolean)pcm.isValid());
    }

    @Test
    public void testGetConcreteFeatures() {
        PCM pcm = this.factory.createPCM();
        this.createFeature(pcm, "Top level feature");
        FeatureGroup group = this.createFeatureGroup(pcm, "FG");
        Feature subFeature1 = this.factory.createFeature();
        subFeature1.setName("Sub feature 1");
        group.addFeature((AbstractFeature)subFeature1);
        Feature subFeature2 = this.factory.createFeature();
        subFeature2.setName("Sub feature 2");
        group.addFeature((AbstractFeature)subFeature2);
        Assert.assertEquals((String)"number of top level abstract features", (long)2L, (long)pcm.getFeatures().size());
        Assert.assertEquals((String)"number of features", (long)3L, (long)pcm.getConcreteFeatures().size());
    }

    @Test
    public void testDiff() {
        PCM pcm1 = this.factory.createPCM();
        Feature productsFeature1 = this.createFeature(pcm1, "Products");
        pcm1.setProductsKey(productsFeature1);
        Feature commonFeature1 = this.createFeature(pcm1, "Common feature");
        Feature feature1 = this.createFeature(pcm1, "Feature from PCM 1");
        Product commonProduct1 = this.createProduct(pcm1);
        this.createCell(commonProduct1, productsFeature1, "Common product", null);
        this.createCell(commonProduct1, commonFeature1, "common cell 1", null);
        this.createCell(commonProduct1, feature1, "", null);
        Product product1 = this.createProduct(pcm1);
        this.createCell(product1, productsFeature1, "Product from PCM 1", null);
        this.createCell(product1, commonFeature1, "", null);
        this.createCell(product1, feature1, "", null);
        PCM pcm2 = this.factory.createPCM();
        Feature productsFeature2 = this.createFeature(pcm2, "Products");
        pcm2.setProductsKey(productsFeature2);
        Feature commonFeature2 = this.createFeature(pcm2, "Common feature");
        Feature feature2 = this.createFeature(pcm2, "Feature from PCM 2");
        Product commonProduct2 = this.createProduct(pcm2);
        this.createCell(commonProduct2, productsFeature2, "Common product", null);
        this.createCell(commonProduct2, commonFeature2, "common cell 2", null);
        this.createCell(commonProduct2, feature2, "", null);
        Product product2 = this.createProduct(pcm2);
        this.createCell(product2, productsFeature2, "Product from PCM 2", null);
        this.createCell(product2, commonFeature2, "", null);
        this.createCell(product2, feature2, "", null);
        DiffResult diffResult = pcm1.diff(pcm2, (PCMElementComparator)new SimplePCMElementComparator());
        Assert.assertEquals((String)"common features", (long)2L, (long)diffResult.getCommonFeatures().size());
        Assert.assertEquals((String)"features only in PCM 1", (long)1L, (long)diffResult.getFeaturesOnlyInPCM1().size());
        Assert.assertEquals((String)"features only in PCM 2", (long)1L, (long)diffResult.getFeaturesOnlyInPCM2().size());
        Assert.assertEquals((String)"common products", (long)1L, (long)diffResult.getCommonProducts().size());
        Assert.assertEquals((String)"products only in PCM 1", (long)1L, (long)diffResult.getProductsOnlyInPCM1().size());
        Assert.assertEquals((String)"products only in PCM 2", (long)1L, (long)diffResult.getProductsOnlyInPCM2().size());
        Assert.assertEquals((String)"differing cells", (long)1L, (long)diffResult.getDifferingCells().size());
    }

    @Test
    public void testInvert() {
        PCM pcm = this.factory.createPCM();
        Feature productsFeature = this.createFeature(pcm, "Products");
        Feature f1 = this.createFeature(pcm, "F1");
        Feature f2 = this.createFeature(pcm, "F2");
        pcm.setProductsKey(productsFeature);
        Product p1 = this.createProduct(pcm);
        Product p2 = this.createProduct(pcm);
        this.createCell(p1, productsFeature, "P1", null);
        this.createCell(p1, f1, "CP1F1", null);
        this.createCell(p1, f2, "CP1F2", null);
        this.createCell(p2, productsFeature, "P2", null);
        this.createCell(p2, f1, "CP2F1", null);
        this.createCell(p2, f2, "CP2F2", null);
        pcm.invert(this.factory);
        Assert.assertEquals((String)"#features", (long)3L, (long)pcm.getConcreteFeatures().size());
        Assert.assertEquals((String)"#products", (long)2L, (long)pcm.getProducts().size());
        Assert.assertEquals((String)"product key", (Object)pcm.getProductsKey().getName(), (Object)"Products");
        for (Product product : pcm.getProducts()) {
            Assert.assertTrue((String)"new product is an original feature", (boolean)product.getKeyContent().startsWith("F"));
            Assert.assertEquals((String)"number of cells", (long)3L, (long)product.getCells().size());
            for (Cell cell : product.getCells()) {
                if (cell.getFeature().equals(pcm.getProductsKey())) continue;
                Assert.assertTrue((String)"new feature is an original product", (boolean)cell.getFeature().getName().startsWith("P"));
                Assert.assertEquals((String)"cell name", (Object)("C" + cell.getFeature().getName() + product.getKeyContent()), (Object)cell.getContent());
            }
        }
    }

    @Test
    public void testGetCellsFromFeature() {
        PCM pcm = this.factory.createPCM();
        Feature feature = this.createFeature(pcm, "feature");
        Product p1 = this.createProduct(pcm);
        Product p2 = this.createProduct(pcm);
        this.createCell(p1, feature, "C1", null);
        this.createCell(p2, feature, "C2", null);
        List cells = feature.getCells();
        Assert.assertEquals((String)"get cells from feature", (long)2L, (long)cells.size());
    }

    @Test
    public void testEqualsAndHashCode() {
        PCM pcm1 = this.factory.createPCM();
        PCM pcm2 = this.factory.createPCM();
        Feature f1 = this.createFeature(pcm1, "feature");
        Feature f2 = this.createFeature(pcm2, "feature");
        Product p1 = this.createProduct(pcm1);
        Product p2 = this.createProduct(pcm2);
        Cell c1 = this.createCell(p1, f1, "cell", null);
        Cell c2 = this.createCell(p2, f2, "cell", null);
        Assert.assertEquals((String)"equals - cell", (Object)c1, (Object)c2);
        Assert.assertEquals((String)"equals - feature", (Object)f1, (Object)f2);
        Assert.assertEquals((String)"equals - product", (Object)p1, (Object)p2);
        Assert.assertEquals((String)"equals - pcm", (Object)pcm1, (Object)pcm2);
        Assert.assertEquals((String)"hash code - cell", (long)c1.hashCode(), (long)c2.hashCode());
        Assert.assertEquals((String)"hash code - feature", (long)f1.hashCode(), (long)f2.hashCode());
        Assert.assertEquals((String)"hash code - product", (long)p1.hashCode(), (long)p2.hashCode());
        Assert.assertEquals((String)"hash code - pcm", (long)pcm1.hashCode(), (long)pcm2.hashCode());
    }
}

