/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.io.ExportCell;
import org.opencompare.api.java.io.ExportMatrix;
import org.opencompare.api.java.io.ExportMatrixExporter;
import org.opencompare.api.java.io.PCMExporter;

public class CSVExporter
implements PCMExporter {
    private ExportMatrixExporter exportMatrixExporter = new ExportMatrixExporter();

    @Override
    public String export(PCMContainer container) {
        return this.export(container, ',', '\"');
    }

    public String export(PCMContainer container, char separator, char quote) {
        PCM pcm = container.getPcm();
        PCMMetadata metadata = container.getMetadata();
        if (metadata == null) {
            metadata = new PCMMetadata(pcm);
        }
        StringWriter stringWriter = new StringWriter();
        CSVWriter csvWriter = new CSVWriter((Writer)stringWriter, separator, quote);
        ExportMatrix exportMatrix = this.exportMatrixExporter.export(container);
        exportMatrix.flattenCells();
        for (int row = 0; row < exportMatrix.getNumberOfRows(); ++row) {
            String[] line = new String[exportMatrix.getNumberOfColumns()];
            for (int column = 0; column < exportMatrix.getNumberOfColumns(); ++column) {
                ExportCell cell = (ExportCell)exportMatrix.getCell(row, column);
                line[column] = cell != null ? cell.getContent() : "";
            }
            csvWriter.writeNext(line);
        }
        try {
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }
}

