/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.interpreter.CellContentInterpreter;
import org.opencompare.api.java.io.ImportCell;
import org.opencompare.api.java.io.ImportMatrix;
import org.opencompare.api.java.io.ImportMatrixLoader;
import org.opencompare.api.java.io.PCMDirection;
import org.opencompare.api.java.io.PCMLoader;

public class CSVLoader
implements PCMLoader {
    private PCMFactory factory;
    private char separator;
    private char quote;
    private ImportMatrixLoader importMatrixLoader;

    public CSVLoader(PCMFactory factory, CellContentInterpreter cellContentInterpreter) {
        this(factory, cellContentInterpreter, ',');
    }

    public CSVLoader(PCMFactory factory, CellContentInterpreter cellContentInterpreter, char separator) {
        this(factory, cellContentInterpreter, separator, '\"');
    }

    public CSVLoader(PCMFactory factory, CellContentInterpreter cellContentInterpreter, char separator, char quote) {
        this(factory, cellContentInterpreter, separator, quote, PCMDirection.UNKNOWN);
    }

    public CSVLoader(PCMFactory factory, CellContentInterpreter cellContentInterpreter, PCMDirection pcmDirection) {
        this(factory, cellContentInterpreter, ',', '\"', pcmDirection);
    }

    public CSVLoader(PCMFactory factory, CellContentInterpreter cellContentInterpreter, char separator, char quote, PCMDirection pcmDirection) {
        this.factory = factory;
        this.separator = separator;
        this.quote = quote;
        this.importMatrixLoader = new ImportMatrixLoader(this.factory, cellContentInterpreter, pcmDirection);
    }

    private ImportMatrix createMatrix(CSVReader reader) throws IOException {
        ImportMatrix matrix = new ImportMatrix();
        int row = 0;
        String[] line = reader.readNext();
        while (line != null) {
            for (int column = 0; column < line.length; ++column) {
                matrix.setCell(new ImportCell(line[column]), row, column);
            }
            ++row;
            line = reader.readNext();
        }
        return matrix;
    }

    @Override
    public List<PCMContainer> load(String pcm) {
        List<PCMContainer> containers = new ArrayList<PCMContainer>();
        try {
            containers = this.load(new StringReader(pcm));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return containers;
    }

    @Override
    public List<PCMContainer> load(File file) throws IOException {
        List<PCMContainer> containers = new ArrayList<PCMContainer>();
        try {
            containers = this.load(new FileReader(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return containers;
    }

    public List<PCMContainer> load(ImportMatrix matrix) {
        ArrayList<PCMContainer> result = new ArrayList<PCMContainer>();
        result.add(this.importMatrixLoader.load(matrix));
        return result;
    }

    public List<PCMContainer> load(Reader reader) throws IOException {
        CSVReader csvReader = new CSVReader(reader, this.separator, this.quote);
        ImportMatrix matrix = this.createMatrix(csvReader);
        return this.load(matrix);
    }
}

