/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.io.ExportCell;
import org.opencompare.api.java.io.ExportMatrix;
import org.opencompare.api.java.util.Pair;

public class ExportMatrixExporter {
    public ExportMatrix export(PCMContainer pcmContainer) {
        PCM pcm = pcmContainer.getPcm();
        PCMMetadata metadata = pcmContainer.getMetadata() == null ? new PCMMetadata(pcm) : pcmContainer.getMetadata();
        ExportMatrix matrix = new ExportMatrix();
        matrix.setName(pcm.getName());
        int productsStartRow = this.exportFeatures(metadata, matrix);
        this.exportProducts(pcm, metadata, matrix, productsStartRow);
        if (!metadata.getProductAsLines().booleanValue()) {
            matrix.transpose();
        }
        return matrix;
    }

    /*
     * WARNING - void declaration
     */
    private int exportFeatures(PCMMetadata metadata, ExportMatrix matrix) {
        ArrayList<Pair<Feature, Pair<Integer, Integer>>> currentFeatureLevel = new ArrayList<Pair<Feature, Pair<Integer, Integer>>>();
        for (Feature feature : metadata.getSortedFeatures()) {
            currentFeatureLevel.add(new Pair<Feature, Pair<Integer, Integer>>(feature, new Pair<Integer, Integer>(1, 1)));
        }
        ArrayList exportCellRows = new ArrayList();
        boolean noParents = false;
        while (!currentFeatureLevel.isEmpty() && !noParents) {
            void var8_10;
            ArrayList<Pair<AbstractFeature, Pair<Integer, Integer>>> nextFeatureLevel = new ArrayList<Pair<AbstractFeature, Pair<Integer, Integer>>>();
            ArrayList row = new ArrayList();
            noParents = true;
            for (Pair pair : currentFeatureLevel) {
                if (((AbstractFeature)pair._1).getParentGroup() == null) continue;
                noParents = false;
            }
            boolean bl = false;
            while (var8_10 < currentFeatureLevel.size()) {
                Pair pair = (Pair)currentFeatureLevel.get((int)var8_10);
                AbstractFeature aFeature = (AbstractFeature)pair._1;
                Pair pair2 = (Pair)pair._2;
                int colspan = 1;
                while (var8_10 + true < currentFeatureLevel.size() && aFeature.equals(((Pair)currentFeatureLevel.get((int)(var8_10 + true)))._1)) {
                    ++var8_10;
                    ++colspan;
                }
                FeatureGroup parentGroup = aFeature.getParentGroup();
                if (parentGroup == null) {
                    int rowspan = (Integer)pair2._1 + 1;
                    nextFeatureLevel.add(new Pair<AbstractFeature, Pair<Integer, Integer>>(aFeature, new Pair<Integer, Integer>(rowspan, colspan)));
                    if (noParents) {
                        row.add(new Pair(aFeature, new Pair(pair2._1, colspan)));
                    }
                } else {
                    row.add(new Pair(aFeature, new Pair(pair2._1, colspan)));
                    nextFeatureLevel.add(new Pair<FeatureGroup, Pair<Integer, Integer>>(parentGroup, new Pair<Integer, Integer>(1, 1)));
                }
                ++var8_10;
            }
            ArrayList<ExportCell> arrayList = new ArrayList<ExportCell>();
            for (Pair pair : row) {
                AbstractFeature aFeature = (AbstractFeature)pair._1;
                Pair span = (Pair)pair._2;
                ExportCell exportCell = new ExportCell(aFeature.getName(), (Integer)span._1, (Integer)span._2);
                exportCell.setFeature(true);
                exportCell.setInProductsKeyColumn(false);
                arrayList.add(exportCell);
            }
            exportCellRows.add(arrayList);
            currentFeatureLevel = nextFeatureLevel;
        }
        Collections.reverse(exportCellRows);
        int row = 0;
        for (List list : exportCellRows) {
            void var9_20;
            boolean bl = false;
            while (matrix.isPositionOccupied(row, (int)var9_20)) {
                ++var9_20;
            }
            for (ExportCell exportCell : list) {
                matrix.setCell(exportCell, row, (int)var9_20);
                var9_20 += exportCell.getColspan();
            }
            ++row;
        }
        return row;
    }

    private void exportProducts(PCM pcm, PCMMetadata metadata, ExportMatrix matrix, int productsStartRow) {
        int row = productsStartRow;
        for (Product product : metadata.getSortedProducts()) {
            int column = 0;
            for (Feature feature : metadata.getSortedFeatures()) {
                Cell cell = product.findCell(feature);
                if (cell != null) {
                    ExportCell exportCell = new ExportCell(cell.getContent(), cell.getRawContent());
                    exportCell.setFeature(false);
                    exportCell.setInProductsKeyColumn(pcm.getProductsKey().equals(feature));
                    matrix.setCell(exportCell, row, column);
                }
                ++column;
            }
            ++row;
        }
    }
}

