/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.io.ExportCell;
import org.opencompare.api.java.io.ExportMatrix;
import org.opencompare.api.java.io.ExportMatrixExporter;
import org.opencompare.api.java.io.PCMExporter;

public class HTMLExporter
implements PCMExporter {
    private ExportMatrixExporter exportMatrixExporter = new ExportMatrixExporter();

    @Override
    public String export(PCMContainer pcmContainer) {
        PCM pcm = pcmContainer.getPcm();
        PCMMetadata metadata = pcmContainer.getMetadata() == null ? new PCMMetadata(pcm) : pcmContainer.getMetadata();
        Document doc = Document.createShell((String)"");
        Element head = doc.head();
        Element body = doc.body();
        head.appendElement("meta").attr("charset", "utf-8");
        head.appendElement("title").text(pcm.getName());
        body.appendElement("h1").text(pcm.getName());
        Element table = body.appendElement("table").attr("border", "1");
        ExportMatrix exportMatrix = this.exportMatrixExporter.export(pcmContainer);
        for (int row = 0; row < exportMatrix.getNumberOfRows(); ++row) {
            Element htmlRow = table.appendElement("tr");
            for (int column = 0; column < exportMatrix.getNumberOfColumns(); ++column) {
                ExportCell exportCell = (ExportCell)exportMatrix.getCell(row, column);
                if (exportCell == null) continue;
                Element htmlCell = exportCell.isFeature() || exportCell.isInProductsKeyColumn() ? htmlRow.appendElement("th") : htmlRow.appendElement("td");
                htmlCell.attr("style", "white-space: pre;");
                htmlCell.text(this.textToHTML(exportCell.getContent()));
                if (exportCell.getRowspan() > 1) {
                    htmlCell.attr("rowspan", "" + exportCell.getRowspan());
                }
                if (exportCell.getColspan() <= 1) continue;
                htmlCell.attr("colspan", "" + exportCell.getColspan());
            }
        }
        Document.OutputSettings settings = new Document.OutputSettings().prettyPrint(false);
        return doc.outputSettings(settings).outerHtml();
    }

    private String textToHTML(String text) {
        return text;
    }
}

