/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.interpreter.CellContentInterpreter;
import org.opencompare.api.java.io.ImportCell;
import org.opencompare.api.java.io.ImportMatrix;
import org.opencompare.api.java.io.ImportMatrixLoader;
import org.opencompare.api.java.io.PCMDirection;
import org.opencompare.api.java.io.PCMLoader;

public class HTMLLoader
implements PCMLoader {
    private PCMFactory factory;
    private ImportMatrixLoader importMatrixLoader;

    public HTMLLoader(PCMFactory factory, CellContentInterpreter cellContentInterpreter) {
        this(factory, cellContentInterpreter, PCMDirection.UNKNOWN);
    }

    public HTMLLoader(PCMFactory factory, CellContentInterpreter cellContentInterpreter, PCMDirection pcmDirection) {
        this.factory = factory;
        this.importMatrixLoader = new ImportMatrixLoader(this.factory, cellContentInterpreter, pcmDirection);
    }

    private List<ImportMatrix> createMatrices(Document doc) {
        ArrayList<ImportMatrix> matrices = new ArrayList<ImportMatrix>();
        String pageName = doc.head().getElementsByTag("title").text();
        int index = 0;
        Elements tables = doc.getElementsByTag("table");
        for (Element table : tables) {
            ImportMatrix matrix = new ImportMatrix();
            if (tables.size() > 1) {
                matrix.setName(pageName + " #" + index);
            } else {
                matrix.setName(pageName);
            }
            int i = 0;
            for (Element row : table.getElementsByTag("tr")) {
                int j = 0;
                while (matrix.isPositionOccupied(i, j)) {
                    ++j;
                }
                for (Element column : row.getAllElements()) {
                    if (!column.tag().getName().equals("th") && !column.tag().getName().equals("td")) continue;
                    if (matrix.getCell(i, j) != null) {
                        ++j;
                    }
                    int rowspan = 1;
                    int colspan = 1;
                    if (!column.attributes().get("rowspan").isEmpty()) {
                        rowspan = Integer.valueOf(column.attributes().get("rowspan"));
                    }
                    if (!column.attributes().get("colspan").isEmpty()) {
                        colspan = Integer.valueOf(column.attributes().get("colspan"));
                    }
                    ImportCell importCell = new ImportCell(this.cellToText(column), rowspan, colspan);
                    matrix.setCell(importCell, i, j);
                    j += colspan;
                }
                ++i;
            }
            matrices.add(matrix);
            ++index;
        }
        return matrices;
    }

    private String cellToText(Element element) {
        String text = "";
        for (Node node : element.childNodes()) {
            switch (node.nodeName()) {
                case "#text": {
                    TextNode tn = (TextNode)node;
                    text = text + tn.getWholeText();
                    break;
                }
                case "br": {
                    text = text + "\n";
                    break;
                }
            }
        }
        return text;
    }

    @Override
    public List<PCMContainer> load(String pcm) {
        Document doc = Jsoup.parse((String)pcm);
        ArrayList<PCMContainer> containers = new ArrayList<PCMContainer>();
        for (ImportMatrix matrix : this.createMatrices(doc)) {
            containers.add(this.load(matrix).get(0));
        }
        return containers;
    }

    @Override
    public List<PCMContainer> load(File file) throws IOException {
        Document doc = Jsoup.parse((File)file, (String)"UTF-8");
        ArrayList<PCMContainer> containers = new ArrayList<PCMContainer>();
        for (ImportMatrix matrix : this.createMatrices(doc)) {
            containers.add(this.load(matrix).get(0));
        }
        return containers;
    }

    public List<PCMContainer> load(ImportMatrix matrix) {
        ArrayList<PCMContainer> result = new ArrayList<PCMContainer>();
        result.add(this.importMatrixLoader.load(matrix));
        return result;
    }
}

