/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.opencompare.api.java.io.IOMatrix;
import org.opencompare.api.java.io.ImportCell;
import org.opencompare.api.java.util.Pair;

public class ImportMatrix
extends IOMatrix<ImportCell> {
    public void removeDuplicatedLines() {
        int i;
        LinkedHashSet lines = new LinkedHashSet();
        for (i = 0; i < this.getNumberOfRows(); ++i) {
            ArrayList line = new ArrayList();
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                line.add(this.cells.get(new Pair<Integer, Integer>(i, j)));
            }
            lines.add(line);
        }
        this.cells = new HashMap();
        i = 0;
        for (List list : lines) {
            int j = 0;
            for (ImportCell cell : list) {
                this.cells.put(new Pair<Integer, Integer>(i, j), cell);
                ++j;
            }
            ++i;
        }
        this.maxRow = lines.size() - 1;
    }

    public void removeEmptyLines() {
        int removedLines = 0;
        for (int row = 0; row < this.getNumberOfRows(); ++row) {
            ImportCell cell;
            int column;
            boolean emptyline = true;
            for (column = 0; column < this.getNumberOfColumns(); ++column) {
                cell = (ImportCell)this.cells.get(new Pair<Integer, Integer>(row, column));
                if (cell == null || cell.content.matches("\\s*")) continue;
                emptyline = false;
                break;
            }
            if (emptyline) {
                ++removedLines;
            }
            if (removedLines <= 0) continue;
            for (column = 0; column < this.getNumberOfColumns(); ++column) {
                cell = (ImportCell)this.cells.get(new Pair<Integer, Integer>(row, column));
                if (cell != null && !emptyline) {
                    this.cells.put(new Pair<Integer, Integer>(row - removedLines, column), cell);
                }
                this.cells.remove(new Pair<Integer, Integer>(row, column));
            }
        }
        this.maxRow -= removedLines;
    }
}

