/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.Value;
import org.opencompare.api.java.interpreter.CellContentInterpreter;
import org.opencompare.api.java.io.IOCell;
import org.opencompare.api.java.io.IONode;
import org.opencompare.api.java.io.ImportCell;
import org.opencompare.api.java.io.ImportMatrix;
import org.opencompare.api.java.io.PCMDirection;

public class ImportMatrixLoader {
    private PCMFactory factory;
    private PCMDirection direction;
    private CellContentInterpreter cellContentInterpreter;

    public ImportMatrixLoader(PCMFactory factory, CellContentInterpreter cellContentInterpreter, PCMDirection direction) {
        this.factory = factory;
        this.direction = direction;
        this.cellContentInterpreter = cellContentInterpreter;
    }

    public PCMContainer load(ImportMatrix matrix) {
        this.detectTypes(matrix);
        matrix.flattenCells();
        this.removeHoles(matrix);
        PCMDirection detectedDirection = this.direction;
        if (detectedDirection == PCMDirection.UNKNOWN) {
            detectedDirection = this.detectDirection(matrix);
        }
        matrix.removeEmptyLines();
        matrix.removeDuplicatedLines();
        matrix.transpose();
        matrix.removeEmptyLines();
        matrix.removeDuplicatedLines();
        if (detectedDirection == PCMDirection.PRODUCTS_AS_LINES) {
            matrix.transpose();
        }
        PCM pcm = this.factory.createPCM();
        PCMMetadata pcmMetadata = new PCMMetadata(pcm);
        PCMContainer pcmContainer = new PCMContainer(pcmMetadata);
        pcm.setName(matrix.getName());
        IONode<String> featureTreeRoot = this.detectFeatures(matrix, pcmContainer);
        HashMap<Integer, Feature> positionToFeature = new HashMap<Integer, Feature>();
        List<AbstractFeature> topFeatures = this.createFeatures(featureTreeRoot, positionToFeature);
        topFeatures.forEach(feature -> pcm.addFeature((AbstractFeature)feature));
        for (Map.Entry entry : positionToFeature.entrySet()) {
            pcmMetadata.setFeaturePosition((AbstractFeature)entry.getValue(), (Integer)entry.getKey());
        }
        this.createProducts(matrix, pcmContainer, positionToFeature);
        this.setProductsKey(pcmContainer);
        return pcmContainer;
    }

    protected void detectTypes(ImportMatrix matrix) {
        for (int row = 0; row < matrix.getNumberOfRows(); ++row) {
            for (int column = 0; column < matrix.getNumberOfColumns(); ++column) {
                ImportCell cell = (ImportCell)matrix.getCell(row, column);
                if (cell == null || cell.getInterpretation() != null) continue;
                cell.setInterpretation(this.cellContentInterpreter.interpretString(cell.getContent()));
            }
        }
    }

    protected PCMDirection detectDirection(ImportMatrix matrix) {
        int column;
        double sumHomogeneityOfRow = 0.0;
        for (int row = 0; row < matrix.getNumberOfRows(); ++row) {
            HashMap<String, Integer> types = new HashMap<String, Integer>();
            for (column = 0; column < matrix.getNumberOfColumns(); ++column) {
                this.countType(matrix, row, column, types);
            }
            if (types.isEmpty()) continue;
            double homogeneityOfRow = (double)((Integer)Collections.max(types.values())).intValue() / (double)matrix.getNumberOfColumns();
            sumHomogeneityOfRow += homogeneityOfRow;
        }
        double homogeneityOfColumns = 0.0;
        for (column = 0; column < matrix.getNumberOfColumns(); ++column) {
            HashMap<String, Integer> types = new HashMap<String, Integer>();
            for (int row = 0; row < matrix.getNumberOfRows(); ++row) {
                this.countType(matrix, row, column, types);
            }
            if (types.isEmpty()) continue;
            double homogeneityOfColumn = (double)((Integer)Collections.max(types.values())).intValue() / (double)matrix.getNumberOfRows();
            homogeneityOfColumns += homogeneityOfColumn;
        }
        if (sumHomogeneityOfRow / (double)matrix.getNumberOfRows() > homogeneityOfColumns / (double)matrix.getNumberOfColumns()) {
            return PCMDirection.PRODUCTS_AS_COLUMNS;
        }
        return PCMDirection.PRODUCTS_AS_LINES;
    }

    private void countType(ImportMatrix matrix, int row, int column, Map<String, Integer> types) {
        Value value;
        ImportCell cell = (ImportCell)matrix.getCell(row, column);
        if (cell != null && (value = cell.getInterpretation()) != null) {
            String typeName = value.getClass().getName();
            Integer previousCount = types.getOrDefault(typeName, 0);
            types.put(typeName, previousCount + 1);
        }
    }

    protected IONode<String> detectFeatures(ImportMatrix matrix, PCMContainer pcmContainer) {
        IONode<Object> root = new IONode<Object>(null);
        ArrayList<IONode<Object>> parents = new ArrayList<IONode<Object>>();
        for (int column = 0; column < matrix.getNumberOfColumns(); ++column) {
            parents.add(root);
        }
        for (int row = 0; row < matrix.getNumberOfRows(); ++row) {
            ArrayList<IONode> nextParents = new ArrayList<IONode>(parents);
            for (int column = 0; column < matrix.getNumberOfColumns(); ++column) {
                Object currentCell = matrix.getCell(row, column);
                if (currentCell == null) {
                    currentCell = new IOCell("");
                }
                IONode parent = (IONode)parents.get(column);
                boolean sameAsParent = ((IOCell)currentCell).getContent().equals(parent.getContent());
                boolean sameAsPrevious = false;
                boolean sameParentAsPrevious = true;
                if (column > 0) {
                    Object previousCell = matrix.getCell(row, column - 1);
                    if (previousCell == null) {
                        previousCell = new IOCell("");
                    }
                    sameAsPrevious = ((IOCell)currentCell).getContent().equals(((IOCell)previousCell).getContent());
                    if (parent.getContent() != null) {
                        sameParentAsPrevious = ((String)parent.getContent()).equals(((IONode)parents.get(column - 1)).getContent());
                    }
                }
                if (!(sameAsParent || sameParentAsPrevious && sameAsPrevious)) {
                    IONode<String> newNode = new IONode<String>(((IOCell)currentCell).getContent());
                    newNode.getPositions().add(column);
                    parent.getChildren().add(newNode);
                    nextParents.set(column, newNode);
                    continue;
                }
                if (column <= 0 || !sameParentAsPrevious || !sameAsPrevious) continue;
                IONode previousNode = (IONode)nextParents.get(column - 1);
                previousNode.getPositions().add(column);
                nextParents.set(column, previousNode);
            }
            parents = nextParents;
            if (root.getLeaves().size() == matrix.getNumberOfColumns()) break;
        }
        return root;
    }

    protected List<AbstractFeature> createFeatures(IONode<String> parent, Map<Integer, Feature> positionToFeature) {
        ArrayList<AbstractFeature> result = new ArrayList<AbstractFeature>();
        for (IONode<String> child : parent.getChildren()) {
            if (child.isLeaf()) {
                Feature feature = this.factory.createFeature();
                feature.setName(child.getContent());
                result.add(feature);
                for (Integer position : child.getPositions()) {
                    positionToFeature.put(position, feature);
                }
                continue;
            }
            FeatureGroup featureGroup = this.factory.createFeatureGroup();
            featureGroup.setName(child.getContent());
            List<AbstractFeature> subFeatures = this.createFeatures(child, positionToFeature);
            subFeatures.forEach(subFeature -> featureGroup.addFeature((AbstractFeature)subFeature));
            result.add(featureGroup);
        }
        return result;
    }

    protected void createProducts(ImportMatrix matrix, PCMContainer pcmContainer, Map<Integer, Feature> positionToFeature) {
        int featuresDepth;
        for (int row = featuresDepth = pcmContainer.getPcm().getFeaturesDepth(); row < matrix.getNumberOfRows(); ++row) {
            Product product = this.factory.createProduct();
            for (int column = 0; column < matrix.getNumberOfColumns(); ++column) {
                Cell cell = this.factory.createCell();
                cell.setFeature(positionToFeature.get(column));
                ImportCell ioCell = (ImportCell)matrix.getCell(row, column);
                if (ioCell == null) {
                    ioCell = new ImportCell("");
                }
                cell.setContent(ioCell.getContent());
                cell.setRawContent(ioCell.getRawContent());
                cell.setInterpretation(ioCell.getInterpretation());
                product.addCell(cell);
            }
            pcmContainer.getPcm().addProduct(product);
            pcmContainer.getMetadata().setProductPosition(product, row);
        }
    }

    protected void setProductsKey(PCMContainer pcmContainer) {
        boolean foundProductsKey = false;
        PCMMetadata metadata = pcmContainer.getMetadata();
        for (Feature feature : metadata.getSortedFeatures()) {
            int disctintCells = feature.getCells().stream().map(cell -> cell.getContent()).distinct().collect(Collectors.toList()).size();
            if (disctintCells != feature.getCells().size()) continue;
            foundProductsKey = true;
            pcmContainer.getPcm().setProductsKey(feature);
            break;
        }
        if (!foundProductsKey) {
            Feature productsKey = this.factory.createFeature();
            productsKey.setName("Products");
            int index = 1;
            for (Product product : metadata.getSortedProducts()) {
                int position = metadata.getProductPosition(product);
                metadata.clearProductPosition(product);
                Cell cell2 = this.factory.createCell();
                cell2.setContent("P" + index);
                cell2.setRawContent(cell2.getContent());
                cell2.setFeature(productsKey);
                product.addCell(cell2);
                metadata.setProductPosition(product, position);
                ++index;
            }
            pcmContainer.getPcm().addFeature(productsKey);
            pcmContainer.getPcm().setProductsKey(productsKey);
            for (Feature feature : pcmContainer.getPcm().getConcreteFeatures()) {
                metadata.setFeaturePosition(feature, metadata.getFeaturePosition(feature) + 1);
            }
            metadata.setFeaturePosition(productsKey, 0);
        }
    }

    protected void removeHoles(ImportMatrix matrix) {
        for (int row = 0; row < matrix.getNumberOfRows(); ++row) {
            for (int column = 0; column < matrix.getNumberOfColumns(); ++column) {
                ImportCell cell = (ImportCell)matrix.getCell(row, column);
                if (cell != null) continue;
                matrix.setCell(new ImportCell(), row, column);
            }
        }
    }
}

