/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import processing.mode.java.pdex.ImportStatement;
import processing.mode.java.pdex.TextTransform;
import processing.mode.java.preproc.PdePreprocessor;

public class SourceUtils {
    public static final Pattern IMPORT_REGEX = Pattern.compile("(?:^|;)\\s*(import\\s+(?:(static)\\s+)?((?:\\w+\\s*\\.)*)\\s*(\\S+)\\s*;)", 40);
    public static final Pattern IMPORT_REGEX_NO_KEYWORD = Pattern.compile("^\\s*((?:(static)\\s+)?((?:\\w+\\s*\\.)*)\\s*(\\S+))", 40);
    public static final Pattern TYPE_CONSTRUCTOR_REGEX = Pattern.compile("(?:^|\\W)(int|char|float|boolean|byte)(?:\\s*\\()", 8);
    public static final Pattern HEX_LITERAL_REGEX = Pattern.compile("(?:^|\\W)(#[A-Fa-f0-9]{6})(?:\\W|$)");
    public static final Pattern FLOATING_POINT_LITERAL_VERIFIER;
    public static final Pattern COLOR_TYPE_REGEX;
    public static final Pattern NUMBER_LITERAL_REGEX;

    public static List<ImportStatement> parseProgramImports(CharSequence source) {
        ArrayList<ImportStatement> result = new ArrayList<ImportStatement>();
        Matcher matcher = IMPORT_REGEX.matcher(source);
        while (matcher.find()) {
            ImportStatement is = ImportStatement.parse(matcher.toMatchResult());
            result.add(is);
        }
        return result;
    }

    public static List<TextTransform.Edit> parseProgramImports(CharSequence source, List<ImportStatement> outImports) {
        ArrayList<TextTransform.Edit> result = new ArrayList<TextTransform.Edit>();
        Matcher matcher = IMPORT_REGEX.matcher(source);
        while (matcher.find()) {
            ImportStatement is = ImportStatement.parse(matcher.toMatchResult());
            outImports.add(is);
            int idx = matcher.start(1);
            int len = matcher.end(1) - idx;
            result.add(TextTransform.Edit.move(idx, len, 0));
            result.add(TextTransform.Edit.insert(0, "\n"));
        }
        return result;
    }

    public static List<TextTransform.Edit> replaceTypeConstructors(CharSequence source) {
        ArrayList<TextTransform.Edit> result = new ArrayList<TextTransform.Edit>();
        Matcher matcher = TYPE_CONSTRUCTOR_REGEX.matcher(source);
        while (matcher.find()) {
            String match = matcher.group(1);
            int offset = matcher.start(1);
            int length = match.length();
            result.add(TextTransform.Edit.insert(offset, "PApplet."));
            String replace = "parse" + Character.toUpperCase(match.charAt(0)) + match.substring(1);
            result.add(TextTransform.Edit.replace(offset, length, replace));
        }
        return result;
    }

    public static List<TextTransform.Edit> replaceHexLiterals(CharSequence source) {
        ArrayList<TextTransform.Edit> result = new ArrayList<TextTransform.Edit>();
        Matcher matcher = HEX_LITERAL_REGEX.matcher(source);
        while (matcher.find()) {
            int offset = matcher.start(1);
            result.add(TextTransform.Edit.replace(offset, 1, "0xff"));
        }
        return result;
    }

    public static List<TextTransform.Edit> insertImports(List<ImportStatement> imports) {
        ArrayList<TextTransform.Edit> result = new ArrayList<TextTransform.Edit>();
        for (ImportStatement imp : imports) {
            result.add(TextTransform.Edit.insert(0, imp.getFullSourceLine() + "\n"));
        }
        return result;
    }

    public static List<TextTransform.Edit> wrapSketch(PdePreprocessor.Mode mode, String className, int sourceLength) {
        ArrayList<TextTransform.Edit> edits = new ArrayList<TextTransform.Edit>();
        StringBuilder b = new StringBuilder();
        if (mode != PdePreprocessor.Mode.JAVA) {
            b.append("\npublic class ").append(className).append(" extends PApplet {\n");
            if (mode == PdePreprocessor.Mode.STATIC) {
                b.append("public void setup() {\n");
            }
        }
        edits.add(TextTransform.Edit.insert(0, b.toString()));
        b.setLength(0);
        if (mode != PdePreprocessor.Mode.JAVA) {
            if (mode == PdePreprocessor.Mode.STATIC) {
                b.append("\n}");
            }
            b.append("\n}\n");
        }
        edits.add(TextTransform.Edit.insert(sourceLength, b.toString()));
        return edits;
    }

    public static List<TextTransform.Edit> addPublicToTopLevelMethods(CompilationUnit cu) {
        ArrayList<TextTransform.Edit> edits = new ArrayList<TextTransform.Edit>();
        for (Object node : cu.types()) {
            if (!(node instanceof TypeDeclaration)) continue;
            TypeDeclaration type = (TypeDeclaration)node;
            for (MethodDeclaration method : type.getMethods()) {
                if (!method.modifiers().isEmpty() || method.isConstructor()) continue;
                edits.add(TextTransform.Edit.insert(method.getStartPosition(), "public "));
            }
        }
        return edits;
    }

    public static List<TextTransform.Edit> replaceColorAndFixFloats(CompilationUnit cu) {
        final ArrayList<TextTransform.Edit> edits = new ArrayList<TextTransform.Edit>();
        cu.accept(new ASTVisitor(){

            public boolean visit(SimpleType node) {
                if ("color".equals(node.getName().toString())) {
                    edits.add(TextTransform.Edit.replace(node.getStartPosition(), node.getLength(), "int"));
                }
                return super.visit(node);
            }

            public boolean visit(NumberLiteral node) {
                String s = node.getToken().toLowerCase();
                if (FLOATING_POINT_LITERAL_VERIFIER.matcher(s).matches() && !s.endsWith("f") && !s.endsWith("d")) {
                    edits.add(TextTransform.Edit.insert(node.getStartPosition() + node.getLength(), "f"));
                }
                return super.visit(node);
            }
        });
        return edits;
    }

    public static List<TextTransform.Edit> replaceColorRegex(CharSequence source) {
        ArrayList<TextTransform.Edit> edits = new ArrayList<TextTransform.Edit>();
        Matcher matcher = COLOR_TYPE_REGEX.matcher(source);
        while (matcher.find()) {
            int offset = matcher.start(1);
            edits.add(TextTransform.Edit.replace(offset, 5, "int"));
        }
        return edits;
    }

    public static List<TextTransform.Edit> fixFloatsRegex(CharSequence source) {
        ArrayList<TextTransform.Edit> edits = new ArrayList<TextTransform.Edit>();
        Matcher matcher = NUMBER_LITERAL_REGEX.matcher(source);
        while (matcher.find()) {
            boolean hasSuffix;
            int offset = matcher.start();
            int end = matcher.end();
            String group = matcher.group().toLowerCase();
            boolean isFloatingPoint = group.contains(".") || group.contains("e");
            boolean bl = hasSuffix = end < source.length() && Character.toLowerCase(source.charAt(end)) != 'f' && Character.toLowerCase(source.charAt(end)) != 'd';
            if (!isFloatingPoint || hasSuffix) continue;
            edits.add(TextTransform.Edit.insert(offset, "f"));
        }
        return edits;
    }

    public static String scrubCommentsAndStrings(String p) {
        StringBuilder sb = new StringBuilder(p);
        SourceUtils.scrubCommentsAndStrings(sb);
        return sb.toString();
    }

    public static void scrubCommentsAndStrings(StringBuilder p) {
        int length = p.length();
        boolean OUT = false;
        boolean IN_BLOCK_COMMENT = true;
        int IN_EOL_COMMENT = 2;
        int IN_STRING_LITERAL = 3;
        int IN_CHAR_LITERAL = 4;
        int blockStart = -1;
        int prevState = 0;
        int state = 0;
        for (int i = 0; i <= length; ++i) {
            char ch = i < length ? p.charAt(i) : (char)'\u0000';
            char pch = i == 0 ? (char)'\u0000' : p.charAt(i - 1);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case '\'': {
                            state = 4;
                            break;
                        }
                        case '\"': {
                            state = 3;
                            break;
                        }
                        case '*': {
                            if (pch != '/') break;
                            state = 1;
                            break;
                        }
                        case '/': {
                            if (pch != '/') break;
                            state = 2;
                        }
                    }
                    break;
                }
                case 1: {
                    if (pch != '*' || ch != '/' || i - blockStart <= 1) break;
                    state = 0;
                    break;
                }
                case 2: {
                    if (ch != '\r' && ch != '\n') break;
                    state = 0;
                    break;
                }
                case 3: {
                    if ((pch == '\\' || ch != '\"') && ch != '\r' && ch != '\n') break;
                    state = 0;
                    break;
                }
                case 4: {
                    if ((pch == '\\' || ch != '\'') && ch != '\r' && ch != '\n') break;
                    state = 0;
                }
            }
            if (i == length) {
                state = 0;
            }
            if (state != prevState) {
                if (state != 0) {
                    blockStart = i + 1;
                } else {
                    int blockEnd = i;
                    if (prevState == 1 && i < length) {
                        --blockEnd;
                    }
                    for (int j = blockStart; j < blockEnd; ++j) {
                        char c = p.charAt(j);
                        if (c == '\n' || c == '\r') continue;
                        p.setCharAt(j, ' ');
                    }
                }
            }
            prevState = state;
        }
    }

    static {
        String DIGITS = "(?:[0-9]|[0-9][0-9_]*[0-9])";
        String EXPONENT_PART = "(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))";
        FLOATING_POINT_LITERAL_VERIFIER = Pattern.compile("(?:^(?:[0-9]|[0-9][0-9_]*[0-9])\\.(?:[0-9]|[0-9][0-9_]*[0-9])?(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))?[fFdD]?$)|(?:^\\.(?:[0-9]|[0-9][0-9_]*[0-9])(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))?[fFdD]?$)|(?:^(?:[0-9]|[0-9][0-9_]*[0-9])(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))[fFdD]?$)|(?:^(?:[0-9]|[0-9][0-9_]*[0-9])(?:[eE][+-]?(?:[0-9]|[0-9][0-9_]*[0-9]))?[fFdD]$)");
        COLOR_TYPE_REGEX = Pattern.compile("(?:^|^\\p{javaJavaIdentifierPart})(color)\\s(?!\\s*\\()", 264);
        NUMBER_LITERAL_REGEX = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?");
    }
}

