/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import processing.core.PApplet;

public class TextTransform {
    private static final Comparator<Edit> INPUT_OFFSET_COMP = (o1, o2) -> Integer.compare(((Edit)o1).fromOffset, ((Edit)o2).fromOffset);
    private static final Comparator<Edit> OUTPUT_OFFSET_COMP = (o1, o2) -> Integer.compare(((Edit)o1).toOffset, ((Edit)o2).toOffset);
    private CharSequence input;
    private List<Edit> edits = new ArrayList<Edit>();
    private List<Edit> inMap = new ArrayList<Edit>();
    private List<Edit> outMap = new ArrayList<Edit>();
    private boolean built;
    private int builtForLength;

    TextTransform(CharSequence input) {
        this.input = input;
    }

    public void add(Edit edit) {
        this.edits.add(edit);
        this.built = false;
    }

    public void addAll(Collection<Edit> edits) {
        this.edits.addAll(edits);
        this.built = false;
    }

    public String apply() {
        int inLength = this.input.length();
        StringBuilder output = new StringBuilder(inLength);
        this.buildIfNeeded(inLength);
        this.outMap.stream().filter(outEdit -> ((Edit)outEdit).toLength > 0).forEach(outEdit -> {
            if (((Edit)outEdit).outputText != null) {
                output.append(((Edit)outEdit).outputText);
            } else {
                output.append(this.input, ((Edit)outEdit).fromOffset, ((Edit)outEdit).fromOffset + ((Edit)outEdit).fromLength);
            }
        });
        return output.toString();
    }

    public OffsetMapper getMapper() {
        int inLength = this.input.length();
        this.buildIfNeeded(inLength);
        return new SimpleOffsetMapper(this.inMap, this.outMap);
    }

    private void buildIfNeeded(int inLength) {
        if (this.built && inLength == this.builtForLength) {
            return;
        }
        List inEdits = this.edits.stream().map(Edit::new).collect(Collectors.toList());
        ArrayList outEdits = new ArrayList(inEdits);
        Collections.sort(inEdits, INPUT_OFFSET_COMP);
        Collections.sort(outEdits, OUTPUT_OFFSET_COMP);
        ListIterator inIt = inEdits.listIterator();
        Edit inEdit = inIt.hasNext() ? (Edit)inIt.next() : null;
        int inEditOff = inEdit == null ? inLength : inEdit.fromOffset;
        ListIterator outIt = outEdits.listIterator();
        Edit outEdit = outIt.hasNext() ? (Edit)outIt.next() : null;
        int outEditOff = outEdit == null ? inLength : outEdit.toOffset;
        int inOffset = 0;
        int outOffset = 0;
        this.inMap.clear();
        this.outMap.clear();
        while (inOffset < inLength || inEdit != null || outEdit != null) {
            int nextEditOffset = Math.min(inEditOff, outEditOff);
            int length = nextEditOffset - inOffset;
            if (length > 0) {
                Edit ch = Edit.move(inOffset, length, outOffset);
                this.inMap.add(ch);
                this.outMap.add(ch);
            }
            outOffset += nextEditOffset - inOffset;
            inOffset = nextEditOffset;
            while (inEdit != null && inOffset >= inEditOff) {
                inOffset += inEdit.fromLength;
                if (inEdit.fromLength > 0) {
                    this.inMap.add(inEdit);
                }
                inEdit = inIt.hasNext() ? (Edit)inIt.next() : null;
                int n = inEditOff = inEdit != null ? inEdit.fromOffset : inLength;
            }
            while (outEdit != null && inOffset >= outEditOff) {
                outEdit.toOffset = outOffset;
                if (outEdit.toLength > 0) {
                    this.outMap.add(outEdit);
                }
                outOffset += outEdit.toLength;
                outEdit = outIt.hasNext() ? (Edit)outIt.next() : null;
                int n = outEditOff = outEdit != null ? outEdit.toOffset : inLength;
            }
        }
        this.built = true;
        this.builtForLength = inLength;
    }

    public String toString() {
        return "SourceMapping{edits=" + this.edits + '}';
    }

    private static class CompositeOffsetMapper
    implements OffsetMapper {
        private List<OffsetMapper> mappers = new ArrayList<OffsetMapper>();

        private CompositeOffsetMapper() {
        }

        public static CompositeOffsetMapper of(OffsetMapper ... inMappers) {
            CompositeOffsetMapper composite = new CompositeOffsetMapper();
            OffsetMapper[] offsetMapperArray = inMappers;
            int n = inMappers.length;
            int n2 = 0;
            while (n2 < n) {
                OffsetMapper mapper = offsetMapperArray[n2];
                if (mapper instanceof CompositeOffsetMapper) {
                    composite.mappers.addAll(((CompositeOffsetMapper)mapper).mappers);
                } else {
                    composite.mappers.add(mapper);
                }
                ++n2;
            }
            return composite;
        }

        @Override
        public int getInputOffset(int outputOffset) {
            int i = this.mappers.size() - 1;
            while (i >= 0) {
                outputOffset = this.mappers.get(i).getInputOffset(outputOffset);
                --i;
            }
            return outputOffset;
        }

        @Override
        public int getOutputOffset(int inputOffset) {
            for (OffsetMapper mapper : this.mappers) {
                inputOffset = mapper.getOutputOffset(inputOffset);
            }
            return inputOffset;
        }

        @Override
        public OffsetMapper thenMapping(OffsetMapper mapper) {
            return CompositeOffsetMapper.of(this, mapper);
        }
    }

    protected static class Edit {
        private final int fromOffset;
        private final int fromLength;
        private int toOffset;
        private final int toLength;
        private final String outputText;

        static Edit insert(int offset, String text) {
            return new Edit(offset, 0, offset, text.length(), text);
        }

        static Edit replace(int offset, int length, String text) {
            return new Edit(offset, length, offset, text.length(), text);
        }

        static Edit move(int fromOffset, int length, int toOffset) {
            Edit result = new Edit(fromOffset, length, toOffset, length, null);
            result.toOffset = toOffset;
            return result;
        }

        static Edit delete(int position, int length) {
            return new Edit(position, length, position, 0, null);
        }

        Edit(Edit edit) {
            this.fromOffset = edit.fromOffset;
            this.fromLength = edit.fromLength;
            this.toOffset = edit.toOffset;
            this.toLength = edit.toLength;
            this.outputText = edit.outputText;
        }

        Edit(int fromOffset, int fromLength, int toOffset, int toLength, String text) {
            this.fromOffset = fromOffset;
            this.fromLength = fromLength;
            this.toOffset = toOffset;
            this.toLength = toLength;
            this.outputText = text;
        }

        public String toString() {
            return "Edit{from=" + this.fromOffset + ":" + this.fromLength + ", to=" + this.toOffset + ":" + this.toLength + (this.outputText != null ? ", text='" + this.outputText + '\'' : "") + '}';
        }
    }

    protected static interface OffsetMapper {
        public static final OffsetMapper EMPTY_MAPPER = CompositeOffsetMapper.of(new OffsetMapper[0]);

        public int getInputOffset(int var1);

        public int getOutputOffset(int var1);

        public OffsetMapper thenMapping(OffsetMapper var1);
    }

    private static class SimpleOffsetMapper
    implements OffsetMapper {
        private List<Edit> inMap = new ArrayList<Edit>();
        private List<Edit> outMap = new ArrayList<Edit>();
        private int outputOffsetOfInputStart;
        private int inputOffsetOfOutputStart;

        private SimpleOffsetMapper(List<Edit> inMap, List<Edit> outMap) {
            this.inMap.addAll(inMap);
            this.outMap.addAll(outMap);
            Edit inStart = null;
            Iterator<Edit> iterator = this.inMap.iterator();
            while (iterator.hasNext()) {
                Edit in;
                inStart = in = iterator.next();
                if (in.fromLength > 0) break;
            }
            this.outputOffsetOfInputStart = inStart == null ? 0 : inStart.toOffset;
            Edit outStart = null;
            Iterator<Edit> iterator2 = this.inMap.iterator();
            while (iterator2.hasNext()) {
                Edit out;
                outStart = out = iterator2.next();
                if (out.toLength > 0) break;
            }
            this.inputOffsetOfOutputStart = outStart == null ? 0 : outStart.fromOffset;
        }

        @Override
        public int getInputOffset(int outputOffset) {
            if (outputOffset < this.outputOffsetOfInputStart) {
                return -1;
            }
            Edit searchKey = new Edit(0, 0, outputOffset, Integer.MAX_VALUE, null);
            int i = Collections.binarySearch(this.outMap, searchKey, OUTPUT_OFFSET_COMP);
            if (i < 0) {
                i = -(i + 1);
                --i;
            }
            i = PApplet.constrain((int)i, (int)0, (int)(this.outMap.size() - 1));
            Edit edit = this.outMap.get(i);
            int diff = outputOffset - edit.toOffset;
            return edit.fromOffset + Math.min(diff, Math.max(0, edit.fromLength - 1));
        }

        @Override
        public int getOutputOffset(int inputOffset) {
            if (inputOffset < this.inputOffsetOfOutputStart) {
                return -1;
            }
            Edit searchKey = new Edit(inputOffset, Integer.MAX_VALUE, 0, 0, null);
            int i = Collections.binarySearch(this.inMap, searchKey, INPUT_OFFSET_COMP);
            if (i < 0) {
                i = -(i + 1);
                --i;
            }
            i = PApplet.constrain((int)i, (int)0, (int)(this.inMap.size() - 1));
            Edit edit = this.inMap.get(i);
            int diff = inputOffset - edit.fromOffset;
            return edit.toOffset + Math.min(diff, Math.max(0, edit.toLength - 1));
        }

        @Override
        public OffsetMapper thenMapping(OffsetMapper mapper) {
            return CompositeOffsetMapper.of(this, mapper);
        }
    }
}

