/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import antlr.CommonAST;
import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import antlr.RecognitionException;
import antlr.TokenStreamCopyingHiddenTokenFilter;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.core.PApplet;
import processing.data.StringList;
import processing.mode.java.preproc.PreprocessorResult;
import processing.mode.java.preproc.SurfaceInfo;
import processing.mode.java.preproc.TokenUtil;

public class PdePreprocessor {
    protected static final String UNICODE_ESCAPES = "0123456789abcdefABCDEF";
    private static final int ROOT_ID = 0;
    protected final String indent;
    private final String name;
    private TokenStreamCopyingHiddenTokenFilter filter;
    private String advClassName = "";
    protected Mode mode;
    Set<String> foundMethods;
    SurfaceInfo sizeInfo;
    private static final Pattern VOID_SETUP_REGEX = Pattern.compile("(?:^|\\s|;)void\\s+setup\\s*\\(", 8);
    private static final Pattern PUBLIC_CLASS = Pattern.compile("(^|;)\\s*public\\s+class\\s+\\S+\\s+extends\\s+PApplet", 8);
    private static final Pattern FUNCTION_DECL = Pattern.compile("(^|;)\\s*((public|private|protected|final|static)\\s+)*(void|int|float|double|String|char|byte|boolean)(\\s*\\[\\s*\\])?\\s+[a-zA-Z0-9]+\\s*\\(", 8);
    private static final Pattern CLOSING_BRACE = Pattern.compile("\\}");
    protected static LinkedHashMap<String, Pattern> matchPatterns = new LinkedHashMap<String, Pattern>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
            return this.size() == 10;
        }
    };

    public PdePreprocessor(String sketchName) {
        this(sketchName, Preferences.getInteger((String)"editor.tabs.size"));
    }

    public PdePreprocessor(String sketchName, int tabSize) {
        this.name = sketchName;
        char[] indentChars = new char[tabSize];
        Arrays.fill(indentChars, ' ');
        this.indent = new String(indentChars);
    }

    public SurfaceInfo initSketchSize(String code, boolean sizeWarning) throws SketchException {
        this.sizeInfo = PdePreprocessor.parseSketchSize(code, sizeWarning);
        return this.sizeInfo;
    }

    private static StringList breakCommas(String contents) {
        StringList outgoing = new StringList();
        boolean insideQuote = false;
        StringBuilder current = new StringBuilder();
        char[] chars = contents.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (insideQuote) {
                current.append(c);
                if (c != '\"') continue;
                insideQuote = false;
                continue;
            }
            if (c == ',') {
                if (current.length() == 0) continue;
                outgoing.append(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
            if (c != '\"') continue;
            insideQuote = true;
        }
        if (current.length() != 0) {
            outgoing.append(current.toString());
        }
        return outgoing;
    }

    public static SurfaceInfo parseSketchSize(String code, boolean fussy) throws SketchException {
        String[] pixelDensityContents;
        String[] noContents;
        String uncommented = PdePreprocessor.scrubComments(code);
        Mode mode = PdePreprocessor.parseMode(uncommented);
        String searchArea = null;
        switch (mode) {
            case JAVA: {
                searchArea = null;
                break;
            }
            case ACTIVE: {
                int start;
                MatchResult setupMatch = PdePreprocessor.findInCurrentScope(VOID_SETUP_REGEX, uncommented);
                if (setupMatch == null || (start = uncommented.indexOf("{", setupMatch.end())) < 0) break;
                MatchResult match = PdePreprocessor.findInCurrentScope(CLOSING_BRACE, uncommented, start);
                if (match != null) {
                    searchArea = uncommented.substring(start + 1, match.end() - 1);
                    break;
                }
                throw new SketchException("Found a { that's missing a matching }", false);
            }
            case STATIC: {
                searchArea = uncommented;
            }
        }
        if (searchArea == null) {
            return new SurfaceInfo();
        }
        StringList extraStatements = new StringList();
        String[] smoothContents = PdePreprocessor.matchMethod("smooth", searchArea);
        if (smoothContents != null) {
            extraStatements.append(smoothContents[0]);
        }
        if ((noContents = PdePreprocessor.matchMethod("noSmooth", searchArea)) != null) {
            if (extraStatements.size() != 0) {
                throw new SketchException("smooth() and noSmooth() cannot be used in the same sketch");
            }
            extraStatements.append(noContents[0]);
        }
        if ((pixelDensityContents = PdePreprocessor.matchMethod("pixelDensity", searchArea)) != null) {
            extraStatements.append(pixelDensityContents[0]);
        } else {
            pixelDensityContents = PdePreprocessor.matchDensityMess(searchArea);
            if (pixelDensityContents != null) {
                extraStatements.append(pixelDensityContents[0]);
            }
        }
        String[] sizeContents = PdePreprocessor.matchMethod("size", searchArea);
        String[] fullContents = PdePreprocessor.matchMethod("fullScreen", searchArea);
        if (sizeContents != null && fullContents != null) {
            throw new SketchException("size() and fullScreen() cannot be used in the same sketch", false);
        }
        if (sizeContents != null) {
            StringList args = PdePreprocessor.breakCommas(sizeContents[1]);
            SurfaceInfo info = new SurfaceInfo();
            info.addStatement(sizeContents[0]);
            info.width = args.get(0).trim();
            info.height = args.get(1).trim();
            info.renderer = args.size() >= 3 ? args.get(2).trim() : null;
            String string = info.path = args.size() >= 4 ? args.get(3).trim() : null;
            if (info.hasOldSyntax()) {
                throw new SketchException("Please update your code to continue.", false);
            }
            if (info.hasBadSize() && fussy) {
                String message = "The size of this sketch could not be determined from your code.\nUse only numbers (not variables) for the size() command.\nRead the size() reference for more details.";
                Messages.showWarning((String)"Could not find sketch size", (String)"The size of this sketch could not be determined from your code.\nUse only numbers (not variables) for the size() command.\nRead the size() reference for more details.", null);
                throw new SketchException("Please fix the size() line to continue.", false);
            }
            info.addStatements(extraStatements);
            info.checkEmpty();
            return info;
        }
        if (fullContents != null) {
            SurfaceInfo info = new SurfaceInfo();
            info.addStatement(fullContents[0]);
            StringList args = PdePreprocessor.breakCommas(fullContents[1]);
            if (args.size() > 0) {
                String args0 = args.get(0).trim();
                if (args.size() == 1) {
                    if (args0.equals("SPAN") || PApplet.parseInt((String)args0, (int)-1) != -1) {
                        info.display = args0;
                    } else {
                        info.renderer = args0;
                    }
                } else if (args.size() == 2) {
                    info.renderer = args0;
                    info.display = args.get(1).trim();
                } else {
                    throw new SketchException("That's too many parameters for fullScreen()");
                }
            }
            info.width = "displayWidth";
            info.height = "displayHeight";
            info.addStatements(extraStatements);
            info.checkEmpty();
            return info;
        }
        if (extraStatements.size() != 0) {
            SurfaceInfo info = new SurfaceInfo();
            info.addStatements(extraStatements);
            return info;
        }
        return new SurfaceInfo();
    }

    public static Mode parseMode(CharSequence code) {
        if (PdePreprocessor.findInCurrentScope(FUNCTION_DECL, code) != null) {
            return Mode.ACTIVE;
        }
        if (PdePreprocessor.findInCurrentScope(PUBLIC_CLASS, code) != null) {
            return Mode.JAVA;
        }
        return Mode.STATIC;
    }

    protected static MatchResult findInCurrentScope(Pattern pattern, CharSequence code) {
        return PdePreprocessor.findInScope(pattern, code, 0, code.length(), 0, 0);
    }

    protected static MatchResult findInCurrentScope(Pattern pattern, CharSequence code, int start) {
        return PdePreprocessor.findInScope(pattern, code, start, code.length(), 0, 0);
    }

    protected static MatchResult findInScope(Pattern pattern, CharSequence code, int start, int stop, int minTargetScopeDepth, int maxTargetScopeDepth) {
        if (minTargetScopeDepth > maxTargetScopeDepth) {
            int temp = minTargetScopeDepth;
            minTargetScopeDepth = maxTargetScopeDepth;
            maxTargetScopeDepth = temp;
        }
        Matcher m = pattern.matcher(code);
        m.region(start, stop);
        int depth = 0;
        int position = start;
        int minScopeDepth = PApplet.min((int)depth, (int)minTargetScopeDepth);
        while (m.find()) {
            int newPosition = m.end();
            int depthDiff = PdePreprocessor.scopeDepthDiff(code, position, newPosition);
            if (depthDiff == Integer.MAX_VALUE) continue;
            if ((depth += depthDiff) < minScopeDepth) break;
            if (depth >= minTargetScopeDepth && depth <= maxTargetScopeDepth) {
                return m.toMatchResult();
            }
            position = newPosition;
        }
        return null;
    }

    protected static int scopeDepthDiff(CharSequence code, int start, int stop) {
        boolean insideString = false;
        boolean insideChar = false;
        boolean escapedChar = false;
        int depth = 0;
        for (int i = start; i < stop; ++i) {
            if (!escapedChar) {
                char ch = code.charAt(i);
                switch (ch) {
                    case '\\': {
                        escapedChar = true;
                        break;
                    }
                    case '{': {
                        if (insideChar || insideString) break;
                        ++depth;
                        break;
                    }
                    case '}': {
                        if (insideChar || insideString) break;
                        --depth;
                        break;
                    }
                    case '\"': {
                        if (insideChar) break;
                        insideString = !insideString;
                        break;
                    }
                    case '\'': {
                        if (insideString) break;
                        insideChar = !insideChar;
                    }
                }
                continue;
            }
            escapedChar = false;
        }
        if (insideChar || insideString || escapedChar) {
            return Integer.MAX_VALUE;
        }
        return depth;
    }

    protected static String[] matchMethod(String methodName, String searchArea) {
        MatchResult match;
        String left = "(?:^|\\s|;)";
        String right = "\\s*\\(([^\\)]*)\\)\\s*;";
        String regexp = "(?:^|\\s|;)" + methodName + "\\s*\\(([^\\)]*)\\)\\s*;";
        Pattern p = matchPatterns.get(regexp);
        if (p == null) {
            p = Pattern.compile(regexp, 40);
            matchPatterns.put(regexp, p);
        }
        if ((match = PdePreprocessor.findInCurrentScope(p, searchArea)) != null) {
            int count = match.groupCount() + 1;
            String[] groups = new String[count];
            for (int i = 0; i < count; ++i) {
                groups[i] = match.group(i);
            }
            return groups;
        }
        return null;
    }

    protected static String[] matchDensityMess(String searchArea) {
        String regexp = "(?:^|\\s|;)pixelDensity\\s*\\(\\s*displayDensity\\s*\\([^\\)]*\\)\\s*\\)\\s*\\;";
        return PApplet.match((String)searchArea, (String)"(?:^|\\s|;)pixelDensity\\s*\\(\\s*displayDensity\\s*\\([^\\)]*\\)\\s*\\)\\s*\\;");
    }

    public static String scrubComments(String what) {
        char[] p = what.toCharArray();
        boolean insideQuote = false;
        int index = 0;
        while (index < p.length) {
            if (!insideQuote && p[index] == '/' && index < p.length - 1 && p[index + 1] == '/') {
                p[index++] = 32;
                p[index++] = 32;
                while (index < p.length && p[index] != '\n') {
                    p[index++] = 32;
                }
                continue;
            }
            if (!insideQuote && p[index] == '/' && index < p.length - 1 && p[index + 1] == '*') {
                p[index++] = 32;
                p[index++] = 32;
                boolean endOfRainbow = false;
                while (index < p.length - 1) {
                    if (p[index] == '*' && p[index + 1] == '/') {
                        p[index++] = 32;
                        p[index++] = 32;
                        endOfRainbow = true;
                        break;
                    }
                    p[index++] = 32;
                }
                if (endOfRainbow) continue;
                throw new RuntimeException("Missing the */ from the end of a /* comment */");
            }
            if (p[index] == '\"') {
                insideQuote = !insideQuote;
                ++index;
                continue;
            }
            if (insideQuote && p[index] == '\\') {
                index += 2;
                continue;
            }
            ++index;
        }
        return new String(p);
    }

    public void addMethod(String methodName) {
        this.foundMethods.add(methodName);
    }

    public boolean hasMethod(String methodName) {
        return this.foundMethods.contains(methodName);
    }

    public void setAdvClassName(String advClassName) {
        this.advClassName = advClassName;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    CommonHiddenStreamToken getHiddenAfter(CommonHiddenStreamToken t) {
        return this.filter.getHiddenAfter(t);
    }

    CommonHiddenStreamToken getInitialHiddenToken() {
        return this.filter.getInitialHiddenToken();
    }

    private static int countNewlines(String s) {
        int count = 0;
        int pos = s.indexOf(10, 0);
        while (pos >= 0) {
            ++count;
            pos = s.indexOf(10, pos + 1);
        }
        return count;
    }

    private static void checkForUnterminatedMultilineComment(String program) throws SketchException {
        int length = program.length();
        for (int i = 0; i < length; ++i) {
            boolean terminated;
            if (program.charAt(i) == '/' && i < length - 1 && program.charAt(i + 1) == '/') {
                i += 2;
                while (i < length && program.charAt(i) != '\n') {
                    ++i;
                }
                continue;
            }
            if (program.charAt(i) == '/' && i < length - 1 && program.charAt(i + 1) == '*') {
                int startOfComment = i;
                i += 2;
                terminated = false;
                while (i < length - 1) {
                    if (program.charAt(i) == '*' && program.charAt(i + 1) == '/') {
                        ++i;
                        terminated = true;
                        break;
                    }
                    ++i;
                }
                if (terminated) continue;
                throw new SketchException("Unclosed /* comment */", 0, PdePreprocessor.countNewlines(program.substring(0, startOfComment)));
            }
            if (program.charAt(i) == '\"') {
                int stringStart = i++;
                terminated = false;
                while (i < length) {
                    char c = program.charAt(i);
                    if (c == '\"') {
                        terminated = true;
                        break;
                    }
                    if (c == '\\') {
                        if (i == length - 1) break;
                        ++i;
                    } else if (c == '\n') break;
                    ++i;
                }
                if (terminated) continue;
                throw new SketchException("Unterminated string constant", 0, PdePreprocessor.countNewlines(program.substring(0, stringStart)));
            }
            if (program.charAt(i) != '\'') continue;
            if (++i >= length) {
                throw new SketchException("Unterminated character constant (after initial quote)", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
            }
            boolean escaped = false;
            if (program.charAt(i) == '\\') {
                ++i;
                escaped = true;
            }
            if (i >= length) {
                throw new SketchException("Unterminated character constant (after backslash)", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
            }
            if (escaped && program.charAt(i) == 'u') {
                ++i;
                for (int j = 0; j < 4; ++j) {
                    if (UNICODE_ESCAPES.indexOf(program.charAt(i)) == -1) {
                        throw new SketchException("Bad or unfinished \\uXXXX sequence (malformed Unicode character constant)", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
                    }
                    ++i;
                }
            } else {
                ++i;
            }
            if (i >= length) {
                throw new SketchException("Unterminated character constant", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
            }
            if (program.charAt(i) == '\'') continue;
            throw new SketchException("Badly formed character constant (expecting quote, got " + program.charAt(i) + ")", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
        }
    }

    public PreprocessorResult write(Writer out, String program) throws SketchException, RecognitionException, TokenStreamException {
        return this.write(out, program, null);
    }

    public PreprocessorResult write(Writer out, String program, StringList codeFolderPackages) throws SketchException, RecognitionException, TokenStreamException {
        ArrayList<String> programImports = new ArrayList<String>();
        ArrayList<String> codeFolderImports = new ArrayList<String>();
        this.foundMethods = new HashSet<String>();
        if (!program.endsWith("\n")) {
            program = program + "\n";
        }
        PdePreprocessor.checkForUnterminatedMultilineComment(program);
        if (Preferences.getBoolean((String)"preproc.substitute_unicode")) {
            program = PdePreprocessor.substituteUnicode(program);
        }
        String importRegexp = "((?:^|;|\\})\\s*)(import\\s+)((?:static\\s+)?\\S+)(\\s*;)";
        Pattern importPattern = Pattern.compile("((?:^|;|\\})\\s*)(import\\s+)((?:static\\s+)?\\S+)(\\s*;)");
        String scrubbed = PdePreprocessor.scrubComments(program);
        Matcher m = null;
        int offset = 0;
        boolean found = false;
        do {
            if (!(found = (m = importPattern.matcher(scrubbed)).find(offset))) continue;
            String before = m.group(1);
            String piece = m.group(2) + m.group(3) + m.group(4);
            if (!this.ignoreImport(m.group(3))) {
                programImports.add(m.group(3));
            }
            int start = m.start() + before.length();
            int stop = start + piece.length();
            program = program.substring(0, start) + program.substring(stop);
            scrubbed = scrubbed.substring(0, start) + scrubbed.substring(stop);
            offset = m.start();
        } while (found);
        if (codeFolderPackages != null) {
            for (String item : codeFolderPackages) {
                codeFolderImports.add(item + ".*");
            }
        }
        PrintWriter stream = new PrintWriter(out);
        int headerOffset = this.writeImports(stream, programImports, codeFolderImports);
        return new PreprocessorResult(this.mode, headerOffset + 2, this.write(program, stream), programImports);
    }

    static String substituteUnicode(String program) {
        char[] p = program.toCharArray();
        int unicodeCount = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] <= '\u007f') continue;
            ++unicodeCount;
        }
        if (unicodeCount == 0) {
            return program;
        }
        int index = 0;
        char[] p2 = new char[p.length + unicodeCount * 5];
        for (int i = 0; i < p.length; ++i) {
            if (p[i] < '\u0080') {
                p2[index++] = p[i];
                continue;
            }
            if (p[i] == '\u00a0') {
                p2[index++] = 32;
                continue;
            }
            char c = p[i];
            p2[index++] = 92;
            p2[index++] = 117;
            char[] str = Integer.toHexString(c).toCharArray();
            for (int m = 0; m < 4 - str.length; ++m) {
                p2[index++] = 48;
            }
            System.arraycopy(str, 0, p2, index, str.length);
            index += str.length;
        }
        return new String(p2, 0, index);
    }

    private String write(String program, PrintWriter stream) throws SketchException, RecognitionException, TokenStreamException {
        String uncomment = PdePreprocessor.scrubComments(program);
        throw new RuntimeException("Uncompilable source code - cannot find symbol\n  symbol:   class PdeRecognizer\n  location: class processing.mode.java.preproc.PdePreprocessor");
    }

    private PdeRecognizer createParser(String program) {
        throw new RuntimeException("Uncompilable source code - cannot find symbol\n  symbol:   class PdeRecognizer\n  location: class processing.mode.java.preproc.PdePreprocessor");
    }

    private void makeSimpleMethodsPublic(AST node) {
        throw new RuntimeException("Uncompilable source code - cannot find symbol\n  symbol:   variable PdeTokenTypes\n  location: class processing.mode.java.preproc.PdePreprocessor");
    }

    protected void writeParseTree(String filename, AST ast) {
        try {
            PrintStream stream = new PrintStream(new FileOutputStream(filename));
            stream.println("<?xml version=\"1.0\"?>");
            stream.println("<document>");
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            if (ast != null) {
                ((CommonAST)ast).xmlSerialize((Writer)writer);
            }
            writer.flush();
            stream.println("</document>");
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int writeImports(PrintWriter out, List<String> programImports, List<String> codeFolderImports) {
        int count = this.writeImportList(out, this.getCoreImports());
        count += this.writeImportList(out, programImports);
        count += this.writeImportList(out, codeFolderImports);
        return count += this.writeImportList(out, this.getDefaultImports());
    }

    protected int writeImportList(PrintWriter out, List<String> imports) {
        return this.writeImportList(out, imports.toArray(new String[0]));
    }

    protected int writeImportList(PrintWriter out, String[] imports) {
        int count = 0;
        if (imports != null && imports.length != 0) {
            for (String item : imports) {
                out.println("import " + item + "; ");
                ++count;
            }
            out.println();
            ++count;
        }
        return count;
    }

    protected void writeDeclaration(PrintWriter out, String className) {
        if (this.mode == Mode.JAVA) {
            out.println();
            out.println();
        } else if (this.mode == Mode.ACTIVE) {
            out.println("public class " + className + " extends PApplet {");
            out.println();
        } else if (this.mode == Mode.STATIC) {
            out.println("public class " + className + " extends PApplet {");
            out.println(this.indent + "public void setup() {");
        }
    }

    protected void writeFooter(PrintWriter out, String className) {
        if (this.mode == Mode.STATIC) {
            out.println(this.indent + this.indent + "noLoop();");
            out.println(this.indent + "}");
            out.println();
        }
        if (this.mode == Mode.STATIC || this.mode == Mode.ACTIVE) {
            if (!this.hasMethod("settings") && this.sizeInfo.hasSettings()) {
                out.println(this.indent + "public void settings() { " + this.sizeInfo.getSettings() + " }");
            }
            if (!this.hasMethod("main")) {
                out.println(this.indent + "static public void main(String[] passedArgs) {");
                out.print(this.indent + this.indent + "String[] appletArgs = new String[] { ");
                if (Preferences.getBoolean((String)"export.application.present")) {
                    out.print("\"--present\", ");
                    String farbe = Preferences.get((String)"run.present.bgcolor");
                    out.print("\"--window-color=" + farbe + "\", ");
                    if (Preferences.getBoolean((String)"export.application.stop")) {
                        farbe = Preferences.get((String)"run.present.stop.color");
                        out.print("\"--stop-color=" + farbe + "\", ");
                    } else {
                        out.print("\"--hide-stop\", ");
                    }
                }
                out.println("\"" + className + "\" };");
                out.println(this.indent + this.indent + "if (passedArgs != null) {");
                out.println(this.indent + this.indent + "  PApplet.main(concat(appletArgs, passedArgs));");
                out.println(this.indent + this.indent + "} else {");
                out.println(this.indent + this.indent + "  PApplet.main(appletArgs);");
                out.println(this.indent + this.indent + "}");
                out.println(this.indent + "}");
            }
            out.println("}");
        }
    }

    public String[] getCoreImports() {
        return new String[]{"processing.core.*", "processing.data.*", "processing.event.*", "processing.opengl.*"};
    }

    public String[] getDefaultImports() {
        return new String[]{"java.util.HashMap", "java.util.ArrayList", "java.io.File", "java.io.BufferedReader", "java.io.PrintWriter", "java.io.InputStream", "java.io.OutputStream", "java.io.IOException"};
    }

    public boolean ignoreImport(String pkg) {
        return false;
    }

    String getFirstClassName(AST ast) {
        String t = this.advClassName;
        this.advClassName = "";
        return t;
    }

    public void debugAST(AST ast, boolean includeHidden) {
        System.err.println("------------------");
        this.debugAST(ast, includeHidden, 0);
    }

    private void debugAST(AST ast, boolean includeHidden, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.err.print("    ");
        }
        if (includeHidden) {
            System.err.print(this.debugHiddenBefore(ast));
        }
        if (ast.getType() > 0 && !ast.getText().equals(TokenUtil.nameOf(ast))) {
            System.err.print(TokenUtil.nameOf(ast) + "/");
        }
        System.err.print(ast.getText().replace("\n", "\\n"));
        if (includeHidden) {
            System.err.print(this.debugHiddenAfter(ast));
        }
        System.err.println();
        for (AST kid = ast.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            this.debugAST(kid, includeHidden, indent + 1);
        }
    }

    private String debugHiddenAfter(AST ast) {
        return ast instanceof CommonASTWithHiddenTokens ? this.debugHiddenTokens(((CommonASTWithHiddenTokens)ast).getHiddenAfter()) : "";
    }

    private String debugHiddenBefore(AST ast) {
        if (!(ast instanceof CommonASTWithHiddenTokens)) {
            return "";
        }
        CommonHiddenStreamToken parent = ((CommonASTWithHiddenTokens)ast).getHiddenBefore();
        if (parent == null) {
            return "";
        }
        CommonHiddenStreamToken child = null;
        while ((parent = (child = parent).getHiddenBefore()) != null) {
        }
        return this.debugHiddenTokens(child);
    }

    private String debugHiddenTokens(CommonHiddenStreamToken t) {
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            if (sb.length() == 0) {
                sb.append("[");
            }
            sb.append(t.getText().replace("\n", "\\n"));
            t = this.filter.getHiddenAfter(t);
        }
        if (sb.length() > 0) {
            sb.append("]");
        }
        return sb.toString();
    }

    public static enum Mode {
        STATIC,
        ACTIVE,
        JAVA;

    }
}

