/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.PyString;
import org.python.core.PySystemState;

public class SyspathArchive
extends PyString {
    private ZipFile zipFile;

    public SyspathArchive(String string) throws IOException {
        super(string);
        string = SyspathArchive.getArchiveName(string);
        if (string == null) {
            throw new IOException("path '" + string + "' not an archive");
        }
        this.zipFile = new ZipFile(new File(string));
        if (PySystemState.isPackageCacheEnabled()) {
            PySystemState.packageManager.addJar(string, true);
        }
    }

    SyspathArchive(ZipFile zipFile, String string) {
        super(string);
        this.zipFile = zipFile;
    }

    static String getArchiveName(String string) {
        String string2 = string.toLowerCase();
        int n = string2.indexOf(".zip");
        if (n < 0) {
            n = string2.indexOf(".jar");
        }
        if (n < 0) {
            return null;
        }
        if (n == string.length() - 4) {
            return string;
        }
        char c = string.charAt(n + 4);
        if (c == File.separatorChar || c == '/') {
            return string.substring(0, n + 4);
        }
        return null;
    }

    public SyspathArchive makeSubfolder(String string) {
        return new SyspathArchive(this.zipFile, super.toString() + "/" + string);
    }

    private String makeEntry(String string) {
        String string2 = super.toString();
        String string3 = SyspathArchive.getArchiveName(super.toString());
        if (string2.length() == string3.length()) {
            return string;
        }
        return string2.substring(string3.length() + 1) + "/" + string;
    }

    ZipEntry getEntry(String string) {
        return this.zipFile.getEntry(this.makeEntry(string));
    }

    InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        int n;
        int n2;
        InputStream inputStream = this.zipFile.getInputStream(zipEntry);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n2 = (int)zipEntry.getSize(); n2 > 0; n2 -= n) {
            n = inputStream.read(byArray, n3, byArray.length - n3);
            if (n < 0) {
                return null;
            }
            n3 += n;
        }
        inputStream.close();
        return new ByteArrayInputStream(byArray);
    }
}

