/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.gateway.example;

import org.rxjava.api.example.inner.InnerLoginInfoApi;
import org.rxjava.apikit.client.ClientAdapter;
import org.rxjava.common.core.api.ReactiveHttpClientAdapter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.reactive.function.client.WebClient;

@SpringBootApplication
public class RxGatewayExampleApplication {
    public static void main(String[] args) {
        SpringApplication.run(RxGatewayExampleApplication.class, (String[])args);
    }

    @Bean
    CommandLineRunner initDatabase() {
        return args -> {};
    }

    @Bean
    public RouteLocator customRouteLocator(RouteLocatorBuilder builder) {
        return builder.routes().route(r -> r.path(new String[]{"/user/**"}).filters(p -> p.stripPrefix(1)).uri("http://localhost:8081")).build();
    }

    @Bean
    @Qualifier(value="userClientAdapter")
    public ClientAdapter userClientAdapter(@Qualifier(value="webFluxConversionService") ConversionService conversionService, WebClient.Builder webClientBuilder) {
        return ReactiveHttpClientAdapter.build((ConversionService)conversionService, (WebClient.Builder)webClientBuilder, (String)"localhost:8081");
    }

    @Bean
    public InnerLoginInfoApi innerLoginInfoApi(@Qualifier(value="userClientAdapter") ClientAdapter clientAdapter) {
        InnerLoginInfoApi api = new InnerLoginInfoApi();
        api.setclientAdapter(clientAdapter);
        return api;
    }
}

