/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.security.example.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.rxjava.common.core.exception.LoginRuntimeException;
import org.rxjava.security.example.config.JwtAuthenticationToken;
import org.rxjava.security.example.entity.SecurityUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebFlux;

@EnableSwagger2WebFlux
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
public class ExplicitWebfluxSecurityConfig
implements WebFluxConfigurer {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ReactiveRedisTemplate<String, String> reactiveRedisTemplate;

    private AuthenticationWebFilter tokenAuthenticationFilter() {
        AuthenticationWebFilter filter = new AuthenticationWebFilter(this.tokenAuthenticationManager());
        filter.setServerAuthenticationConverter(this.tokenAuthenticationConverter()::apply);
        filter.setAuthenticationFailureHandler((exchange, exception) -> Mono.error((Throwable)exception));
        return filter;
    }

    private Function<ServerWebExchange, Mono<Authentication>> tokenAuthenticationConverter() {
        return serverWebExchange -> {
            String authorization = serverWebExchange.getRequest().getHeaders().getFirst("Authorization");
            if (StringUtils.isEmpty((CharSequence)authorization)) {
                return Mono.empty();
            }
            return Mono.just((Object)((Object)new JwtAuthenticationToken(authorization)));
        };
    }

    private ReactiveAuthenticationManager tokenAuthenticationManager() {
        return authentication -> {
            String token = (String)authentication.getCredentials();
            return this.reactiveRedisTemplate.opsForValue().get((Object)token).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)LoginRuntimeException.of((String)"\u672a\u627e\u5230token")))).map(securityUserStr -> {
                SecurityUser securityUser = null;
                try {
                    securityUser = (SecurityUser)this.objectMapper.readValue(securityUserStr, SecurityUser.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return securityUser;
            }).map(securityUser -> new JwtAuthenticationToken((UserDetails)securityUser, token, securityUser.getAuthorities()));
        };
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        return ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.authorizeExchange().pathMatchers(new String[]{"/loginByPhoneSms"})).permitAll().pathMatchers(new String[]{"/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**"})).permitAll().anyExchange().authenticated().and().securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance()).exceptionHandling().authenticationEntryPoint((exchange, e) -> Mono.fromRunnable(() -> exchange.getResponse().setStatusCode(HttpStatus.UNAUTHORIZED))).accessDeniedHandler((exchange, e) -> Mono.fromRunnable(() -> exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN))).and().headers().cache().disable().and().csrf().disable().formLogin().disable().logout().disable().addFilterAt((WebFilter)this.tokenAuthenticationFilter(), SecurityWebFiltersOrder.AUTHENTICATION).build();
    }

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"org.rxjava")).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Swagger\u6784\u5efaRESTful API").description("").termsOfServiceUrl("").version("1.0").build();
    }
}

