/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.security.example.entity;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.rxjava.security.example.entity.Role;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUser
implements UserDetails {
    private String userAuthId;
    private String userId;
    private List<Role> roles;
    private String identityType;
    private String identifier;

    public SecurityUser(String userAuthId, String userId, String identifier, String identityType, List<Role> roles) {
        this.userAuthId = userAuthId;
        this.userId = userId;
        this.identifier = identifier;
        this.identityType = identityType;
        this.roles = roles;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return AuthorityUtils.commaSeparatedStringToAuthorityList((String)this.getRoles().stream().map(rn -> "ROLE_" + rn.getEnglishName()).collect(Collectors.joining(",")));
    }

    public String getPassword() {
        return this.getIdentityType();
    }

    public String getUsername() {
        return this.getIdentifier();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getUserAuthId() {
        return this.userAuthId;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public String getIdentityType() {
        return this.identityType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setUserAuthId(String userAuthId) {
        this.userAuthId = userAuthId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityUser)) {
            return false;
        }
        SecurityUser other = (SecurityUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userAuthId = this.getUserAuthId();
        String other$userAuthId = other.getUserAuthId();
        if (this$userAuthId == null ? other$userAuthId != null : !this$userAuthId.equals(other$userAuthId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        List<Role> this$roles = this.getRoles();
        List<Role> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$identityType = this.getIdentityType();
        String other$identityType = other.getIdentityType();
        if (this$identityType == null ? other$identityType != null : !this$identityType.equals(other$identityType)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userAuthId = this.getUserAuthId();
        result = result * 59 + ($userAuthId == null ? 43 : $userAuthId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        List<Role> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $identityType = this.getIdentityType();
        result = result * 59 + ($identityType == null ? 43 : $identityType.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        return result;
    }

    public String toString() {
        return "SecurityUser(userAuthId=" + this.getUserAuthId() + ", userId=" + this.getUserId() + ", roles=" + this.getRoles() + ", identityType=" + this.getIdentityType() + ", identifier=" + this.getIdentifier() + ")";
    }

    public SecurityUser() {
    }
}

