/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.CubicSplineSegment;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;

public class CubicSplineCurve {
    private float totalCurveLength;
    private CubicSplineSegment[] cubicSplineSegment;
    public int numSegments;

    CubicSplineCurve() {
        this.numSegments = 0;
        this.totalCurveLength = 0.0f;
    }

    CubicSplineCurve(TCBKeyFrame[] keys) {
        int keyLength = keys.length;
        if (keyLength < 4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("CubicSplineCurve0"));
        }
        this.numSegments = keyLength - 3;
        this.cubicSplineSegment = new CubicSplineSegment[this.numSegments];
        int k0 = 0;
        int k1 = 1;
        int k2 = 2;
        int k3 = 3;
        while (k0 < this.numSegments) {
            this.cubicSplineSegment[k0] = new CubicSplineSegment(keys[k0], keys[k1], keys[k2], keys[k3]);
            ++k0;
            ++k1;
            ++k2;
            ++k3;
        }
        this.computeTotalCurveLength();
    }

    CubicSplineCurve(CubicSplineSegment[] s) {
        this.cubicSplineSegment = new CubicSplineSegment[s.length];
        this.numSegments = this.cubicSplineSegment.length;
        for (int i = 0; i < this.numSegments; ++i) {
            this.cubicSplineSegment[i] = s[i];
        }
        this.computeTotalCurveLength();
    }

    public void setSegments(CubicSplineSegment[] s) {
        this.cubicSplineSegment = new CubicSplineSegment[s.length];
        this.numSegments = this.cubicSplineSegment.length;
        for (int i = 0; i < this.numSegments; ++i) {
            this.cubicSplineSegment[i] = s[i];
        }
        this.computeTotalCurveLength();
    }

    public CubicSplineSegment getSegment(int index) {
        return this.cubicSplineSegment[index];
    }

    private void computeTotalCurveLength() {
        this.totalCurveLength = 0.0f;
        for (int i = 0; i < this.numSegments; ++i) {
            this.totalCurveLength += this.cubicSplineSegment[i].length;
        }
    }

    public float getTotalCurveLength() {
        return this.totalCurveLength;
    }
}

